/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.google.common.collect.ImmutableList;
import hudson.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class VcsRepositoryFilter {
    public static final VcsRepositoryFilter EMPTY = new VcsRepositoryFilter("", Collections.emptyList(), Collections.emptyList());
    public static final String INCLUSION_QUALIFIER = "+:";
    public static final String EXCLUSION_QUALIFIER = "-:";
    public static final String SEPARATOR = "\n";
    private final String vcsRepositoryFilter;
    private final List<String> inclusion;
    private final List<String> exclusion;

    private VcsRepositoryFilter(String vcsRepositoryFilter, List<String> inclusion, List<String> exclusion) {
        this.vcsRepositoryFilter = vcsRepositoryFilter;
        this.inclusion = inclusion;
        this.exclusion = exclusion;
    }

    static VcsRepositoryFilter of(String vcsRepositoryFilter) {
        String filter = Util.fixEmptyAndTrim((String)vcsRepositoryFilter);
        if (filter == null) {
            return EMPTY;
        }
        ArrayList inclusionFilters = new ArrayList();
        ArrayList exclusionFilters = new ArrayList();
        Arrays.stream(filter.split(SEPARATOR)).map(Util::fixEmptyAndTrim).filter(Objects::nonNull).forEach(pattern -> {
            String candidate;
            if (pattern.startsWith(INCLUSION_QUALIFIER)) {
                String candidate2 = Util.fixEmptyAndTrim((String)pattern.substring(INCLUSION_QUALIFIER.length()));
                if (candidate2 != null) {
                    inclusionFilters.add(candidate2);
                }
            } else if (pattern.startsWith(EXCLUSION_QUALIFIER) && (candidate = Util.fixEmptyAndTrim((String)pattern.substring(EXCLUSION_QUALIFIER.length()))) != null) {
                exclusionFilters.add(candidate);
            }
        });
        return new VcsRepositoryFilter(filter, (List<String>)ImmutableList.copyOf(inclusionFilters), (List<String>)ImmutableList.copyOf(exclusionFilters));
    }

    boolean isEmpty() {
        return this.inclusion.isEmpty() && this.exclusion.isEmpty();
    }

    public Result matches(String url) {
        if (this.matchesRepositoryFilter(url, this.exclusion)) {
            return Result.EXCLUDED;
        }
        if (this.matchesRepositoryFilter(url, this.inclusion)) {
            return Result.INCLUDED;
        }
        return Result.NOT_MATCHED;
    }

    private boolean matchesRepositoryFilter(String repositoryUrl, Collection<String> patterns) {
        if (Util.fixEmptyAndTrim((String)repositoryUrl) == null) {
            return false;
        }
        for (String pattern : patterns) {
            if (!repositoryUrl.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    String getVcsRepositoryFilter() {
        return this.vcsRepositoryFilter;
    }

    static enum Result {
        INCLUDED,
        EXCLUDED,
        NOT_MATCHED;

    }
}

