/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SystemProperty {
    private static final Pattern SYS_PROP_PATTERN = Pattern.compile("-D(.*)=(.*)");
    private final Key key;
    private final String value;

    public SystemProperty(Key key, String value) {
        this.key = key;
        this.value = value;
    }

    public String asString() {
        return String.format("-D%s=%s", this.key.name, this.value);
    }

    public Key getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static SystemProperty parse(String sysProp) {
        Matcher matcher = SYS_PROP_PATTERN.matcher(sysProp);
        if (matcher.matches()) {
            return new SystemProperty(Key.optional(matcher.group(1)), matcher.group(2));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemProperty that = (SystemProperty)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public static final class Key {
        public final String name;
        public final boolean required;

        private Key(String name, boolean required) {
            this.name = name;
            this.required = required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.required == key.required && Objects.equals(this.name, key.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.required);
        }

        public static Key required(String key) {
            return new Key(key, true);
        }

        public static Key optional(String key) {
            return new Key(key, false);
        }
    }
}

