/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import hudson.plugins.gradle.injection.MavenExtClasspathUtils;
import hudson.plugins.gradle.injection.MavenExtension;
import hudson.plugins.gradle.injection.MavenInjectionAware;
import hudson.plugins.gradle.injection.MavenOptsHandler;
import hudson.plugins.gradle.injection.SystemProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MavenOptsDevelocityFilter {
    private static final MavenOptsHandler handler = new MavenOptsHandler(MavenInjectionAware.BUILD_SCAN_UPLOAD_IN_BACKGROUND_PROPERTY_KEY, MavenInjectionAware.GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY, MavenInjectionAware.GRADLE_ENTERPRISE_URL_PROPERTY_KEY, MavenInjectionAware.DEVELOCITY_UPLOAD_IN_BACKGROUND_PROPERTY_KEY, MavenInjectionAware.DEVELOCITY_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY, MavenInjectionAware.DEVELOCITY_URL_PROPERTY_KEY, MavenInjectionAware.DEVELOCITY_CUSTOM_VALUE_KEY);
    private final Set<MavenExtension> knownExtensionsAlreadyApplied;
    private final boolean isUnix;

    public MavenOptsDevelocityFilter(Set<MavenExtension> knownExtensionsAlreadyApplied, boolean isUnix) {
        this.knownExtensionsAlreadyApplied = Sets.immutableEnumSet(knownExtensionsAlreadyApplied);
        this.isUnix = isUnix;
    }

    String filter(String mavenOpts, boolean enforceUrl) {
        mavenOpts = this.removeKnownExtensionsFromExtClasspath(mavenOpts);
        if (this.knownExtensionsAlreadyApplied.contains((Object)MavenExtension.DEVELOCITY) || this.knownExtensionsAlreadyApplied.contains((Object)MavenExtension.GRADLE_ENTERPRISE)) {
            HashSet<String> keysToKeep = new HashSet<String>();
            if (enforceUrl) {
                keysToKeep.add(MavenInjectionAware.DEVELOCITY_URL_PROPERTY_KEY.name);
                keysToKeep.add(MavenInjectionAware.GRADLE_ENTERPRISE_URL_PROPERTY_KEY.name);
            }
            mavenOpts = Strings.nullToEmpty((String)handler.removeIfNeeded(mavenOpts, keysToKeep));
        }
        return mavenOpts;
    }

    private String removeKnownExtensionsFromExtClasspath(String mavenOpts) {
        return Arrays.stream(mavenOpts.split(" ")).map(s -> {
            SystemProperty sysProp = SystemProperty.parse(s);
            return MavenOptsDevelocityFilter.isMavenExtClasspath(sysProp) ? this.filterExtClassPath(sysProp) : s;
        }).filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    private String filterExtClassPath(SystemProperty sysProp) {
        String cp = Arrays.stream(sysProp.getValue().split(MavenExtClasspathUtils.getDelimiter(this.isUnix))).filter(lib -> !this.isKnownExtension((String)lib)).collect(Collectors.joining(MavenExtClasspathUtils.getDelimiter(this.isUnix)));
        return cp.isEmpty() ? null : new SystemProperty(MavenInjectionAware.MAVEN_EXT_CLASS_PATH_PROPERTY_KEY, cp).asString();
    }

    private static boolean isMavenExtClasspath(SystemProperty sysProp) {
        return sysProp != null && MavenInjectionAware.MAVEN_EXT_CLASS_PATH_PROPERTY_KEY.name.equals(sysProp.getKey().name);
    }

    private boolean isKnownExtension(String lib) {
        return this.knownExtensionsAlreadyApplied.stream().map(MavenExtension::getTargetJarName).anyMatch(lib::contains);
    }
}

