/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.model.Node;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenOptsHandler;
import hudson.plugins.gradle.injection.NodeLabelItem;
import hudson.plugins.gradle.injection.SystemProperty;
import hudson.plugins.gradle.util.CollectionUtil;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public interface MavenInjectionAware {
    public static final String JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_EXT_CLASSPATH = "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_EXT_CLASSPATH";
    public static final String JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_SERVER_URL = "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_SERVER_URL";
    public static final String JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_ALLOW_UNTRUSTED_SERVER = "JENKINSGRADLEPLUGIN_MAVEN_PLUGIN_CONFIG_ALLOW_UNTRUSTED_SERVER";
    public static final SystemProperty.Key DEVELOCITY_URL_PROPERTY_KEY = SystemProperty.Key.required("develocity.url");
    public static final SystemProperty.Key GRADLE_ENTERPRISE_URL_PROPERTY_KEY = SystemProperty.Key.required("gradle.enterprise.url");
    public static final SystemProperty.Key BUILD_SCAN_UPLOAD_IN_BACKGROUND_PROPERTY_KEY = SystemProperty.Key.required("gradle.scan.uploadInBackground");
    public static final SystemProperty.Key DEVELOCITY_UPLOAD_IN_BACKGROUND_PROPERTY_KEY = SystemProperty.Key.required("develocity.scan.uploadInBackground");
    public static final SystemProperty.Key MAVEN_EXT_CLASS_PATH_PROPERTY_KEY = SystemProperty.Key.required("maven.ext.class.path");
    public static final SystemProperty.Key GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY = SystemProperty.Key.optional("gradle.enterprise.allowUntrustedServer");
    public static final SystemProperty.Key DEVELOCITY_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY = SystemProperty.Key.optional("develocity.allowUntrustedServer");
    public static final SystemProperty.Key GRADLE_ENTERPRISE_CAPTURE_GOAL_INPUT_FILES_PROPERTY_KEY = SystemProperty.Key.optional("gradle.scan.captureGoalInputFiles");
    public static final SystemProperty.Key DEVELOCITY_CAPTURE_FILE_FINGERPRINTS_PROPERTY_KEY = SystemProperty.Key.optional("develocity.scan.captureFileFingerprints");
    public static final SystemProperty.Key DEVELOCITY_CUSTOM_VALUE_KEY = SystemProperty.Key.optional("scan.value.CIAutoInjection");
    public static final MavenOptsHandler MAVEN_OPTS_HANDLER = new MavenOptsHandler(MAVEN_EXT_CLASS_PATH_PROPERTY_KEY, BUILD_SCAN_UPLOAD_IN_BACKGROUND_PROPERTY_KEY, GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY, GRADLE_ENTERPRISE_URL_PROPERTY_KEY, GRADLE_ENTERPRISE_CAPTURE_GOAL_INPUT_FILES_PROPERTY_KEY, DEVELOCITY_ALLOW_UNTRUSTED_SERVER_PROPERTY_KEY, DEVELOCITY_UPLOAD_IN_BACKGROUND_PROPERTY_KEY, DEVELOCITY_URL_PROPERTY_KEY, DEVELOCITY_CAPTURE_FILE_FINGERPRINTS_PROPERTY_KEY, DEVELOCITY_CUSTOM_VALUE_KEY);

    default public boolean isInjectionDisabledGlobally(InjectionConfig config) {
        return config.isDisabled() || InjectionUtil.isAnyInvalid(InjectionConfig.checkRequiredUrl(config.getServer()), InjectionConfig.checkRequiredVersion(config.getMavenExtensionVersion()));
    }

    default public boolean isInjectionEnabledForNode(InjectionConfig config, Node node) {
        if (this.isInjectionDisabledGlobally(config)) {
            return false;
        }
        Set<String> disabledNodes = CollectionUtil.safeStream(config.getMavenInjectionDisabledNodes()).map(NodeLabelItem::getLabel).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> enabledNodes = CollectionUtil.safeStream(config.getMavenInjectionEnabledNodes()).map(NodeLabelItem::getLabel).filter(Objects::nonNull).collect(Collectors.toSet());
        return InjectionUtil.isInjectionEnabledForNode(() -> ((Node)node).getAssignedLabels(), disabledNodes, enabledNodes);
    }
}

