/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import hudson.FilePath;
import hudson.plugins.gradle.injection.CopyUtil;
import hudson.plugins.gradle.injection.MavenExtension;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MavenExtensionsHandler {
    static final String LIB_DIR_PATH = "jenkins-gradle-plugin/lib";
    private final Map<MavenExtension, MavenExtensionFileHandler> fileHandlers = Arrays.stream(MavenExtension.values()).map(MavenExtensionFileHandler::new).collect(Collectors.toMap(h -> h.extension, Function.identity()));

    public FilePath copyExtensionToAgent(MavenExtension extension, FilePath rootPath) throws IOException, InterruptedException {
        return this.fileHandlers.get((Object)extension).copyExtensionToAgent(rootPath);
    }

    public FilePath copyExtensionToAgent(MavenExtension extension, FilePath controllerRootPath, FilePath rootPath, String digest) throws IOException, InterruptedException {
        return this.fileHandlers.get((Object)extension).copyExtensionToAgent(controllerRootPath, rootPath, digest);
    }

    public void deleteExtensionFromAgent(MavenExtension extension, FilePath rootPath) throws IOException, InterruptedException {
        this.fileHandlers.get((Object)extension).deleteExtensionFromAgent(rootPath);
    }

    public void deleteAllExtensionsFromAgent(FilePath rootPath) throws IOException, InterruptedException {
        rootPath.child(LIB_DIR_PATH).deleteContents();
    }

    private static final class MavenExtensionFileHandler {
        private final MavenExtension extension;
        private final Supplier<String> extensionDigest;

        MavenExtensionFileHandler(MavenExtension extension) {
            this.extension = extension;
            this.extensionDigest = Suppliers.memoize(() -> CopyUtil.unsafeResourceDigest(extension.getEmbeddedJarName()));
        }

        public FilePath copyExtensionToAgent(FilePath rootPath) throws IOException, InterruptedException {
            FilePath extensionLocation = this.getExtensionLocation(rootPath);
            if (this.extensionChanged(extensionLocation)) {
                CopyUtil.copyResourceToNode(extensionLocation, this.extension.getEmbeddedJarName());
            }
            return extensionLocation;
        }

        public FilePath copyExtensionToAgent(FilePath controllerRootPath, FilePath rootPath, String digest) throws IOException, InterruptedException {
            FilePath extensionLocation = this.getExtensionLocation(rootPath);
            if (this.extensionChanged(extensionLocation, digest)) {
                CopyUtil.copyDownloadedResourceToNode(controllerRootPath, extensionLocation, this.extension.getEmbeddedJarName());
            }
            return extensionLocation;
        }

        public void deleteExtensionFromAgent(FilePath rootPath) throws IOException, InterruptedException {
            FilePath extensionLocation = this.getExtensionLocation(rootPath);
            if (extensionLocation.exists()) {
                extensionLocation.delete();
            }
        }

        private FilePath getExtensionLocation(FilePath rootPath) {
            return rootPath.child(MavenExtensionsHandler.LIB_DIR_PATH).child(this.extension.getTargetJarName());
        }

        private boolean extensionChanged(FilePath nodePath) throws IOException, InterruptedException {
            return this.extensionChanged(nodePath, (String)this.extensionDigest.get());
        }

        private boolean extensionChanged(FilePath nodePath, String digest) throws IOException, InterruptedException {
            if (!nodePath.exists()) {
                return true;
            }
            String existingFileDigest = nodePath.digest();
            return !Objects.equals(existingFileDigest, digest);
        }
    }
}

