/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Util;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenExtension;
import hudson.plugins.gradle.injection.MavenInjectionAware;
import hudson.plugins.gradle.injection.extension.ExtensionClient;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MavenExtensionDownloadHandler
implements MavenInjectionAware {
    public static final String DOWNLOAD_CACHE_DIR = "jenkins-gradle-plugin/cache";
    private final ExtensionClient extensionClient = new ExtensionClient();

    public Map<MavenExtension, String> ensureExtensionsDownloaded(Supplier<File> root, InjectionConfig injectionConfig) throws IOException {
        if (!this.isInjectionDisabledGlobally(injectionConfig)) {
            HashMap<MavenExtension, String> extensionsDigest = new HashMap<MavenExtension, String>();
            Path cacheDir = root.get().toPath().resolve(DOWNLOAD_CACHE_DIR);
            MavenExtension develocityMavenExtension = MavenExtension.getDevelocityMavenExtension(injectionConfig.getMavenExtensionVersion());
            extensionsDigest.put(develocityMavenExtension, this.getOrDownloadExtensionDigest(injectionConfig, cacheDir, develocityMavenExtension));
            if (InjectionUtil.isValid(InjectionConfig.checkRequiredVersion(injectionConfig.getCcudExtensionVersion()))) {
                extensionsDigest.put(MavenExtension.CCUD, this.getOrDownloadExtensionDigest(injectionConfig, cacheDir, MavenExtension.CCUD));
            }
            return extensionsDigest;
        }
        return Collections.emptyMap();
    }

    public Map<MavenExtension, String> getExtensionDigests(Supplier<File> rootDir, InjectionConfig injectionConfig) throws IOException {
        if (!this.isInjectionDisabledGlobally(injectionConfig)) {
            HashMap<MavenExtension, String> extensionDigests = new HashMap<MavenExtension, String>();
            Path cacheDir = rootDir.get().toPath().resolve(DOWNLOAD_CACHE_DIR);
            MavenExtension develocityMavenExtension = MavenExtension.getDevelocityMavenExtension(injectionConfig.getMavenExtensionVersion());
            MavenExtensionDownloadHandler.getExtensionDigest(cacheDir, develocityMavenExtension).ifPresent(it -> extensionDigests.put(develocityMavenExtension, (String)it));
            if (InjectionUtil.isValid(InjectionConfig.checkRequiredVersion(injectionConfig.getCcudExtensionVersion()))) {
                MavenExtensionDownloadHandler.getExtensionDigest(cacheDir, MavenExtension.CCUD).ifPresent(it -> extensionDigests.put(MavenExtension.CCUD, (String)it));
            }
            return extensionDigests;
        }
        return Collections.emptyMap();
    }

    private static Optional<String> getExtensionDigest(Path parent, MavenExtension extension) throws IOException {
        Path metadataFile = parent.resolve(extension.getDownloadMetadataFileName());
        if (Files.exists(metadataFile, new LinkOption[0])) {
            String[] metadata = Files.readString(metadataFile).split(",");
            return Optional.of(metadata[1]);
        }
        return Optional.empty();
    }

    private String getOrDownloadExtensionDigest(InjectionConfig injectionConfig, Path parent, MavenExtension extension) throws IOException {
        String version;
        Path metadataFile = parent.resolve(extension.getDownloadMetadataFileName());
        String string = version = extension == MavenExtension.CCUD ? injectionConfig.getCcudExtensionVersion() : injectionConfig.getMavenExtensionVersion();
        if (Files.exists(metadataFile, new LinkOption[0])) {
            String[] metadata = Files.readString(metadataFile).split(",");
            String extensionVersion = metadata[0];
            String extensionDigest = metadata[1];
            if (!extensionVersion.equals(version)) {
                return this.downloadExtension(injectionConfig, parent, extension, metadataFile, version);
            }
            return extensionDigest;
        }
        return this.downloadExtension(injectionConfig, parent, extension, metadataFile, version);
    }

    private String downloadExtension(InjectionConfig injectionConfig, Path parent, MavenExtension extension, Path metadataFile, String version) throws IOException {
        Files.createDirectories(parent, new FileAttribute[0]);
        Path jarFile = parent.resolve(extension.getEmbeddedJarName());
        URI downloadUrl = extension.createDownloadUrl(version, injectionConfig.getMavenExtensionRepositoryUrl());
        MavenExtension.RepositoryCredentials repositoryCredentials = MavenExtensionDownloadHandler.getRepositoryCredentials(injectionConfig.getMavenExtensionRepositoryCredentialId());
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
            this.extensionClient.downloadExtension(downloadUrl, repositoryCredentials, outputStream);
        }
        String digest = Util.getDigestOf((File)jarFile.toFile());
        Files.writeString(metadataFile, (CharSequence)(version + "," + digest), new OpenOption[0]);
        return digest;
    }

    private static MavenExtension.RepositoryCredentials getRepositoryCredentials(String repositoryCredentialId) {
        if (repositoryCredentialId == null) {
            return null;
        }
        List allCredentials = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, null, null);
        return allCredentials.stream().filter(it -> it.getId().equals(repositoryCredentialId)).findFirst().map(it -> new MavenExtension.RepositoryCredentials(it.getUsername(), it.getPassword().getPlainText())).orElse(null);
    }
}

