/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.plugins.gradle.Messages;
import hudson.plugins.gradle.injection.DevelocityAccessCredentials;
import hudson.plugins.gradle.injection.DevelocityVersionValidator;
import hudson.plugins.gradle.injection.EnvUtil;
import hudson.plugins.gradle.injection.HttpUrlValidator;
import hudson.plugins.gradle.injection.InjectionUtil;
import hudson.plugins.gradle.injection.MavenCoordinates;
import hudson.plugins.gradle.injection.NodeLabelItem;
import hudson.plugins.gradle.injection.UnsupportedMavenPluginWarningDetails;
import hudson.plugins.gradle.injection.VcsRepositoryFilter;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
public class InjectionConfig
extends GlobalConfiguration {
    private static final String GIT_PLUGIN_SHORT_NAME = "git";
    private static final Set<String> LEGACY_GLOBAL_ENVIRONMENT_VARIABLES = ImmutableSet.of((Object)"JENKINSGRADLEPLUGIN_GRADLE_ENTERPRISE_INJECTION", (Object)"JENKINSGRADLEPLUGIN_GRADLE_ENTERPRISE_URL", (Object)"JENKINSGRADLEPLUGIN_GRADLE_ENTERPRISE_ALLOW_UNTRUSTED_SERVER", (Object)"GRADLE_ENTERPRISE_ACCESS_KEY", (Object)"JENKINSGRADLEPLUGIN_GRADLE_ENTERPRISE_PLUGIN_VERSION", (Object)"JENKINSGRADLEPLUGIN_CCUD_PLUGIN_VERSION", (Object[])new String[]{"JENKINSGRADLEPLUGIN_GRADLE_PLUGIN_REPOSITORY_URL", "JENKINSGRADLEPLUGIN_GRADLE_INJECTION_ENABLED_NODES", "JENKINSGRADLEPLUGIN_GRADLE_INJECTION_DISABLED_NODES", "JENKINSGRADLEPLUGIN_GRADLE_ENTERPRISE_EXTENSION_VERSION", "JENKINSGRADLEPLUGIN_CCUD_EXTENSION_VERSION", "JENKINSGRADLEPLUGIN_MAVEN_INJECTION_ENABLED_NODES", "JENKINSGRADLEPLUGIN_MAVEN_INJECTION_DISABLED_NODES"});
    private boolean enabled;
    private String server;
    private boolean allowUntrusted;
    private Secret accessKey;
    private String accessKeyCredentialId;
    private Integer shortLivedTokenExpiry;
    private String gradlePluginVersion;
    private String ccudPluginVersion;
    private String gradlePluginRepositoryUrl;
    private String gradlePluginRepositoryUsername;
    private Secret gradlePluginRepositoryPassword;
    private String gradlePluginRepositoryCredentialId;
    private ImmutableList<NodeLabelItem> gradleInjectionEnabledNodes;
    private ImmutableList<NodeLabelItem> gradleInjectionDisabledNodes;
    private Boolean gradleCaptureTaskInputFiles;
    private String mavenExtensionVersion;
    private String ccudExtensionVersion;
    private String mavenExtensionRepositoryUrl;
    private String mavenExtensionRepositoryCredentialId;
    private String mavenExtensionCustomCoordinates;
    private String ccudExtensionCustomCoordinates;
    private ImmutableList<NodeLabelItem> mavenInjectionEnabledNodes;
    private ImmutableList<NodeLabelItem> mavenInjectionDisabledNodes;
    private Boolean mavenCaptureGoalInputFiles;
    private boolean enforceUrl;
    private boolean checkForBuildAgentErrors;
    private transient String injectionVcsRepositoryPatterns;
    private VcsRepositoryFilter parsedVcsRepositoryFilter = VcsRepositoryFilter.EMPTY;
    private transient boolean injectMavenExtension;
    private transient boolean injectCcudExtension;

    public InjectionConfig() {
        this.load();
    }

    public static InjectionConfig get() {
        return (InjectionConfig)((Object)ExtensionList.lookupSingleton(InjectionConfig.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Restricted(value={NoExternalUse.class})
    public boolean isShowLegacyConfigurationWarning() {
        EnvVars envVars = EnvUtil.globalEnvironment();
        if (envVars == null) return false;
        if (!LEGACY_GLOBAL_ENVIRONMENT_VARIABLES.stream().anyMatch(arg_0 -> envVars.containsKey(arg_0))) return false;
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public UnsupportedMavenPluginWarningDetails getUnsupportedMavenPluginWarningDetails() {
        VersionNumber mavenPluginVersion = InjectionUtil.mavenPluginVersionNumber().orElse(null);
        return mavenPluginVersion == null || InjectionUtil.isSupportedMavenPluginVersion(mavenPluginVersion) ? null : new UnsupportedMavenPluginWarningDetails(mavenPluginVersion);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isGitPluginInstalled() {
        return InjectionUtil.maybeGetPlugin(GIT_PLUGIN_SHORT_NAME).isPresent();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @CheckForNull
    public String getServer() {
        return this.server;
    }

    @DataBoundSetter
    public void setServer(String server) {
        this.server = Util.fixEmptyAndTrim((String)server);
    }

    public boolean isAllowUntrusted() {
        return this.allowUntrusted;
    }

    @DataBoundSetter
    public void setAllowUntrusted(boolean allowUntrusted) {
        this.allowUntrusted = allowUntrusted;
    }

    @CheckForNull
    public String getAccessKeyCredentialId() {
        return this.accessKeyCredentialId;
    }

    @DataBoundSetter
    public void setAccessKeyCredentialId(String accessKeyCredentialId) {
        this.accessKeyCredentialId = Util.fixEmptyAndTrim((String)accessKeyCredentialId);
    }

    @CheckForNull
    public Integer getShortLivedTokenExpiry() {
        return this.shortLivedTokenExpiry;
    }

    @DataBoundSetter
    public void setShortLivedTokenExpiry(Integer shortLivedTokenExpiry) {
        this.shortLivedTokenExpiry = shortLivedTokenExpiry;
    }

    @CheckForNull
    public String getGradlePluginRepositoryCredentialId() {
        return this.gradlePluginRepositoryCredentialId;
    }

    @DataBoundSetter
    public void setGradlePluginRepositoryCredentialId(String gradlePluginRepositoryCredentialId) {
        this.gradlePluginRepositoryCredentialId = Util.fixEmptyAndTrim((String)gradlePluginRepositoryCredentialId);
    }

    @CheckForNull
    public String getGradlePluginVersion() {
        return this.gradlePluginVersion;
    }

    @DataBoundSetter
    public void setGradlePluginVersion(String gradlePluginVersion) {
        this.gradlePluginVersion = Util.fixEmptyAndTrim((String)gradlePluginVersion);
    }

    @CheckForNull
    public String getCcudPluginVersion() {
        return this.ccudPluginVersion;
    }

    @DataBoundSetter
    public void setCcudPluginVersion(String ccudPluginVersion) {
        this.ccudPluginVersion = Util.fixEmptyAndTrim((String)ccudPluginVersion);
    }

    @CheckForNull
    public String getGradlePluginRepositoryUrl() {
        return this.gradlePluginRepositoryUrl;
    }

    @DataBoundSetter
    public void setGradlePluginRepositoryUrl(String gradlePluginRepositoryUrl) {
        this.gradlePluginRepositoryUrl = Util.fixEmptyAndTrim((String)gradlePluginRepositoryUrl);
    }

    @CheckForNull
    public List<NodeLabelItem> getGradleInjectionEnabledNodes() {
        return this.gradleInjectionEnabledNodes;
    }

    @DataBoundSetter
    public void setGradleInjectionEnabledNodes(List<NodeLabelItem> gradleInjectionEnabledNodes) {
        this.gradleInjectionEnabledNodes = gradleInjectionEnabledNodes == null ? null : ImmutableList.copyOf(gradleInjectionEnabledNodes);
    }

    @CheckForNull
    public List<NodeLabelItem> getGradleInjectionDisabledNodes() {
        return this.gradleInjectionDisabledNodes;
    }

    @DataBoundSetter
    public void setGradleInjectionDisabledNodes(List<NodeLabelItem> gradleInjectionDisabledNodes) {
        this.gradleInjectionDisabledNodes = gradleInjectionDisabledNodes == null ? null : ImmutableList.copyOf(gradleInjectionDisabledNodes);
    }

    public Boolean isGradleCaptureTaskInputFiles() {
        return this.gradleCaptureTaskInputFiles;
    }

    @DataBoundSetter
    public void setGradleCaptureTaskInputFiles(Boolean gradleCaptureTaskInputFiles) {
        this.gradleCaptureTaskInputFiles = gradleCaptureTaskInputFiles;
    }

    public String getMavenExtensionVersion() {
        return this.mavenExtensionVersion;
    }

    @DataBoundSetter
    public void setMavenExtensionVersion(String mavenExtensionVersion) {
        this.mavenExtensionVersion = Util.fixEmptyAndTrim((String)mavenExtensionVersion);
    }

    @CheckForNull
    public String getMavenExtensionCustomCoordinates() {
        return this.mavenExtensionCustomCoordinates;
    }

    @DataBoundSetter
    public void setMavenExtensionCustomCoordinates(String mavenExtensionCustomCoordinates) {
        this.mavenExtensionCustomCoordinates = Util.fixEmptyAndTrim((String)mavenExtensionCustomCoordinates);
    }

    @CheckForNull
    public String getCcudExtensionCustomCoordinates() {
        return this.ccudExtensionCustomCoordinates;
    }

    @DataBoundSetter
    public void setCcudExtensionCustomCoordinates(String ccudExtensionCustomCoordinates) {
        this.ccudExtensionCustomCoordinates = Util.fixEmptyAndTrim((String)ccudExtensionCustomCoordinates);
    }

    public String getCcudExtensionVersion() {
        return this.ccudExtensionVersion;
    }

    @DataBoundSetter
    public void setCcudExtensionVersion(String ccudExtensionVersion) {
        this.ccudExtensionVersion = Util.fixEmptyAndTrim((String)ccudExtensionVersion);
    }

    @CheckForNull
    public String getMavenExtensionRepositoryUrl() {
        return this.mavenExtensionRepositoryUrl;
    }

    @DataBoundSetter
    public void setMavenExtensionRepositoryUrl(String mavenExtensionRepositoryUrl) {
        this.mavenExtensionRepositoryUrl = Util.fixEmptyAndTrim((String)mavenExtensionRepositoryUrl);
    }

    @CheckForNull
    public String getMavenExtensionRepositoryCredentialId() {
        return this.mavenExtensionRepositoryCredentialId;
    }

    @DataBoundSetter
    public void setMavenExtensionRepositoryCredentialId(String mavenExtensionRepositoryCredentialId) {
        this.mavenExtensionRepositoryCredentialId = Util.fixEmptyAndTrim((String)mavenExtensionRepositoryCredentialId);
    }

    @CheckForNull
    public List<NodeLabelItem> getMavenInjectionEnabledNodes() {
        return this.mavenInjectionEnabledNodes;
    }

    @DataBoundSetter
    public void setMavenInjectionEnabledNodes(List<NodeLabelItem> mavenInjectionEnabledNodes) {
        this.mavenInjectionEnabledNodes = mavenInjectionEnabledNodes == null ? null : ImmutableList.copyOf(mavenInjectionEnabledNodes);
    }

    @CheckForNull
    public List<NodeLabelItem> getMavenInjectionDisabledNodes() {
        return this.mavenInjectionDisabledNodes;
    }

    @DataBoundSetter
    public void setMavenInjectionDisabledNodes(List<NodeLabelItem> mavenInjectionDisabledNodes) {
        this.mavenInjectionDisabledNodes = mavenInjectionDisabledNodes == null ? null : ImmutableList.copyOf(mavenInjectionDisabledNodes);
    }

    public Boolean isMavenCaptureGoalInputFiles() {
        return this.mavenCaptureGoalInputFiles;
    }

    @DataBoundSetter
    public void setMavenCaptureGoalInputFiles(Boolean mavenCaptureGoalInputFiles) {
        this.mavenCaptureGoalInputFiles = mavenCaptureGoalInputFiles;
    }

    @DataBoundSetter
    public void setVcsRepositoryFilter(String vcsRepositoryFilter) {
        this.parsedVcsRepositoryFilter = VcsRepositoryFilter.of(vcsRepositoryFilter);
    }

    public boolean isEnforceUrl() {
        return this.enforceUrl;
    }

    @DataBoundSetter
    public void setEnforceUrl(boolean enforceUrl) {
        this.enforceUrl = enforceUrl;
    }

    public boolean isCheckForBuildAgentErrors() {
        return this.checkForBuildAgentErrors;
    }

    @DataBoundSetter
    public void setCheckForBuildAgentErrors(boolean checkForBuildAgentErrors) {
        this.checkForBuildAgentErrors = checkForBuildAgentErrors;
    }

    public boolean isInjectCcudExtension() {
        return this.injectCcudExtension;
    }

    @DataBoundSetter
    public void setInjectCcudExtension(boolean injectCcudExtension) {
        this.injectCcudExtension = injectCcudExtension;
    }

    public boolean isInjectMavenExtension() {
        return this.injectMavenExtension;
    }

    @DataBoundSetter
    public void setInjectMavenExtension(boolean injectMavenExtension) {
        this.injectMavenExtension = injectMavenExtension;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String getVcsRepositoryFilter() {
        return this.parsedVcsRepositoryFilter.getVcsRepositoryFilter();
    }

    public boolean hasRepositoryFilter() {
        return !this.parsedVcsRepositoryFilter.isEmpty();
    }

    public VcsRepositoryFilter.Result matchesRepositoryFilter(String repositoryUrl) {
        return this.parsedVcsRepositoryFilter.matches(repositoryUrl);
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        this.clearRepeatableProperties();
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    private void clearRepeatableProperties() {
        this.setGradleInjectionEnabledNodes(null);
        this.setGradleInjectionDisabledNodes(null);
        this.setMavenInjectionEnabledNodes(null);
        this.setMavenInjectionDisabledNodes(null);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckServer(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating Server URL requires 'Administer' permission");
        }
        return InjectionConfig.checkRequiredUrl(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckGradlePluginVersion(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating Gradle Plugin version requires 'Administer' permission");
        }
        return InjectionConfig.checkVersion(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckCcudPluginVersion(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating CCUD Plugin version requires 'Administer' permission");
        }
        return InjectionConfig.checkVersion(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckGradlePluginRepositoryUrl(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating Gradle Plugin repository URL requires 'Administer' permission");
        }
        return InjectionConfig.checkUrl(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckAccessKeyCredentialId(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating access key credential ID requires 'Administer' permission");
        }
        String accessKeyId = Util.fixEmptyAndTrim((String)value);
        if (accessKeyId == null) {
            return FormValidation.ok();
        }
        List credentials = CredentialsProvider.lookupCredentialsInItem(StringCredentials.class, null, null);
        String accessKeyFromCredentialId = credentials.stream().filter(it -> it.getId().equals(accessKeyId)).findFirst().map(it -> it.getSecret().getPlainText()).orElse(null);
        return DevelocityAccessCredentials.isValid(accessKeyFromCredentialId) ? FormValidation.ok() : FormValidation.error((String)Messages.InjectionConfig_InvalidAccessKey());
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckShortLivedTokenExpiry(@QueryParameter String value) {
        int expiry;
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating short-lived token expiry requires 'Administer' permission");
        }
        String shortLivedTokenExpiry = Util.fixEmptyAndTrim((String)value);
        if (shortLivedTokenExpiry == null) {
            return FormValidation.ok();
        }
        if (StringUtils.isNumeric((CharSequence)shortLivedTokenExpiry) && (expiry = Integer.parseInt(shortLivedTokenExpiry)) > 0 && expiry <= 24) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.InjectionConfig_InvalidShortLivedTokenExpiry());
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckMavenExtensionCustomCoordinates(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating Maven Extension custom coordinates requires 'Administer' permission");
        }
        return InjectionConfig.validateMavenCoordinates(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckCcudExtensionCustomCoordinates(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating Maven Extension custom coordinates requires 'Administer' permission");
        }
        return InjectionConfig.validateMavenCoordinates(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckMavenExtensionRepositoryUrl(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating Maven Extension repository URL requires 'Administer' permission");
        }
        return InjectionConfig.checkUrl(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckMavenExtensionVersion(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating Maven Extension version requires 'Administer' permission");
        }
        return InjectionConfig.checkVersion(value);
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckCcudExtensionVersion(@QueryParameter String value) {
        if (InjectionConfig.doesNotHaveAdministerPermission()) {
            return FormValidation.error((String)"Validating CCUD Extension version requires 'Administer' permission");
        }
        return InjectionConfig.checkVersion(value);
    }

    @POST
    public ListBoxModel doFillGradlePluginRepositoryCredentialIdItems(@AncestorInPath Item project) {
        return InjectionConfig.getAllCredentials(project);
    }

    @POST
    public ListBoxModel doFillMavenExtensionRepositoryCredentialIdItems(@AncestorInPath Item project) {
        return InjectionConfig.getAllCredentials(project);
    }

    @POST
    public ListBoxModel doFillAccessKeyCredentialIdItems(@AncestorInPath Item project) {
        return InjectionConfig.getAllCredentials(project);
    }

    private static ListBoxModel getAllCredentials(Item project) {
        StandardListBoxModel listBoxModel = new StandardListBoxModel();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && jenkins.hasPermission(Jenkins.ADMINISTER)) {
            listBoxModel.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, project, StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)})).includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}));
        }
        return listBoxModel;
    }

    private static FormValidation validateMavenCoordinates(String value) {
        String coord = Util.fixEmptyAndTrim((String)value);
        return coord == null || MavenCoordinates.isValid(coord) ? FormValidation.ok() : FormValidation.error((String)Messages.InjectionConfig_InvalidMavenExtensionCustomCoordinates());
    }

    public static FormValidation checkRequiredUrl(String value) {
        return InjectionConfig.checkUrl(value, true);
    }

    public static FormValidation checkUrl(String value) {
        return InjectionConfig.checkUrl(value, false);
    }

    private static FormValidation checkUrl(String value, boolean required) {
        String url = Util.fixEmptyAndTrim((String)value);
        if (url == null) {
            return required ? FormValidation.error((String)Messages.InjectionConfig_Required()) : FormValidation.ok();
        }
        return HttpUrlValidator.getInstance().isValid(url) ? FormValidation.ok() : FormValidation.error((String)Messages.InjectionConfig_InvalidUrl());
    }

    public static FormValidation checkRequiredVersion(String value) {
        return InjectionConfig.checkVersion(value, true);
    }

    public static FormValidation checkVersion(String value) {
        return InjectionConfig.checkVersion(value, false);
    }

    private static FormValidation checkVersion(String value, boolean required) {
        String version = Util.fixEmptyAndTrim((String)value);
        if (version == null) {
            return required ? FormValidation.error((String)Messages.InjectionConfig_Required()) : FormValidation.ok();
        }
        return DevelocityVersionValidator.getInstance().isValid(version) ? FormValidation.ok() : FormValidation.error((String)Messages.InjectionConfig_InvalidVersion());
    }

    protected Object readResolve() throws IOException, Descriptor.FormException {
        if (this.injectionVcsRepositoryPatterns != null) {
            String filters = InjectionConfig.migrateLegacyRepositoryFilters(this.injectionVcsRepositoryPatterns);
            this.parsedVcsRepositoryFilter = VcsRepositoryFilter.of(filters);
        }
        if (this.accessKey != null && this.accessKeyCredentialId == null) {
            StringCredentialsImpl stringCredentials = new StringCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), "Migrated Develocity Access Key", Secret.fromString((String)this.accessKey.getPlainText()));
            SystemCredentialsProvider.getInstance().getCredentials().add(stringCredentials);
            SystemCredentialsProvider.getInstance().save();
            this.setAccessKeyCredentialId(stringCredentials.getId());
            this.accessKey = null;
            this.save();
        }
        if (this.gradlePluginRepositoryUsername != null && this.gradlePluginRepositoryPassword != null && this.gradlePluginRepositoryCredentialId == null) {
            UsernamePasswordCredentialsImpl standardUsernameCredentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), "Migrated Gradle Plugin Respoitory credentials", this.gradlePluginRepositoryUsername, this.gradlePluginRepositoryPassword.getPlainText());
            SystemCredentialsProvider.getInstance().getCredentials().add(standardUsernameCredentials);
            SystemCredentialsProvider.getInstance().save();
            this.setGradlePluginRepositoryCredentialId(standardUsernameCredentials.getId());
            this.gradlePluginRepositoryUsername = null;
            this.gradlePluginRepositoryPassword = null;
            this.save();
        }
        return this;
    }

    private static String migrateLegacyRepositoryFilters(String injectionVcsRepositoryPatterns) {
        return Arrays.stream(injectionVcsRepositoryPatterns.split(",")).map(Util::fixEmptyAndTrim).filter(Objects::nonNull).map(p -> "+:" + p).collect(Collectors.joining("\n"));
    }

    private static boolean doesNotHaveAdministerPermission() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        return jenkins == null || !jenkins.hasPermission(Jenkins.ADMINISTER);
    }
}

