/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import hudson.FilePath;
import hudson.Util;
import java.io.IOException;
import java.io.InputStream;

public final class CopyUtil {
    private CopyUtil() {
    }

    public static void copyResourceToNode(FilePath nodePath, String resourceName) throws IOException, InterruptedException {
        CopyUtil.doWithResource(resourceName, is -> {
            nodePath.copyFrom(is);
            return null;
        });
    }

    public static void copyDownloadedResourceToNode(FilePath controllerRootPath, FilePath nodePath, String resourceName) throws IOException, InterruptedException {
        nodePath.copyFrom(controllerRootPath.child("jenkins-gradle-plugin/cache").child(resourceName));
    }

    public static String unsafeResourceDigest(String resourceName) {
        try {
            return CopyUtil.doWithResource(resourceName, Util::getDigestOf);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> T doWithResource(String resourceName, CheckedFunction<InputStream, T> action) throws IOException, InterruptedException {
        try (InputStream is = CopyUtil.class.getResourceAsStream("/hudson/plugins/gradle/injection/" + resourceName);){
            if (is == null) {
                throw new IllegalStateException("Could not find resource: " + resourceName);
            }
            T t = action.apply(is);
            return t;
        }
    }

    @FunctionalInterface
    private static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException, InterruptedException;
    }
}

