/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.injection;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.EnvironmentContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.PasswordParameterValue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.gradle.DevelocityLogger;
import hudson.plugins.gradle.injection.DevelocityAccessCredentials;
import hudson.plugins.gradle.injection.InitScriptVariables;
import hudson.plugins.gradle.injection.InjectionConfig;
import hudson.plugins.gradle.injection.token.ShortLivedTokenClient;
import hudson.plugins.gradle.injection.token.ShortLivedTokenClientFactory;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

@Extension
public class BuildScanEnvironmentContributor
extends EnvironmentContributor {
    private final ShortLivedTokenClientFactory shortLivedTokenClientFactory;

    public BuildScanEnvironmentContributor() {
        this.shortLivedTokenClientFactory = new ShortLivedTokenClientFactory();
    }

    public BuildScanEnvironmentContributor(ShortLivedTokenClientFactory shortLivedTokenClientFactory) {
        this.shortLivedTokenClientFactory = shortLivedTokenClientFactory;
    }

    public void buildEnvironmentFor(@Nonnull Run run, @Nonnull EnvVars envs, @Nonnull TaskListener listener) {
        if (BuildScanEnvironmentContributor.alreadyExecuted(run)) {
            return;
        }
        String accessKeyCredentialId = InjectionConfig.get().getAccessKeyCredentialId();
        String gradlePluginRepositoryCredentialId = InjectionConfig.get().getGradlePluginRepositoryCredentialId();
        Secret secretKey = Optional.ofNullable(accessKeyCredentialId).map(it -> (StringCredentials)CredentialsProvider.findCredentialById((String)it, StringCredentials.class, (Run)run)).map(StringCredentials::getSecret).orElse(null);
        Secret secretPassword = Optional.ofNullable(gradlePluginRepositoryCredentialId).map(it -> (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)it, StandardUsernamePasswordCredentials.class, (Run)run)).map(PasswordCredentials::getPassword).orElse(null);
        if (secretKey == null && secretPassword == null) {
            return;
        }
        DevelocityLogger logger = new DevelocityLogger(listener);
        Secret shortLivedToken = this.getShortLivedToken(secretKey, logger);
        run.addAction((Action)DevelocityParametersAction.of(logger, shortLivedToken, secretPassword));
    }

    @Nullable
    private Secret getShortLivedToken(Secret secretKey, DevelocityLogger logger) {
        if (secretKey == null) {
            return null;
        }
        if (!DevelocityAccessCredentials.isValid(secretKey.getPlainText())) {
            logger.error("Develocity access key format is not valid");
            return null;
        }
        DevelocityAccessCredentials allKeys = DevelocityAccessCredentials.parse(secretKey.getPlainText());
        if (allKeys.isEmpty()) {
            return null;
        }
        String serverUrl = InjectionConfig.get().getServer();
        ShortLivedTokenClient tokenClient = this.shortLivedTokenClientFactory.create(InjectionConfig.get().isAllowUntrusted());
        if (InjectionConfig.get().isEnforceUrl() || allKeys.isSingleKey()) {
            String hostname = this.getHostnameFromServerUrl(serverUrl);
            if (hostname == null) {
                logger.error("Could not extract hostname from Develocity server URL");
                return null;
            }
            return allKeys.find(hostname).map(k -> tokenClient.get(serverUrl, (DevelocityAccessCredentials.HostnameAccessKey)k, InjectionConfig.get().getShortLivedTokenExpiry())).filter(Optional::isPresent).map(k -> Secret.fromString((String)((DevelocityAccessCredentials.HostnameAccessKey)k.get()).getRaw())).orElse(null);
        }
        List<DevelocityAccessCredentials.HostnameAccessKey> shortLivedTokens = allKeys.stream().map(k -> tokenClient.get("https://" + k.getHostname(), (DevelocityAccessCredentials.HostnameAccessKey)k, InjectionConfig.get().getShortLivedTokenExpiry())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return shortLivedTokens.isEmpty() ? null : Secret.fromString((String)DevelocityAccessCredentials.of(shortLivedTokens).getRaw());
    }

    private String getHostnameFromServerUrl(String serverUrl) {
        try {
            return new URL(serverUrl).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static boolean alreadyExecuted(@Nonnull Run run) {
        return run.getAction(DevelocityParametersAction.class) != null;
    }

    public static class DevelocityParametersAction
    extends ParametersAction {
        private static final String GRADLE_ENTERPRISE_ACCESS_KEY = "GRADLE_ENTERPRISE_ACCESS_KEY";
        private static final String DEVELOCITY_ACCESS_KEY = "DEVELOCITY_ACCESS_KEY";
        private static final String GRADLE_PLUGIN_REPOSITORY_PASSWORD = InitScriptVariables.GRADLE_PLUGIN_REPOSITORY_PASSWORD.getEnvVar();
        private static final DevelocityParametersAction EMPTY = new DevelocityParametersAction();

        DevelocityParametersAction(List<ParameterValue> parameters, Collection<String> additionalSafeParameters) {
            super(parameters, additionalSafeParameters);
        }

        DevelocityParametersAction() {
            super(Collections.emptyList());
        }

        static DevelocityParametersAction empty() {
            return EMPTY;
        }

        private static DevelocityParametersAction of(DevelocityLogger logger, @Nullable Secret shortLivedToken, @Nullable Secret repoPassword) {
            ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
            if (shortLivedToken != null) {
                values.add((ParameterValue)new PasswordParameterValue(GRADLE_ENTERPRISE_ACCESS_KEY, shortLivedToken.getPlainText()));
                values.add((ParameterValue)new PasswordParameterValue(DEVELOCITY_ACCESS_KEY, shortLivedToken.getPlainText()));
            }
            if (repoPassword != null) {
                values.add((ParameterValue)new PasswordParameterValue(GRADLE_PLUGIN_REPOSITORY_PASSWORD, repoPassword.getPlainText()));
            }
            if (values.isEmpty()) {
                return DevelocityParametersAction.empty();
            }
            return new DevelocityParametersAction(values, Stream.of(GRADLE_ENTERPRISE_ACCESS_KEY, DEVELOCITY_ACCESS_KEY, GRADLE_PLUGIN_REPOSITORY_PASSWORD).collect(Collectors.toSet()));
        }
    }
}

