/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.enriched;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public CloseableHttpClient buildHttpClient(int httpClientTimeoutInSeconds, int httpClientMaxRetries, int httpClientDelayBetweenRetriesInSeconds) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(httpClientTimeoutInSeconds * 1000).setConnectionRequestTimeout(httpClientTimeoutInSeconds * 1000).setSocketTimeout(httpClientTimeoutInSeconds * 1000).build();
        return HttpClients.custom().setDefaultRequestConfig(config).setRetryHandler((exception, executionCount, context) -> {
            if (executionCount > httpClientMaxRetries) {
                return false;
            }
            Uninterruptibles.sleepUninterruptibly((long)httpClientDelayBetweenRetriesInSeconds, (TimeUnit)TimeUnit.SECONDS);
            return true;
        }).build();
    }
}

