/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle.enriched;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
public class EnrichedSummaryConfig
extends GlobalConfiguration {
    private boolean enrichedSummaryEnabled;
    private int httpClientTimeoutInSeconds = 1;
    private int httpClientMaxRetries = 3;
    private int httpClientDelayBetweenRetriesInSeconds = 1;
    private String buildScanServer;
    private Secret buildScanAccessKey;

    public EnrichedSummaryConfig() {
        this.load();
    }

    public static EnrichedSummaryConfig get() {
        return (EnrichedSummaryConfig)((Object)ExtensionList.lookupSingleton(EnrichedSummaryConfig.class));
    }

    public boolean isEnrichedSummaryEnabled() {
        return this.enrichedSummaryEnabled;
    }

    @DataBoundSetter
    public void setEnrichedSummaryEnabled(boolean enrichedSummaryEnabled) {
        this.enrichedSummaryEnabled = enrichedSummaryEnabled;
    }

    public int getHttpClientTimeoutInSeconds() {
        return this.httpClientTimeoutInSeconds;
    }

    @DataBoundSetter
    public void setHttpClientTimeoutInSeconds(int httpClientTimeoutInSeconds) {
        this.httpClientTimeoutInSeconds = httpClientTimeoutInSeconds;
    }

    public int getHttpClientMaxRetries() {
        return this.httpClientMaxRetries;
    }

    @DataBoundSetter
    public void setHttpClientMaxRetries(int httpClientMaxRetries) {
        this.httpClientMaxRetries = httpClientMaxRetries;
    }

    public int getHttpClientDelayBetweenRetriesInSeconds() {
        return this.httpClientDelayBetweenRetriesInSeconds;
    }

    @DataBoundSetter
    public void setHttpClientDelayBetweenRetriesInSeconds(int httpClientDelayBetweenRetriesInSeonds) {
        this.httpClientDelayBetweenRetriesInSeconds = httpClientDelayBetweenRetriesInSeonds;
    }

    public String getBuildScanServer() {
        return this.buildScanServer;
    }

    @DataBoundSetter
    public void setBuildScanServer(String buildScanServerUrl) {
        this.buildScanServer = Util.fixEmptyAndTrim((String)buildScanServerUrl) == null ? null : buildScanServerUrl;
    }

    public Secret getBuildScanAccessKey() {
        return this.buildScanAccessKey;
    }

    @DataBoundSetter
    public void setBuildScanAccessKey(Secret buildScanAccessKey) {
        this.buildScanAccessKey = Util.fixEmptyAndTrim((String)buildScanAccessKey.getPlainText()) == null ? null : buildScanAccessKey;
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckHttpClientTimeoutInSeconds(@QueryParameter int value) {
        if (value >= 0 && value <= 300) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Timeout must be in [0,300].");
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckHttpClientMaxRetries(@QueryParameter int value) {
        if (value >= 0 && value <= 20) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Max retries must be in [0,20].");
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public FormValidation doCheckHttpClientDelayBetweenRetriesInSeconds(@QueryParameter int value) {
        if (value >= 0 && value <= 20) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Delay between retries must be in [0,20].");
    }
}

