/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.plugins.gradle.TimestampPrefixDetector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

public final class GradleTaskNote
extends ConsoleNote {
    private static final Collection<String> progressStatuses = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("UP-TO-DATE", "SKIPPED", "FROM-CACHE", "NO-SOURCE")));
    private static final Pattern TASK_PATTERN_1 = Pattern.compile("^(?:\\[\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z\\] )?:([^:]\\S*)(\\s*)(\\S*)");
    private static final Pattern TASK_PATTERN_2 = Pattern.compile("^(?:\\[\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z\\] )?> Task :([^:]\\S*)(\\s*)(\\S*)");
    static boolean ENABLED = !Boolean.getBoolean(GradleTaskNote.class.getName() + ".disabled");

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        if (!ENABLED) {
            return null;
        }
        int timestampPrefix = TimestampPrefixDetector.detectTimestampPrefix(text.getText());
        int prefixLength = 1;
        MarkupText.SubText t = text.findToken(TASK_PATTERN_1);
        if (t == null) {
            t = text.findToken(TASK_PATTERN_2);
            prefixLength = 8;
        }
        if (t == null) {
            return null;
        }
        String task = t.group(1);
        String delimiterSpace = t.group(2);
        String progressStatus = t.group(3);
        if (task != null && !task.isEmpty()) {
            t.addMarkup(timestampPrefix + 1, timestampPrefix + task.length() + prefixLength, "<b class=\"gradle-task\">", "</b>");
            if (progressStatus != null && !progressStatus.isEmpty() && progressStatuses.contains(progressStatus)) {
                t.addMarkup(timestampPrefix + task.length() + delimiterSpace.length() + prefixLength, text.length(), "<span class=\"gradle-task-progress-status\">", "</span>");
            }
        }
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        public String getDisplayName() {
            return "Gradle tasks";
        }
    }
}

