/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.gradle.DefaultBuildScanPublishedListener;
import hudson.plugins.gradle.GradleConsoleAnnotator;
import hudson.plugins.gradle.GradleInstallation;
import hudson.plugins.gradle.GradleLogger;
import hudson.plugins.gradle.Messages;
import hudson.plugins.gradle.enriched.EnrichedSummaryConfig;
import hudson.plugins.gradle.enriched.ScanDetailService;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class Gradle
extends Builder {
    private String switches;
    private String tasks;
    private String rootBuildScriptDir;
    private String buildFile;
    private String gradleName;
    private boolean useWrapper;
    private boolean makeExecutable;
    private boolean useWorkspaceAsHome;
    private String wrapperLocation;
    private String systemProperties;
    private boolean passAllAsSystemProperties;
    private String projectProperties;
    private boolean passAllAsProjectProperties;
    private transient Boolean passAsProperties;
    private transient boolean fromRootBuildScriptDir;

    @DataBoundConstructor
    public Gradle() {
    }

    public String getSwitches() {
        return this.switches;
    }

    @DataBoundSetter
    public void setSwitches(String switches) {
        this.switches = switches;
    }

    public String getTasks() {
        return this.tasks;
    }

    @DataBoundSetter
    public void setTasks(String tasks) {
        this.tasks = tasks;
    }

    public String getRootBuildScriptDir() {
        return this.rootBuildScriptDir;
    }

    @DataBoundSetter
    public void setRootBuildScriptDir(String rootBuildScriptDir) {
        this.rootBuildScriptDir = rootBuildScriptDir;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    @DataBoundSetter
    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public String getGradleName() {
        return this.gradleName;
    }

    @DataBoundSetter
    public void setGradleName(String gradleName) {
        this.gradleName = gradleName;
    }

    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    @DataBoundSetter
    public void setUseWrapper(boolean useWrapper) {
        this.useWrapper = useWrapper;
    }

    public boolean isMakeExecutable() {
        return this.makeExecutable;
    }

    @DataBoundSetter
    public void setMakeExecutable(boolean makeExecutable) {
        this.makeExecutable = makeExecutable;
    }

    public boolean isUseWorkspaceAsHome() {
        return this.useWorkspaceAsHome;
    }

    @DataBoundSetter
    public void setUseWorkspaceAsHome(boolean useWorkspaceAsHome) {
        this.useWorkspaceAsHome = useWorkspaceAsHome;
    }

    public String getWrapperLocation() {
        return this.wrapperLocation;
    }

    @DataBoundSetter
    public void setWrapperLocation(String wrapperLocation) {
        this.wrapperLocation = wrapperLocation;
    }

    public String getSystemProperties() {
        return this.systemProperties;
    }

    @DataBoundSetter
    public void setSystemProperties(String systemProperties) {
        this.systemProperties = Util.fixEmptyAndTrim((String)systemProperties);
    }

    public boolean isPassAllAsSystemProperties() {
        return this.passAllAsSystemProperties;
    }

    @DataBoundSetter
    public void setPassAllAsSystemProperties(boolean passAllAsSystemProperties) {
        this.passAllAsSystemProperties = passAllAsSystemProperties;
    }

    public String getProjectProperties() {
        return this.projectProperties;
    }

    @DataBoundSetter
    public void setProjectProperties(String projectProperties) {
        this.projectProperties = projectProperties;
    }

    public boolean isPassAllAsProjectProperties() {
        return this.passAllAsProjectProperties;
    }

    @DataBoundSetter
    public void setPassAllAsProjectProperties(boolean passAllAsProjectProperties) {
        this.passAllAsProjectProperties = passAllAsProjectProperties;
    }

    public GradleInstallation getGradle() {
        for (GradleInstallation i : this.getDescriptor().getInstallations()) {
            if (this.gradleName == null || !i.getName().equals(this.gradleName)) continue;
            return i;
        }
        return null;
    }

    private static String null2Blank(String input) {
        return input != null ? input : "";
    }

    private static String append(String input, String textToAppend) {
        if (StringUtils.isBlank((String)input)) {
            return Gradle.null2Blank(textToAppend);
        }
        if (StringUtils.isBlank((String)textToAppend)) {
            return Gradle.null2Blank(input);
        }
        return input + " " + textToAppend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath rootLauncher;
        GradleLogger gradleLogger = new GradleLogger((TaskListener)listener);
        gradleLogger.info("Launching build.");
        EnvVars env = build.getEnvironment((TaskListener)listener);
        VariableResolver.Union resolver = new VariableResolver.Union(new VariableResolver[]{new VariableResolver.ByMap((Map)env), build.getBuildVariableResolver()});
        String normalizedSwitches = this.getNormalized(this.switches, (VariableResolver<String>)resolver, "GRADLE_EXT_SWITCHES");
        String normalizedTasks = this.getNormalized(this.tasks, (VariableResolver<String>)resolver, "GRADLE_EXT_TASKS");
        FilePath normalizedRootBuildScriptDir = this.getNormalizedRootBuildScriptDir(build, (VariableResolver<String>)resolver);
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (this.useWrapper) {
            FilePath gradleWrapperFile = this.findGradleWrapper(normalizedRootBuildScriptDir, build, launcher, listener, (VariableResolver<String>)resolver);
            if (gradleWrapperFile == null) {
                return false;
            }
            if (this.makeExecutable) {
                gradleWrapperFile.chmod(493);
            }
            args.add(gradleWrapperFile.getRemote());
        } else {
            GradleInstallation ai = this.getGradle();
            if (ai != null) {
                Node node;
                Computer computer = Computer.currentComputer();
                Node node2 = node = computer != null ? computer.getNode() : null;
                if (node == null) {
                    gradleLogger.error("Not in a build node.");
                    return false;
                }
                ai = ai.forNode(node, (TaskListener)listener);
                String exe = (ai = ai.forEnvironment(env)).getExecutable(launcher);
                if (exe == null) {
                    gradleLogger.error("Can't retrieve the Gradle executable.");
                    return false;
                }
                env.put("GRADLE_HOME", ai.getHome());
                args.add(exe);
            } else {
                args.add(launcher.isUnix() ? "gradle" : "gradle.bat");
            }
        }
        Set sensitiveVars = build.getSensitiveBuildVariables();
        args.addKeyValuePairsFromPropertyString("-D", this.getSystemProperties(), (VariableResolver)resolver, sensitiveVars);
        if (this.isPassAllAsSystemProperties()) {
            args.addKeyValuePairs("-D", build.getBuildVariables(), sensitiveVars);
        }
        args.addKeyValuePairsFromPropertyString("-P", this.getProjectProperties(), (VariableResolver)resolver, sensitiveVars);
        if (this.isPassAllAsProjectProperties()) {
            args.addKeyValuePairs("-P", build.getBuildVariables(), sensitiveVars);
        }
        args.addTokenized(normalizedSwitches);
        args.addTokenized(normalizedTasks);
        if (StringUtils.isNotBlank((String)this.buildFile)) {
            String buildFileNormalized = Util.replaceMacro((String)this.buildFile.trim(), (VariableResolver)resolver);
            args.add("-b");
            args.add(buildFileNormalized);
        }
        FilePath workspace = build.getWorkspace();
        if (this.useWorkspaceAsHome && workspace != null) {
            env.put("GRADLE_USER_HOME", workspace.getRemote());
        }
        if (!launcher.isUnix()) {
            args = args.toWindowsCommand();
        }
        if ((rootLauncher = normalizedRootBuildScriptDir != null ? normalizedRootBuildScriptDir : build.getWorkspace()) == null) {
            rootLauncher = build.getProject().getSomeWorkspace();
        }
        try {
            int r;
            ScanDetailService scanDetailService = new ScanDetailService(EnrichedSummaryConfig.get());
            DefaultBuildScanPublishedListener buildScanListener = new DefaultBuildScanPublishedListener((Actionable)build, scanDetailService);
            GradleConsoleAnnotator gca = new GradleConsoleAnnotator(listener.getLogger(), build.getCharset(), true, buildScanListener);
            try {
                r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)((Object)gca)).pwd(rootLauncher).join();
            }
            finally {
                gca.forceEol();
            }
            boolean success = r == 0;
            build.setResult(Result.SUCCESS);
            if (!success) {
                build.setResult(Result.FAILURE);
            }
            return success;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private FilePath findGradleWrapper(FilePath normalizedRootBuildScriptDir, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, VariableResolver<String> resolver) throws IOException, InterruptedException {
        List<FilePath> possibleWrapperLocations = this.getPossibleWrapperLocations(build, launcher, resolver, normalizedRootBuildScriptDir);
        String execName = launcher.isUnix() ? "gradlew" : "gradlew.bat";
        FilePath gradleWrapperFile = null;
        for (FilePath possibleWrapperLocation : possibleWrapperLocations) {
            FilePath possibleGradleWrapperFile = new FilePath(possibleWrapperLocation, execName);
            if (!possibleGradleWrapperFile.exists()) continue;
            gradleWrapperFile = possibleGradleWrapperFile;
            break;
        }
        if (gradleWrapperFile == null) {
            listener.fatalError("The Gradle wrapper has not been found in these directories: %s", new Object[]{possibleWrapperLocations.stream().map(Object::toString).collect(Collectors.joining(", "))});
        }
        return gradleWrapperFile;
    }

    private FilePath getNormalizedRootBuildScriptDir(AbstractBuild<?, ?> build, VariableResolver<String> resolver) {
        FilePath normalizedRootBuildScriptDir = null;
        if (this.rootBuildScriptDir != null && this.rootBuildScriptDir.trim().length() != 0) {
            String rootBuildScriptNormalized = this.replaceWhitespaceBySpace(this.rootBuildScriptDir.trim());
            rootBuildScriptNormalized = Util.replaceMacro((String)rootBuildScriptNormalized.trim(), resolver);
            normalizedRootBuildScriptDir = new FilePath(build.getModuleRoot(), rootBuildScriptNormalized);
        }
        return normalizedRootBuildScriptDir;
    }

    private String getNormalized(String args, VariableResolver<String> resolver, String contributingEnvironmentVariable) {
        String extraArgs = (String)resolver.resolve(contributingEnvironmentVariable);
        String normalizedArgs = Gradle.append(args, extraArgs);
        normalizedArgs = this.replaceWhitespaceBySpace(normalizedArgs);
        normalizedArgs = Util.replaceMacro((String)normalizedArgs, resolver);
        return normalizedArgs;
    }

    private String replaceWhitespaceBySpace(String argument) {
        return argument.replaceAll("[\t\r\n]+", " ");
    }

    private List<FilePath> getPossibleWrapperLocations(AbstractBuild<?, ?> build, Launcher launcher, VariableResolver<String> resolver, FilePath normalizedRootBuildScriptDir) throws IOException, InterruptedException {
        String buildFileNormalized;
        FilePath parentOfBuildFile;
        FilePath moduleRoot = build.getModuleRoot();
        if (this.wrapperLocation != null && this.wrapperLocation.trim().length() != 0) {
            String wrapperLocationNormalized = this.wrapperLocation.trim().replaceAll("[\t\r\n]+", "");
            wrapperLocationNormalized = Util.replaceMacro((String)wrapperLocationNormalized.trim(), resolver);
            return Collections.singletonList(new FilePath(moduleRoot, wrapperLocationNormalized));
        }
        if (this.buildFile != null && !this.buildFile.isEmpty() && (parentOfBuildFile = new FilePath(normalizedRootBuildScriptDir == null ? moduleRoot : normalizedRootBuildScriptDir, buildFileNormalized = Util.replaceMacro((String)this.buildFile.trim(), resolver)).getParent()) != null && !parentOfBuildFile.equals((Object)moduleRoot)) {
            ArrayList locations = new ArrayList();
            Collections.addAll(locations, parentOfBuildFile, moduleRoot);
            return Collections.unmodifiableList(locations);
        }
        return Collections.singletonList(moduleRoot);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public Gradle(String switches, String tasks, String rootBuildScriptDir, String buildFile, String gradleName, boolean useWrapper, boolean makeExecutable, String wrapperLocation, boolean useWorkspaceAsHome, boolean passAsProperties) {
        this.setSwitches(switches);
        this.setTasks(tasks);
        this.setRootBuildScriptDir(rootBuildScriptDir);
        this.setBuildFile(buildFile);
        this.setUseWrapper(useWrapper);
        this.setGradleName(gradleName);
        this.setWrapperLocation(wrapperLocation);
        this.setMakeExecutable(makeExecutable);
        this.setUseWorkspaceAsHome(useWorkspaceAsHome);
        this.setPassAllAsProjectProperties(passAsProperties);
        this.setPassAllAsSystemProperties(!passAsProperties);
    }

    private Object readResolve() {
        if (this.fromRootBuildScriptDir) {
            this.wrapperLocation = this.rootBuildScriptDir;
        }
        if (this.passAsProperties != null) {
            if (this.passAsProperties.booleanValue()) {
                this.passAllAsProjectProperties = true;
            } else {
                this.passAllAsSystemProperties = true;
            }
        }
        return this;
    }

    @Extension
    @Symbol(value={"gradle"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile GradleInstallation[] installations = new GradleInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        protected DescriptorImpl(Class<? extends Gradle> clazz) {
            super(clazz);
        }

        public GradleInstallation.DescriptorImpl getToolDescriptor() {
            return (GradleInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(GradleInstallation.DescriptorImpl.class));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        protected void convert(Map<String, Object> oldPropertyBag) {
            if (oldPropertyBag.containsKey("installations")) {
                this.installations = (GradleInstallation[])oldPropertyBag.get("installations");
            }
        }

        public String getHelpFile() {
            return "/plugin/gradle/help.html";
        }

        public String getDisplayName() {
            return Messages.step_displayName();
        }

        public GradleInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public void setInstallations(GradleInstallation ... installations) {
            this.installations = installations;
            this.save();
        }
    }
}

