/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import com.google.common.collect.ImmutableList;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.plugins.gradle.BuildAgentError;
import hudson.plugins.gradle.BuildToolType;
import hudson.plugins.gradle.enriched.ScanDetail;
import hudson.plugins.gradle.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractBuildScanAction
implements Action {
    protected transient Actionable target;
    private List<String> scanUrls = new ArrayList<String>();
    private final List<ScanDetail> scanDetails = new ArrayList<ScanDetail>();
    private final Set<BuildAgentError> buildAgentErrors = new HashSet<BuildAgentError>();
    private transient String scanUrl;

    public String getIconFileName() {
        return "/plugin/gradle/images/svgs/gradle-build-scan.svg";
    }

    public String getDisplayName() {
        return "Build Scans";
    }

    public String getUrlName() {
        return "buildScans";
    }

    public void addBuildAgentError(BuildAgentError buildAgentError) {
        this.buildAgentErrors.add(buildAgentError);
    }

    public void addScanUrls(Collection<String> scanUrls, Function<String, Optional<ScanDetail>> scanDetailsFactory) {
        for (String scanUrl : scanUrls) {
            this.addScanUrl(scanUrl);
            scanDetailsFactory.apply(scanUrl).ifPresent(this::addScanDetail);
        }
    }

    public void addScanUrl(String scanUrl) {
        if (!this.scanUrls.contains(scanUrl)) {
            this.scanUrls.add(scanUrl);
        }
    }

    public void addScanDetail(ScanDetail scanDetail) {
        if (!this.scanDetails.contains(scanDetail)) {
            this.scanDetails.add(scanDetail);
        }
    }

    @Exported
    public List<String> getScanUrls() {
        return CollectionUtil.unmodifiableCopy(this.scanUrls);
    }

    @Exported
    public List<ScanDetail> getScanDetails() {
        return CollectionUtil.unmodifiableCopy(this.scanDetails);
    }

    @Exported
    public boolean getHasMavenErrors() {
        return this.hasError(BuildToolType.MAVEN);
    }

    @Exported
    public boolean getHasGradleErrors() {
        return this.hasError(BuildToolType.GRADLE);
    }

    public List<BuildAgentError> getBuildAgentErrors() {
        return ImmutableList.copyOf(this.buildAgentErrors);
    }

    public boolean hasErrors() {
        return !this.buildAgentErrors.isEmpty();
    }

    private boolean hasError(BuildToolType buildToolType) {
        return this.buildAgentErrors.stream().anyMatch(e -> e.getBuildToolType() == buildToolType);
    }

    public Actionable getTarget() {
        return this.target;
    }

    protected Object readResolve() {
        if (this.scanUrl != null) {
            this.scanUrls = Collections.singletonList(this.scanUrl);
        }
        return this;
    }
}

