/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.tools.api.impl;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.AnnotationVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.FieldVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ModuleVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.Type;
import java.util.Optional;
import java.util.Set;
import org.gradle.internal.tools.api.ApiMemberWriter;
import org.gradle.internal.tools.api.ApiMemberWriterAdapter;
import org.gradle.internal.tools.api.impl.AnnotationAnnotationValue;
import org.gradle.internal.tools.api.impl.AnnotationMember;
import org.gradle.internal.tools.api.impl.AnnotationValue;
import org.gradle.internal.tools.api.impl.ArrayAnnotationValue;
import org.gradle.internal.tools.api.impl.ClassMember;
import org.gradle.internal.tools.api.impl.EnumAnnotationValue;
import org.gradle.internal.tools.api.impl.FieldMember;
import org.gradle.internal.tools.api.impl.InnerClassMember;
import org.gradle.internal.tools.api.impl.MethodMember;
import org.gradle.internal.tools.api.impl.ParameterAnnotationMember;
import org.gradle.internal.tools.api.impl.SimpleAnnotationValue;

public class JavaApiMemberWriter
implements ApiMemberWriter {
    private final ClassVisitor apiMemberAdapter;

    protected JavaApiMemberWriter(ClassVisitor classVisitor) {
        this.apiMemberAdapter = classVisitor;
    }

    public static ApiMemberWriterAdapter adapter() {
        return JavaApiMemberWriter::new;
    }

    @Override
    public ModuleVisitor writeModule(String string, int n2, String string2) {
        return this.apiMemberAdapter.visitModule(string, n2, string2);
    }

    @Override
    public void writeClass(ClassMember classMember, Set<MethodMember> set, Set<FieldMember> set2, Set<InnerClassMember> set3) {
        this.apiMemberAdapter.visit(classMember.getVersion(), classMember.getAccess(), classMember.getName(), classMember.getSignature(), classMember.getSuperName(), classMember.getInterfaces());
        this.writeClassAnnotations(classMember.getAnnotations());
        for (String iterator : classMember.getPermittedSubclasses()) {
            this.apiMemberAdapter.visitPermittedSubclass(iterator);
        }
        InnerClassMember innerClassMember2 = set3.stream().filter(innerClassMember -> innerClassMember.getName().equals(classMember.getName())).findFirst().orElse(null);
        for (MethodMember methodMember : set) {
            this.writeMethod(classMember, innerClassMember2, methodMember);
        }
        for (FieldMember fieldMember : set2) {
            FieldVisitor fieldVisitor = this.apiMemberAdapter.visitField(fieldMember.getAccess(), fieldMember.getName(), fieldMember.getTypeDesc(), fieldMember.getSignature(), fieldMember.getValue());
            this.writeFieldAnnotations(fieldVisitor, fieldMember.getAnnotations());
            fieldVisitor.visitEnd();
        }
        for (InnerClassMember innerClassMember3 : set3) {
            this.apiMemberAdapter.visitInnerClass(innerClassMember3.getName(), innerClassMember3.getOuterName(), innerClassMember3.getInnerName(), innerClassMember3.getAccess());
        }
        this.apiMemberAdapter.visitEnd();
    }

    public void writeMethod(ClassMember classMember, InnerClassMember innerClassMember, MethodMember methodMember) {
        MethodVisitor methodVisitor = this.apiMemberAdapter.visitMethod(methodMember.getAccess(), methodMember.getName(), methodMember.getTypeDesc(), methodMember.getSignature(), methodMember.getExceptions().toArray(new String[0]));
        this.writeMethodAnnotations(methodVisitor, methodMember.getAnnotations());
        this.writeMethodAnnotations(methodVisitor, methodMember.getParameterAnnotations());
        JavaApiMemberWriter.calculateNonAnnotableParameterCount(classMember, innerClassMember, methodMember).ifPresent(n2 -> {
            int n3 = Type.getArgumentCount(methodMember.getTypeDesc());
            int n4 = n3 - n2;
            methodVisitor.visitAnnotableParameterCount(n4, true);
            methodVisitor.visitAnnotableParameterCount(n4, false);
        });
        methodMember.getAnnotationDefaultValue().ifPresent(annotationValue -> {
            AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotationDefault();
            this.writeAnnotationValue(annotationVisitor, (AnnotationValue<?>)annotationValue);
            annotationVisitor.visitEnd();
        });
        methodVisitor.visitEnd();
    }

    private static Optional<Integer> calculateNonAnnotableParameterCount(ClassMember classMember, InnerClassMember innerClassMember, MethodMember methodMember) {
        if (methodMember.getName().equals("<init>")) {
            if ((classMember.getAccess() & 0x4000) == 16384) {
                return Optional.of(2);
            }
            if (innerClassMember != null && (innerClassMember.getAccess() & 8) != 8) {
                return Optional.of(1);
            }
        }
        return Optional.empty();
    }

    public void writeClassAnnotations(Set<AnnotationMember> set) {
        for (AnnotationMember annotationMember : set) {
            AnnotationVisitor annotationVisitor = this.apiMemberAdapter.visitAnnotation(annotationMember.getName(), annotationMember.isVisible());
            this.writeAnnotationValues(annotationMember, annotationVisitor);
        }
    }

    public void writeMethodAnnotations(MethodVisitor methodVisitor, Set<AnnotationMember> set) {
        for (AnnotationMember annotationMember : set) {
            AnnotationVisitor annotationVisitor = annotationMember instanceof ParameterAnnotationMember ? methodVisitor.visitParameterAnnotation(((ParameterAnnotationMember)annotationMember).getParameter(), annotationMember.getName(), annotationMember.isVisible()) : methodVisitor.visitAnnotation(annotationMember.getName(), annotationMember.isVisible());
            this.writeAnnotationValues(annotationMember, annotationVisitor);
        }
    }

    public void writeFieldAnnotations(FieldVisitor fieldVisitor, Set<AnnotationMember> set) {
        for (AnnotationMember annotationMember : set) {
            AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(annotationMember.getName(), annotationMember.isVisible());
            this.writeAnnotationValues(annotationMember, annotationVisitor);
        }
    }

    public void writeAnnotationValues(AnnotationMember annotationMember, AnnotationVisitor annotationVisitor) {
        for (AnnotationValue annotationValue : annotationMember.getValues()) {
            this.writeAnnotationValue(annotationVisitor, annotationValue);
        }
        annotationVisitor.visitEnd();
    }

    public void writeAnnotationValue(AnnotationVisitor annotationVisitor, AnnotationValue<?> annotationValue) {
        String string = annotationValue.getName();
        if (annotationValue instanceof EnumAnnotationValue) {
            annotationVisitor.visitEnum(string, ((EnumAnnotationValue)annotationValue).getTypeDesc(), (String)annotationValue.getValue());
        } else if (annotationValue instanceof SimpleAnnotationValue) {
            annotationVisitor.visit(string, annotationValue.getValue());
        } else if (annotationValue instanceof ArrayAnnotationValue) {
            AnnotationValue[] annotationValueArray;
            AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(string);
            for (AnnotationValue annotationValue2 : annotationValueArray = (AnnotationValue[])((ArrayAnnotationValue)annotationValue).getValue()) {
                this.writeAnnotationValue(annotationVisitor2, annotationValue2);
            }
            annotationVisitor2.visitEnd();
        } else if (annotationValue instanceof AnnotationAnnotationValue) {
            AnnotationMember annotationMember = (AnnotationMember)((AnnotationAnnotationValue)annotationValue).getValue();
            AnnotationVisitor annotationVisitor3 = annotationVisitor.visitAnnotation(string, annotationMember.getName());
            this.writeAnnotationValues(annotationMember, annotationVisitor3);
        } else {
            throw new AssertionError((Object)("Unknown annotation value type: " + annotationValue.getClass().getName()));
        }
    }
}

