/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.GradleException;
import org.gradle.internal.Factory;

public class DefaultMultiCauseException
extends GradleException {
    private final List<Throwable> causes = new CopyOnWriteArrayList<Throwable>();
    private transient ThreadLocal<Boolean> hideCause = this.threadLocal();
    private transient Factory<String> messageFactory;
    private String message;

    public DefaultMultiCauseException(String string, Iterable<? extends Throwable> iterable) {
        super(string);
        this.message = string;
        this.initCauses(iterable);
    }

    private ThreadLocal<Boolean> threadLocal() {
        return new HideStacktrace();
    }

    @Override
    public synchronized Throwable initCause(Throwable throwable) {
        this.causes.clear();
        this.causes.add(throwable);
        return this;
    }

    public void initCauses(Iterable<? extends Throwable> iterable) {
        this.causes.clear();
        for (Throwable throwable : iterable) {
            this.causes.add(throwable);
        }
    }

    @Override
    public synchronized Throwable getCause() {
        if (this.hideCause.get().booleanValue()) {
            return null;
        }
        return this.causes.isEmpty() ? null : this.causes.get(0);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.causes.isEmpty()) {
            super.printStackTrace(printWriter);
            return;
        }
        this.hideCause.set(true);
        try {
            super.printStackTrace(printWriter);
            if (this.causes.size() == 1) {
                this.printSingleCauseStackTrace(printWriter);
            } else {
                this.printMultiCauseStackTrace(printWriter);
            }
        }
        finally {
            this.hideCause.set(false);
        }
    }

    private void printSingleCauseStackTrace(PrintWriter printWriter) {
        Throwable throwable = this.causes.get(0);
        printWriter.print("Caused by: ");
        throwable.printStackTrace(printWriter);
    }

    private void printMultiCauseStackTrace(PrintWriter printWriter) {
        for (int i2 = 0; i2 < this.causes.size(); ++i2) {
            Throwable throwable = this.causes.get(i2);
            printWriter.format("Cause %s: ", i2 + 1);
            throwable.printStackTrace(printWriter);
        }
    }

    @Override
    public String getMessage() {
        if (this.messageFactory != null) {
            this.message = this.messageFactory.create();
            this.messageFactory = null;
            return this.message;
        }
        return this.message;
    }

    private static class HideStacktrace
    extends ThreadLocal<Boolean> {
        private HideStacktrace() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }
}

