/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateSerializer;

public class DefaultLockStateSerializer
implements LockStateSerializer {
    @Override
    public int getSize() {
        return 16;
    }

    @Override
    public byte getVersion() {
        return 3;
    }

    @Override
    public LockState createInitialState() {
        long l2 = new Random().nextLong();
        return new SequenceNumberLockState(l2, -1L, 0L);
    }

    @Override
    public void write(DataOutput dataOutput, LockState lockState) throws IOException {
        SequenceNumberLockState sequenceNumberLockState = (SequenceNumberLockState)lockState;
        dataOutput.writeLong(sequenceNumberLockState.creationNumber);
        dataOutput.writeLong(sequenceNumberLockState.sequenceNumber);
    }

    @Override
    public LockState read(DataInput dataInput) throws IOException {
        long l2 = dataInput.readLong();
        long l3 = dataInput.readLong();
        return new SequenceNumberLockState(l2, l3, l3);
    }

    private static class SequenceNumberLockState
    implements LockState {
        private final long creationNumber;
        private final long originalSequenceNumber;
        private final long sequenceNumber;

        private SequenceNumberLockState(long l2, long l3, long l4) {
            this.creationNumber = l2;
            this.originalSequenceNumber = l3;
            this.sequenceNumber = l4;
        }

        public String toString() {
            return String.format("[%s,%s,%s]", this.creationNumber, this.sequenceNumber, this.isDirty());
        }

        @Override
        public LockState beforeUpdate() {
            return new SequenceNumberLockState(this.creationNumber, this.originalSequenceNumber, 0L);
        }

        @Override
        public LockState completeUpdate() {
            long l2 = this.isInInitialState() ? 1L : this.originalSequenceNumber + 1L;
            return new SequenceNumberLockState(this.creationNumber, l2, l2);
        }

        @Override
        public boolean isDirty() {
            return this.sequenceNumber == 0L || this.sequenceNumber != this.originalSequenceNumber;
        }

        @Override
        public boolean canDetectChanges() {
            return true;
        }

        @Override
        public boolean isInInitialState() {
            return this.originalSequenceNumber <= 0L;
        }
    }
}

