/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.time.Instant;
import java.util.function.Supplier;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;

class DefaultCacheCleanupStrategy
implements CacheCleanupStrategy {
    private final CleanupAction cleanupAction;
    private final Supplier<CleanupFrequency> cleanupFrequency;
    private final BuildOperationRunner buildOperationRunner;

    DefaultCacheCleanupStrategy(CleanupAction cleanupAction, Supplier<CleanupFrequency> supplier, BuildOperationRunner buildOperationRunner) {
        this.cleanupAction = cleanupAction;
        this.cleanupFrequency = supplier;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public void clean(final CleanableStore cleanableStore, final Instant instant) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext buildOperationContext) {
                DefaultCleanupProgressMonitor defaultCleanupProgressMonitor = new DefaultCleanupProgressMonitor(buildOperationContext);
                DefaultCacheCleanupStrategy.this.cleanupAction.clean(cleanableStore, defaultCleanupProgressMonitor);
                buildOperationContext.setResult(new CacheCleanupResult(defaultCleanupProgressMonitor.getDeleted(), instant));
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Clean up " + cleanableStore.getDisplayName()).details(new CacheCleanupDetails(cleanableStore.getBaseDir()));
            }
        });
    }

    @Override
    public CleanupFrequency getCleanupFrequency() {
        return this.cleanupFrequency.get();
    }

    private static class CacheCleanupResult {
        private final long deletedEntriesCount;
        private final Instant previousCleanupTime;

        private CacheCleanupResult(long l2, Instant instant) {
            this.deletedEntriesCount = l2;
            this.previousCleanupTime = instant;
        }
    }

    private static class CacheCleanupDetails {
        private final File cacheLocation;

        public CacheCleanupDetails(File file) {
            this.cacheLocation = file;
        }
    }
}

