/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.internal.CacheCleanupExecutor;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheCleanupExecutor
implements CacheCleanupExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheCleanupExecutor.class);
    private final CleanableStore cleanableStore;
    private final File gcFile;
    private final CacheCleanupStrategy cacheCleanupStrategy;

    public DefaultCacheCleanupExecutor(CleanableStore cleanableStore, File file, CacheCleanupStrategy cacheCleanupStrategy) {
        this.cleanableStore = cleanableStore;
        this.gcFile = file;
        this.cacheCleanupStrategy = cacheCleanupStrategy;
    }

    @Override
    public void cleanup() {
        this.getLastCleanupTime().ifPresent(this::performCleanupIfNecessary);
    }

    private void performCleanupIfNecessary(Instant instant) {
        Object object;
        if (LOGGER.isDebugEnabled()) {
            object = Duration.between(instant, Instant.now());
            LOGGER.debug("{} has last been fully cleaned up {} hours ago", (Object)this.cleanableStore.getDisplayName(), (Object)((Duration)object).toHours());
        }
        if (!this.cacheCleanupStrategy.getCleanupFrequency().requiresCleanup(instant)) {
            LOGGER.debug("Skipping cleanup for {} as it is not yet due", (Object)this.cleanableStore.getDisplayName());
            return;
        }
        try {
            object = Time.startTimer();
            this.cacheCleanupStrategy.clean(this.cleanableStore, instant);
            FileUtils.touch(this.gcFile);
            LOGGER.info("{} cleaned up in {}.", (Object)this.cleanableStore.getDisplayName(), (Object)object.getElapsed());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private Optional<Instant> getLastCleanupTime() {
        if (this.cacheCleanupStrategy == CacheCleanupStrategy.NO_CLEANUP) {
            return Optional.empty();
        }
        File file = this.cleanableStore.getBaseDir();
        if (!file.exists()) {
            return Optional.empty();
        }
        if (!this.gcFile.exists()) {
            try {
                FileUtils.touch(this.gcFile);
            }
            catch (IOException iOException) {
                throw UncheckedException.throwAsUncheckedException(iOException);
            }
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(this.gcFile.lastModified()));
    }
}

