/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.NonReservedFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheCleanup
implements CleanupAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheCleanup.class);
    private final FilesFinder eligibleFilesFinder;

    public AbstractCacheCleanup(FilesFinder filesFinder) {
        this.eligibleFilesFinder = filesFinder;
    }

    @Override
    public void clean(CleanableStore cleanableStore, CleanupProgressMonitor cleanupProgressMonitor) {
        int n2 = 0;
        for (File file : this.findEligibleFiles(cleanableStore)) {
            if (this.shouldDelete(file)) {
                cleanupProgressMonitor.incrementDeleted();
                if (!FileUtils.deleteQuietly(file)) continue;
                this.handleDeletion(file);
                n2 += 1 + this.deleteEmptyParentDirectories(cleanableStore.getBaseDir(), file.getParentFile());
                continue;
            }
            cleanupProgressMonitor.incrementSkipped();
        }
        LOGGER.info("{} cleanup deleted {} files/directories.", (Object)cleanableStore.getDisplayName(), (Object)n2);
    }

    protected int deleteEmptyParentDirectories(File file, File file2) {
        if (file2.equals(file)) {
            return 0;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray != null && fileArray.length == 0 && file2.delete()) {
            this.handleDeletion(file2);
            return 1 + this.deleteEmptyParentDirectories(file, file2.getParentFile());
        }
        return 0;
    }

    protected abstract boolean shouldDelete(File var1);

    protected abstract void handleDeletion(File var1);

    private Iterable<File> findEligibleFiles(CleanableStore cleanableStore) {
        return this.eligibleFilesFinder.find(cleanableStore.getBaseDir(), new NonReservedFileFilter(cleanableStore.getReservedCacheFiles()));
    }
}

