/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.scan.extension.test.event.internal;

import com.gradle.maven.scan.extension.test.event.TestFinishedEvent;
import com.gradle.maven.scan.extension.test.event.internal.TestDescriptor;
import com.gradle.maven.scan.extension.test.event.internal.TestResult;
import com.gradle.maven.scan.extension.test.event.internal.TestState;
import com.gradle.nullability.Nullable;

public final class DefaultTestState
implements TestState {
    public final TestDescriptor test;
    private boolean isFailed;
    private boolean isAssumptionFailed;
    @Nullable
    private Throwable failure;
    @Nullable
    private Throwable assumptionFailure;
    @Nullable
    private TestResult.ResultType resultType;

    public DefaultTestState(TestDescriptor testDescriptor) {
        this.test = testDescriptor;
    }

    public void completed(TestFinishedEvent testFinishedEvent) {
        this.resultType = this.isFailed ? TestResult.ResultType.FAILURE : (this.isAssumptionFailed ? TestResult.ResultType.ABORTED : (testFinishedEvent.testResult.getResultType() != null ? testFinishedEvent.testResult.getResultType() : TestResult.ResultType.SUCCESS));
    }

    @Override
    @Nullable
    public Throwable getFailure() {
        return this.failure != null ? this.failure : this.assumptionFailure;
    }

    @Override
    @Nullable
    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public void addFailure(Throwable throwable) {
        this.isFailed = true;
        if (this.failure == null) {
            this.failure = throwable;
        }
    }

    public void addAssumptionFailure(Throwable throwable) {
        this.isAssumptionFailed = true;
        if (this.assumptionFailure == null) {
            this.assumptionFailure = throwable;
        }
    }
}

