/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.util;

import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static List<String> readFile(String string) {
        return FileUtil.readFile(string, true);
    }

    public static List<String> readFile(String string, boolean bl2) {
        Path path = Paths.get(string, new String[0]);
        if (Files.isReadable(path)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading file {}", (Object)string);
            }
            try {
                return Files.readAllLines(path, StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                if (bl2) {
                    LOG.error("Error reading file {}. {}", (Object)string, (Object)iOException.getMessage());
                } else {
                    LOG.debug("Error reading file {}. {}", (Object)string, (Object)iOException.getMessage());
                }
            }
        } else if (bl2) {
            LOG.warn("File not found or not readable: {}", (Object)string);
        }
        return Collections.emptyList();
    }

    public static List<String> readLines(String string, int n2) {
        return FileUtil.readLines(string, n2, true);
    }

    public static List<String> readLines(String string, int n2, boolean bl2) {
        block15: {
            Path path = Paths.get(string, new String[0]);
            if (Files.isReadable(path)) {
                ArrayList<String> arrayList;
                block14: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Reading file {}", (Object)string);
                    }
                    BufferedReader bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                    try {
                        String string2;
                        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
                        for (int i2 = 0; i2 < n2 && (string2 = bufferedReader.readLine()) != null; ++i2) {
                            arrayList2.add(string2);
                        }
                        arrayList = arrayList2;
                        if (bufferedReader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            if (bl2) {
                                LOG.error("Error reading file {}. {}", (Object)string, (Object)iOException.getMessage());
                                break block15;
                            }
                            LOG.debug("Error reading file {}. {}", (Object)string, (Object)iOException.getMessage());
                        }
                    }
                    bufferedReader.close();
                }
                return arrayList;
            } else if (bl2) {
                LOG.warn("File not found or not readable: {}", (Object)string);
            }
        }
        return Collections.emptyList();
    }

    public static byte[] readAllBytes(String string, boolean bl2) {
        Path path = Paths.get(string, new String[0]);
        if (Files.isReadable(path)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading file {}", (Object)string);
            }
            try {
                return Files.readAllBytes(path);
            }
            catch (IOException iOException) {
                if (bl2) {
                    LOG.error("Error reading file {}. {}", (Object)string, (Object)iOException.getMessage());
                } else {
                    LOG.debug("Error reading file {}. {}", (Object)string, (Object)iOException.getMessage());
                }
            }
        } else if (bl2) {
            LOG.warn("File not found or not readable: {}", (Object)string);
        }
        return new byte[0];
    }

    public static ByteBuffer readAllBytesAsBuffer(String string) {
        byte[] byArray = FileUtil.readAllBytes(string, false);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.order(ByteOrder.nativeOrder());
        for (byte by2 : byArray) {
            byteBuffer.put(by2);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static byte readByteFromBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.position() < byteBuffer.limit()) {
            return byteBuffer.get();
        }
        return 0;
    }

    public static short readShortFromBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.position() <= byteBuffer.limit() - 2) {
            return byteBuffer.getShort();
        }
        return 0;
    }

    public static int readIntFromBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.position() <= byteBuffer.limit() - 4) {
            return byteBuffer.getInt();
        }
        return 0;
    }

    public static long readLongFromBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.position() <= byteBuffer.limit() - 8) {
            return byteBuffer.getLong();
        }
        return 0L;
    }

    public static NativeLong readNativeLongFromBuffer(ByteBuffer byteBuffer) {
        return new NativeLong(Native.LONG_SIZE == 4 ? (long)FileUtil.readIntFromBuffer(byteBuffer) : FileUtil.readLongFromBuffer(byteBuffer));
    }

    public static LibCAPI.size_t readSizeTFromBuffer(ByteBuffer byteBuffer) {
        return new LibCAPI.size_t(Native.SIZE_T_SIZE == 4 ? (long)FileUtil.readIntFromBuffer(byteBuffer) : FileUtil.readLongFromBuffer(byteBuffer));
    }

    public static void readByteArrayFromBuffer(ByteBuffer byteBuffer, byte[] byArray) {
        if (byteBuffer.position() <= byteBuffer.limit() - byArray.length) {
            byteBuffer.get(byArray);
        }
    }

    public static Pointer readPointerFromBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.position() <= byteBuffer.limit() - Native.POINTER_SIZE) {
            return Native.POINTER_SIZE == 4 ? new Pointer(byteBuffer.getInt()) : new Pointer(byteBuffer.getLong());
        }
        return Pointer.NULL;
    }

    public static long getLongFromFile(String string) {
        List<String> list;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading file {}", (Object)string);
        }
        if (!(list = FileUtil.readLines(string, 1, false)).isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Read {}", (Object)list.get(0));
            }
            return ParseUtil.parseLongOrDefault(list.get(0), 0L);
        }
        return 0L;
    }

    public static long getUnsignedLongFromFile(String string) {
        List<String> list;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading file {}", (Object)string);
        }
        if (!(list = FileUtil.readLines(string, 1, false)).isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Read {}", (Object)list.get(0));
            }
            return ParseUtil.parseUnsignedLongOrDefault(list.get(0), 0L);
        }
        return 0L;
    }

    public static int getIntFromFile(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading file {}", (Object)string);
        }
        try {
            List<String> list = FileUtil.readLines(string, 1, false);
            if (!list.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Read {}", (Object)list.get(0));
                }
                return ParseUtil.parseIntOrDefault(list.get(0), 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("Unable to read value from {}. {}", (Object)string, (Object)numberFormatException.getMessage());
        }
        return 0;
    }

    public static String getStringFromFile(String string) {
        List<String> list;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading file {}", (Object)string);
        }
        if (!(list = FileUtil.readLines(string, 1, false)).isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Read {}", (Object)list.get(0));
            }
            return list.get(0);
        }
        return "";
    }

    public static Map<String, String> getKeyValueMapFromFile(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading file {}", (Object)string);
        }
        List<String> list = FileUtil.readFile(string, false);
        for (String string3 : list) {
            String[] stringArray = string3.split(string2);
            if (stringArray.length != 2) continue;
            hashMap.put(stringArray[0], stringArray[1].trim());
        }
        return hashMap;
    }

    public static Properties readPropertiesFromFilename(String string) {
        Properties properties = new Properties();
        for (ClassLoader classLoader : Stream.of(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader(), FileUtil.class.getClassLoader()).collect(Collectors.toCollection(LinkedHashSet::new))) {
            if (!FileUtil.readPropertiesFromClassLoader(string, properties, classLoader)) continue;
            return properties;
        }
        LOG.warn("Failed to load configuration file from classloader: {}", (Object)string);
        return properties;
    }

    private static boolean readPropertiesFromClassLoader(String string, Properties properties, ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        try {
            Object object;
            ArrayList<URL> arrayList = Collections.list(classLoader.getResources(string));
            if (arrayList.isEmpty()) {
                LOG.debug("No {} file found from ClassLoader {}", (Object)string, (Object)classLoader);
                return false;
            }
            if (arrayList.size() > 1) {
                object = FileUtil.readFileAsBytes((URL)arrayList.get(0));
                for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                    if (Arrays.equals((byte[])object, FileUtil.readFileAsBytes((URL)arrayList.get(i2)))) continue;
                    LOG.warn("Configuration conflict: there is more than one {} file on the classpath: {}", (Object)string, arrayList);
                    break;
                }
            }
            object = ((URL)arrayList.get(0)).openStream();
            try {
                if (object != null) {
                    properties.load((InputStream)object);
                }
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static byte[] readFileAsBytes(URL uRL) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }
}

