/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.unix.openbsd;

import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.gradle.maven.extension.internal.dep.oshi.jna.platform.unix.OpenBsdLibc;
import com.gradle.maven.extension.internal.dep.oshi.software.common.AbstractOSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.unix.openbsd.OpenBsdOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenBsdOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdOSProcess.class);
    static final String PS_THREAD_COLUMNS = Arrays.stream(PsThreadColumns.values()).map(Enum::name).map(string -> string.toLowerCase(Locale.ROOT)).collect(Collectors.joining(","));
    private static final int ARGMAX;
    private final OpenBsdOperatingSystem os;
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<List<String>> arguments = Memoizer.memoize(this::queryArguments);
    private Supplier<Map<String, String>> environmentVariables = Memoizer.memoize(this::queryEnvironmentVariables);
    private String name;
    private String path = "";
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;
    private int bitness;
    private String commandLineBackup;

    public OpenBsdOSProcess(int n2, Map<OpenBsdOperatingSystem.PsKeywords, String> map, OpenBsdOperatingSystem openBsdOperatingSystem) {
        super(n2);
        this.os = openBsdOperatingSystem;
        this.bitness = Native.LONG_SIZE * 8;
        this.updateThreadCount();
        this.updateAttributes(map);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String queryCommandLine() {
        String string = String.join((CharSequence)" ", this.getArguments());
        return string.isEmpty() ? this.commandLineBackup : string;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments.get();
    }

    private List<String> queryArguments() {
        if (ARGMAX > 0) {
            int[] nArray = new int[]{1, 55, this.getProcessID(), 1};
            try (Memory memory = new Memory(ARGMAX);
                 ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)ARGMAX);){
                if (OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO) == 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    long l2 = 0L;
                    long l3 = Pointer.nativeValue(memory);
                    long l4 = l3 + closeableSizeTByReference.getValue().longValue();
                    long l5 = Pointer.nativeValue(memory.getPointer(l2));
                    while (l5 > l3 && l5 < l4) {
                        arrayList.add(memory.getString(l5 - l3));
                        l5 = Pointer.nativeValue(memory.getPointer(l2 += (long)Native.POINTER_SIZE));
                    }
                    List<String> list = Collections.unmodifiableList(arrayList);
                    return list;
                }
            }
        }
        return Collections.emptyList();
    }

    private Map<String, String> queryEnvironmentVariables() {
        int[] nArray = new int[]{1, 55, this.getProcessID(), 3};
        try (Memory memory = new Memory(ARGMAX);
             ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)ARGMAX);){
            if (OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO) == 0) {
                Object object;
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                long l2 = 0L;
                long l3 = Pointer.nativeValue(memory);
                long l4 = l3 + closeableSizeTByReference.longValue();
                long l5 = Pointer.nativeValue(memory.getPointer(l2));
                while (l5 > l3 && l5 < l4) {
                    object = memory.getString(l5 - l3);
                    int n2 = ((String)object).indexOf(61);
                    if (n2 > 0) {
                        linkedHashMap.put(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
                    }
                    l5 = Pointer.nativeValue(memory.getPointer(l2 += (long)Native.POINTER_SIZE));
                }
                object = Collections.unmodifiableMap(linkedHashMap);
                return object;
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    private boolean updateAttributes(Map<OpenBsdOperatingSystem.PsKeywords, String> map) {
        long l2 = System.currentTimeMillis();
        switch (map.get((Object)OpenBsdOperatingSystem.PsKeywords.STATE).charAt(0)) {
            case 'R': {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 'I': 
            case 'S': {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': 
            case 'L': 
            case 'U': {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.parentProcessID = ParseUtil.parseIntOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.PPID), 0);
        this.user = map.get((Object)OpenBsdOperatingSystem.PsKeywords.USER);
        this.userID = map.get((Object)OpenBsdOperatingSystem.PsKeywords.UID);
        this.group = map.get((Object)OpenBsdOperatingSystem.PsKeywords.GROUP);
        this.groupID = map.get((Object)OpenBsdOperatingSystem.PsKeywords.GID);
        this.priority = ParseUtil.parseIntOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.PRI), 0);
        this.virtualSize = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.VSZ), 0L) * 1024L;
        this.residentSetSize = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.RSS), 0L) * 1024L;
        long l3 = ParseUtil.parseDHMSOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.ETIME), 0L);
        this.upTime = l3 < 1L ? 1L : l3;
        this.startTime = l2 - this.upTime;
        this.userTime = ParseUtil.parseDHMSOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.CPUTIME), 0L);
        this.kernelTime = 0L;
        this.path = map.get((Object)OpenBsdOperatingSystem.PsKeywords.COMM);
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.minorFaults = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.MINFLT), 0L);
        this.majorFaults = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.MAJFLT), 0L);
        long l4 = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.NIVCSW), 0L);
        long l5 = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.NVCSW), 0L);
        this.contextSwitches = l5 + l4;
        this.commandLineBackup = map.get((Object)OpenBsdOperatingSystem.PsKeywords.ARGS);
        return true;
    }

    private void updateThreadCount() {
        List<String> list = ExecutingCommand.runNative("ps -axHo tid -p " + this.getProcessID());
        if (!list.isEmpty()) {
            this.threadCount = list.size() - 1;
        }
        this.threadCount = 1;
    }

    static {
        int[] nArray = new int[]{1, 8};
        try (Memory memory = new Memory(4L);
             ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference(4L);){
            if (OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO) == 0) {
                ARGMAX = memory.getInt(0L);
            } else {
                LOG.warn("Failed sysctl call for process arguments max size (kern.argmax). Error code: {}", (Object)Native.getLastError());
                ARGMAX = 0;
            }
        }
    }

    static enum PsThreadColumns {
        TID,
        STATE,
        ETIME,
        CPUTIME,
        NIVCSW,
        NVCSW,
        MAJFLT,
        MINFLT,
        PRI,
        ARGS;

    }
}

