/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.linux;

import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.ProcessStat;
import com.gradle.maven.extension.internal.dep.oshi.software.common.AbstractOSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.linux.LinuxOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.GlobalConfig;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.UserGroupInfo;
import com.gradle.maven.extension.internal.dep.oshi.util.Util;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.linux.ProcPath;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxOSProcess.class);
    private static final boolean LOG_PROCFS_WARNING = GlobalConfig.get("com.gradle.maven.extension.internal.dep.oshi.os.linux.procfs.logwarning", false);
    private static final int[] PROC_PID_STAT_ORDERS = new int[ProcPidStat.values().length];
    private final LinuxOperatingSystem os;
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<List<String>> arguments = Memoizer.memoize(this::queryArguments);
    private Supplier<Map<String, String>> environmentVariables = Memoizer.memoize(this::queryEnvironmentVariables);
    private Supplier<String> user = Memoizer.memoize(this::queryUser);
    private Supplier<String> group = Memoizer.memoize(this::queryGroup);
    private String name;
    private String path = "";
    private String userID;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;

    public LinuxOSProcess(int n2, LinuxOperatingSystem linuxOperatingSystem) {
        super(n2);
        this.os = linuxOperatingSystem;
        this.updateAttributes();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String queryCommandLine() {
        return Arrays.stream(FileUtil.getStringFromFile(String.format(Locale.ROOT, ProcPath.PID_CMDLINE, this.getProcessID())).split("\u0000")).collect(Collectors.joining(" "));
    }

    @Override
    public List<String> getArguments() {
        return this.arguments.get();
    }

    private List<String> queryArguments() {
        return Collections.unmodifiableList(ParseUtil.parseByteArrayToStrings(FileUtil.readAllBytes(String.format(Locale.ROOT, ProcPath.PID_CMDLINE, this.getProcessID()), LOG_PROCFS_WARNING)));
    }

    private Map<String, String> queryEnvironmentVariables() {
        return Collections.unmodifiableMap(ParseUtil.parseByteArrayToStringMap(FileUtil.readAllBytes(String.format(Locale.ROOT, ProcPath.PID_ENVIRON, this.getProcessID()), LOG_PROCFS_WARNING)));
    }

    private String queryUser() {
        return UserGroupInfo.getUser(this.userID);
    }

    private String queryGroup() {
        return UserGroupInfo.getGroupName(this.groupID);
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int queryBitness() {
        byte[] byArray = new byte[5];
        if (this.path.isEmpty()) return 0;
        try (FileInputStream fileInputStream = new FileInputStream(this.path);){
            if (((InputStream)fileInputStream).read(byArray) != byArray.length) return 0;
            int n2 = byArray[4] == 1 ? 32 : 64;
            return n2;
        }
        catch (IOException iOException) {
            LOG.warn("Failed to read process file: {}", (Object)this.path);
        }
        return 0;
    }

    public boolean updateAttributes() {
        Object object;
        String string = String.format(Locale.ROOT, ProcPath.PID_EXE, this.getProcessID());
        try {
            object = Paths.get(string, new String[0]);
            this.path = Files.readSymbolicLink((Path)object).toString();
            int n2 = this.path.indexOf(" (deleted)");
            if (n2 != -1) {
                this.path = this.path.substring(0, n2);
            }
        }
        catch (IOException | SecurityException | UnsupportedOperationException | InvalidPathException exception) {
            LOG.debug("Unable to open symbolic link {}", (Object)string);
        }
        object = FileUtil.getKeyValueMapFromFile(String.format(Locale.ROOT, ProcPath.PID_IO, this.getProcessID()), ":");
        Map<String, String> map = FileUtil.getKeyValueMapFromFile(String.format(Locale.ROOT, ProcPath.PID_STATUS, this.getProcessID()), ":");
        String string2 = FileUtil.getStringFromFile(String.format(Locale.ROOT, ProcPath.PID_STAT, this.getProcessID()));
        if (string2.isEmpty()) {
            this.state = OSProcess.State.INVALID;
            return false;
        }
        LinuxOSProcess.getMissingDetails(map, string2);
        long l2 = System.currentTimeMillis();
        long[] lArray = ParseUtil.parseStringToLongArray(string2, PROC_PID_STAT_ORDERS, ProcessStat.PROC_PID_STAT_LENGTH, ' ');
        this.startTime = (LinuxOperatingSystem.BOOTTIME * LinuxOperatingSystem.getHz() + lArray[ProcPidStat.START_TIME.ordinal()]) * 1000L / LinuxOperatingSystem.getHz();
        if (this.startTime >= l2) {
            this.startTime = l2 - 1L;
        }
        this.parentProcessID = (int)lArray[ProcPidStat.PPID.ordinal()];
        this.threadCount = (int)lArray[ProcPidStat.THREAD_COUNT.ordinal()];
        this.priority = (int)lArray[ProcPidStat.PRIORITY.ordinal()];
        this.virtualSize = lArray[ProcPidStat.VSZ.ordinal()];
        this.residentSetSize = lArray[ProcPidStat.RSS.ordinal()] * LinuxOperatingSystem.getPageSize();
        this.kernelTime = lArray[ProcPidStat.KERNEL_TIME.ordinal()] * 1000L / LinuxOperatingSystem.getHz();
        this.userTime = lArray[ProcPidStat.USER_TIME.ordinal()] * 1000L / LinuxOperatingSystem.getHz();
        this.minorFaults = lArray[ProcPidStat.MINOR_FAULTS.ordinal()];
        this.majorFaults = lArray[ProcPidStat.MAJOR_FAULTS.ordinal()];
        long l3 = ParseUtil.parseLongOrDefault(map.get("nonvoluntary_ctxt_switches"), 0L);
        long l4 = ParseUtil.parseLongOrDefault(map.get("voluntary_ctxt_switches"), 0L);
        this.contextSwitches = l4 + l3;
        this.upTime = l2 - this.startTime;
        this.bytesRead = ParseUtil.parseLongOrDefault(object.getOrDefault("read_bytes", ""), 0L);
        this.bytesWritten = ParseUtil.parseLongOrDefault(object.getOrDefault("write_bytes", ""), 0L);
        this.userID = ParseUtil.whitespaces.split(map.getOrDefault("Uid", ""))[0];
        this.groupID = ParseUtil.whitespaces.split(map.getOrDefault("Gid", ""))[0];
        this.name = map.getOrDefault("Name", "");
        this.state = ProcessStat.getState(map.getOrDefault("State", "U").charAt(0));
        return true;
    }

    private static void getMissingDetails(Map<String, String> map, String string) {
        String string2;
        if (map == null || string == null) {
            return;
        }
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41);
        if (Util.isBlank(map.get("Name")) && n2 > 0 && n2 < n3) {
            string2 = string.substring(n2 + 1, n3);
            map.put("Name", string2);
        }
        if (Util.isBlank(map.get("State")) && n3 > 0 && string.length() > n3 + 2) {
            string2 = String.valueOf(string.charAt(n3 + 2));
            map.put("State", string2);
        }
    }

    static {
        for (ProcPidStat procPidStat : ProcPidStat.values()) {
            LinuxOSProcess.PROC_PID_STAT_ORDERS[procPidStat.ordinal()] = procPidStat.getOrder() - 1;
        }
    }

    private static enum ProcPidStat {
        PPID(4),
        MINOR_FAULTS(10),
        MAJOR_FAULTS(12),
        USER_TIME(14),
        KERNEL_TIME(15),
        PRIORITY(18),
        THREAD_COUNT(20),
        START_TIME(22),
        VSZ(23),
        RSS(24);

        private final int order;

        public int getOrder() {
            return this.order;
        }

        private ProcPidStat(int n3) {
            this.order = n3;
        }
    }
}

