/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.linux;

import com.gradle.maven.extension.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class LinuxInstalledApps {
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private static final Map<String, String> PACKAGE_MANAGER_COMMANDS = LinuxInstalledApps.initializePackageManagerCommands();

    private static Map<String, String> initializePackageManagerCommands() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (LinuxInstalledApps.isPackageManagerAvailable("dpkg")) {
            hashMap.put("dpkg", "dpkg-query -W -f=${Package}|${Version}|${Architecture}|${Installed-Size}|${db-fsys:Last-Modified}|${Maintainer}|${Source}|${Homepage}\\n");
        } else if (LinuxInstalledApps.isPackageManagerAvailable("rpm")) {
            hashMap.put("rpm", "rpm -qa --queryformat %{NAME}|%{VERSION}-%{RELEASE}|%{ARCH}|%{SIZE}|%{INSTALLTIME}|%{PACKAGER}|%{SOURCERPM}|%{URL}\\n");
        }
        return hashMap;
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        List<String> list = LinuxInstalledApps.fetchInstalledApps();
        return LinuxInstalledApps.parseLinuxAppInfo(list);
    }

    private static List<String> fetchInstalledApps() {
        if (PACKAGE_MANAGER_COMMANDS.isEmpty()) {
            return Collections.emptyList();
        }
        String string = PACKAGE_MANAGER_COMMANDS.values().iterator().next();
        return ExecutingCommand.runNative(string);
    }

    private static boolean isPackageManagerAvailable(String string) {
        List<String> list = ExecutingCommand.runNative(string + " --version");
        return !list.isEmpty();
    }

    private static List<ApplicationInfo> parseLinuxAppInfo(List<String> list) {
        LinkedHashSet<ApplicationInfo> linkedHashSet = new LinkedHashSet<ApplicationInfo>();
        for (String string : list) {
            String[] stringArray = PIPE_PATTERN.split(string, -1);
            if (stringArray.length < 8) continue;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("architecture", ParseUtil.getStringValueOrUnknown(stringArray[2]));
            linkedHashMap.put("installedSize", String.valueOf(ParseUtil.parseLongOrDefault(stringArray[3], 0L)));
            linkedHashMap.put("source", ParseUtil.getStringValueOrUnknown(stringArray[6]));
            linkedHashMap.put("homepage", ParseUtil.getStringValueOrUnknown(stringArray[7]));
            ApplicationInfo applicationInfo = new ApplicationInfo(ParseUtil.getStringValueOrUnknown(stringArray[0]), ParseUtil.getStringValueOrUnknown(stringArray[1]), ParseUtil.getStringValueOrUnknown(stringArray[5]), ParseUtil.parseLongOrDefault(stringArray[4], 0L), linkedHashMap);
            linkedHashSet.add(applicationInfo);
        }
        return new ArrayList<ApplicationInfo>(linkedHashSet);
    }
}

