/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.openbsd;

import com.gradle.maven.extension.internal.dep.oshi.hardware.CentralProcessor;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractCentralProcessor;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.unix.openbsd.OpenBsdSysctlUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Quartet;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Triplet;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenBsdCentralProcessor
extends AbstractCentralProcessor {
    private final Supplier<Pair<Long, Long>> vmStats = Memoizer.memoize(OpenBsdCentralProcessor::queryVmStats, Memoizer.defaultExpiration());
    private static final Pattern DMESG_CPU = Pattern.compile("cpu(\\d+): smt (\\d+), core (\\d+), package (\\d+)");

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String string = OpenBsdSysctlUtil.sysctl("machdep.cpuvendor", "");
        int[] nArray = new int[]{6, 2};
        String string2 = OpenBsdSysctlUtil.sysctl(nArray, "");
        int n2 = ParseUtil.hexStringToInt(OpenBsdSysctlUtil.sysctl("machdep.cpuid", ""), 0);
        int n3 = ParseUtil.hexStringToInt(OpenBsdSysctlUtil.sysctl("machdep.cpufeature", ""), 0);
        Triplet<Integer, Integer, Integer> triplet = OpenBsdCentralProcessor.cpuidToFamilyModelStepping(n2);
        String string3 = triplet.getA().toString();
        String string4 = triplet.getB().toString();
        String string5 = triplet.getC().toString();
        long l2 = ParseUtil.parseHertz(string2);
        if (l2 < 0L) {
            l2 = this.queryMaxFreq();
        }
        nArray[1] = 1;
        String string6 = OpenBsdSysctlUtil.sysctl(nArray, "");
        boolean bl2 = string6 != null && string6.contains("64") || ExecutingCommand.getFirstAnswer("uname -m").trim().contains("64");
        String string7 = String.format(Locale.ROOT, "%08x%08x", n3, n2);
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, string7, bl2, l2);
    }

    private static Triplet<Integer, Integer, Integer> cpuidToFamilyModelStepping(int n2) {
        int n3 = n2 >> 16 & 0xFF0 | n2 >> 8 & 0xF;
        int n4 = n2 >> 12 & 0xF0 | n2 >> 4 & 0xF;
        int n5 = n2 & 0xF;
        return new Triplet<Integer, Integer, Integer>(n3, n4, n5);
    }

    @Override
    protected long[] queryCurrentFreq() {
        long[] lArray = new long[1];
        int[] nArray = new int[]{6, 12};
        lArray[0] = OpenBsdSysctlUtil.sysctl(nArray, 0L) * 1000000L;
        return lArray;
    }

    @Override
    protected Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>> initProcessorCounts() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        for (String object2 : ExecutingCommand.runNative("dmesg")) {
            Matcher i2 = DMESG_CPU.matcher(object2);
            if (!i2.matches()) continue;
            int pattern = ParseUtil.parseIntOrDefault(i2.group(1), 0);
            hashMap.put(pattern, ParseUtil.parseIntOrDefault(i2.group(3), 0));
            hashMap2.put(pattern, ParseUtil.parseIntOrDefault(i2.group(4), 0));
        }
        int n3 = OpenBsdSysctlUtil.sysctl("hw.ncpuonline", 1);
        if (n3 < hashMap.keySet().size()) {
            n3 = hashMap.keySet().size();
        }
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>(n3);
        for (int hashMap3 = 0; hashMap3 < n3; ++hashMap3) {
            arrayList.add(new CentralProcessor.LogicalProcessor(hashMap3, hashMap.getOrDefault(hashMap3, 0), hashMap2.getOrDefault(hashMap3, 0)));
        }
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        Pattern pattern = Pattern.compile("cpu(\\\\d+).*: ((ARM|AMD|Intel|Apple).+)");
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        Pattern pattern2 = Pattern.compile("cpu(\\\\d+).*: (.+(I-|D-|L\\d+\\s)cache)");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : ExecutingCommand.runNative("dmesg")) {
            String[] stringArray;
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                int matcher2 = ParseUtil.parseIntOrDefault(matcher.group(1), 0);
                hashMap3.put(matcher2, matcher.group(2).trim());
            } else {
                Matcher stringArray2 = pattern2.matcher(string);
                if (stringArray2.matches()) {
                    for (String string2 : stringArray2.group(1).split(",")) {
                        CentralProcessor.ProcessorCache processorCache = this.parseCacheStr(string2);
                        if (processorCache == null) continue;
                        hashSet.add(processorCache);
                    }
                }
            }
            if (!string.startsWith("cpu") || (stringArray = string.trim().split(": ")).length != 2 || stringArray[1].split(",").length <= 3) continue;
            linkedHashSet.add(stringArray[1]);
        }
        Iterator<String> iterator = hashMap3.isEmpty() ? null : this.createProcListFromDmesg(arrayList, hashMap3);
        return new Quartet(arrayList, iterator, OpenBsdCentralProcessor.orderedProcCaches(hashSet), new ArrayList(linkedHashSet));
    }

    private CentralProcessor.ProcessorCache parseCacheStr(String string) {
        String[] stringArray = ParseUtil.whitespaces.split(string);
        if (stringArray.length > 3) {
            switch (stringArray[stringArray.length - 1]) {
                case "I-cache": {
                    return new CentralProcessor.ProcessorCache(1, ParseUtil.getFirstIntValue(stringArray[2]), ParseUtil.getFirstIntValue(stringArray[1]), ParseUtil.parseDecimalMemorySizeToBinary(stringArray[0]), CentralProcessor.ProcessorCache.Type.INSTRUCTION);
                }
                case "D-cache": {
                    return new CentralProcessor.ProcessorCache(1, ParseUtil.getFirstIntValue(stringArray[2]), ParseUtil.getFirstIntValue(stringArray[1]), ParseUtil.parseDecimalMemorySizeToBinary(stringArray[0]), CentralProcessor.ProcessorCache.Type.DATA);
                }
            }
            return new CentralProcessor.ProcessorCache(ParseUtil.getFirstIntValue(stringArray[3]), ParseUtil.getFirstIntValue(stringArray[2]), ParseUtil.getFirstIntValue(stringArray[1]), ParseUtil.parseDecimalMemorySizeToBinary(stringArray[0]), CentralProcessor.ProcessorCache.Type.UNIFIED);
        }
        return null;
    }

    @Override
    protected long queryContextSwitches() {
        return this.vmStats.get().getA();
    }

    @Override
    protected long queryInterrupts() {
        return this.vmStats.get().getB();
    }

    private static Pair<Long, Long> queryVmStats() {
        long l2 = 0L;
        long l3 = 0L;
        List<String> list = ExecutingCommand.runNative("vmstat -s");
        for (String string : list) {
            if (string.endsWith("cpu context switches")) {
                l2 = ParseUtil.getFirstIntValue(string);
                continue;
            }
            if (!string.endsWith("interrupts")) continue;
            l3 = ParseUtil.getFirstIntValue(string);
        }
        return new Pair<Long, Long>(l2, l3);
    }

    @Override
    protected long[] querySystemCpuLoadTicks() {
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        int[] nArray = new int[]{1, 40};
        try (Memory memory = OpenBsdSysctlUtil.sysctl(nArray);){
            long[] lArray2 = OpenBsdCentralProcessor.cpTimeToTicks(memory, false);
            if (lArray2.length >= 5) {
                lArray[CentralProcessor.TickType.USER.getIndex()] = lArray2[0];
                lArray[CentralProcessor.TickType.NICE.getIndex()] = lArray2[1];
                lArray[CentralProcessor.TickType.SYSTEM.getIndex()] = lArray2[2];
                int n2 = lArray2.length > 5 ? 1 : 0;
                lArray[CentralProcessor.TickType.IRQ.getIndex()] = lArray2[3 + n2];
                lArray[CentralProcessor.TickType.IDLE.getIndex()] = lArray2[4 + n2];
            }
        }
        return lArray;
    }

    @Override
    protected long[][] queryProcessorCpuLoadTicks() {
        long[][] lArray = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 71;
        for (int i2 = 0; i2 < this.getLogicalProcessorCount(); ++i2) {
            nArray[2] = i2;
            try (Memory memory = OpenBsdSysctlUtil.sysctl(nArray);){
                long[] lArray2 = OpenBsdCentralProcessor.cpTimeToTicks(memory, true);
                if (lArray2.length < 5) continue;
                lArray[i2][CentralProcessor.TickType.USER.getIndex()] = lArray2[0];
                lArray[i2][CentralProcessor.TickType.NICE.getIndex()] = lArray2[1];
                lArray[i2][CentralProcessor.TickType.SYSTEM.getIndex()] = lArray2[2];
                int n2 = lArray2.length > 5 ? 1 : 0;
                lArray[i2][CentralProcessor.TickType.IRQ.getIndex()] = lArray2[3 + n2];
                lArray[i2][CentralProcessor.TickType.IDLE.getIndex()] = lArray2[4 + n2];
                continue;
            }
        }
        return lArray;
    }

    private static long[] cpTimeToTicks(Memory memory, boolean bl2) {
        int n2;
        long l2 = bl2 ? 8L : (long)Native.LONG_SIZE;
        int n3 = n2 = memory == null ? 0 : (int)(memory.size() / l2);
        if (bl2 && memory != null) {
            return memory.getLongArray(0L, n2);
        }
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = memory.getNativeLong((long)i2 * l2).longValue();
        }
        return lArray;
    }
}

