/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.driver.unix.solaris.kstat;

import com.gradle.maven.extension.internal.dep.oshi.software.os.unix.solaris.SolarisOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.unix.solaris.KstatUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.platform.unix.solaris.LibKstat;

public final class SystemPages {
    public static Pair<Long, Long> queryAvailableTotal() {
        if (SolarisOperatingSystem.HAS_KSTAT2) {
            return SystemPages.queryAvailableTotal2();
        }
        long l2 = 0L;
        long l3 = 0L;
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            LibKstat.Kstat kstat = kstatChain.lookup(null, -1, "system_pages");
            if (kstat != null && kstatChain.read(kstat)) {
                l2 = KstatUtil.dataLookupLong(kstat, "availrmem");
                l3 = KstatUtil.dataLookupLong(kstat, "physmem");
            }
        }
        return new Pair<Long, Long>(l2, l3);
    }

    private static Pair<Long, Long> queryAvailableTotal2() {
        Object[] objectArray = KstatUtil.queryKstat2("kstat:/pages/unix/system_pages", "availrmem", "physmem");
        long l2 = objectArray[0] == null ? 0L : (Long)objectArray[0];
        long l3 = objectArray[1] == null ? 0L : (Long)objectArray[1];
        return new Pair<Long, Long>(l2, l3);
    }
}

