/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.driver.mac.net;

import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetStat {
    private static final Logger LOG = LoggerFactory.getLogger(NetStat.class);

    private NetStat() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Integer, IFdata> queryIFdata(int n2) {
        HashMap<Integer, IFdata> hashMap = new HashMap<Integer, IFdata>();
        int[] nArray = new int[]{4, 17, 0, 0, 6, 0};
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            if (0 != SystemB.INSTANCE.sysctl(nArray, 6, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.error("Didn't get buffer length for IFLIST2");
                HashMap<Integer, IFdata> hashMap2 = hashMap;
                return hashMap2;
            }
            try (Memory memory = new Memory(closeableSizeTByReference.longValue());){
                block19: {
                    if (0 != SystemB.INSTANCE.sysctl(nArray, 6, (Pointer)memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                        LOG.error("Didn't get buffer for IFLIST2");
                        HashMap<Integer, IFdata> hashMap3 = hashMap;
                        return hashMap3;
                    }
                    long l2 = System.currentTimeMillis();
                    int n3 = (int)(memory.size() - (long)new SystemB.IFmsgHdr().size());
                    int n4 = 0;
                    while (n4 < n3) {
                        Pointer pointer = memory.share(n4);
                        SystemB.IFmsgHdr iFmsgHdr = new SystemB.IFmsgHdr(pointer);
                        iFmsgHdr.read();
                        n4 += iFmsgHdr.ifm_msglen;
                        if (iFmsgHdr.ifm_type != 18) continue;
                        SystemB.IFmsgHdr2 iFmsgHdr2 = new SystemB.IFmsgHdr2(pointer);
                        iFmsgHdr2.read();
                        if (n2 >= 0 && n2 != iFmsgHdr2.ifm_index) continue;
                        hashMap.put(Integer.valueOf(iFmsgHdr2.ifm_index), new IFdata(0xFF & iFmsgHdr2.ifm_data.ifi_type, iFmsgHdr2.ifm_data.ifi_opackets, iFmsgHdr2.ifm_data.ifi_ipackets, iFmsgHdr2.ifm_data.ifi_obytes, iFmsgHdr2.ifm_data.ifi_ibytes, iFmsgHdr2.ifm_data.ifi_oerrors, iFmsgHdr2.ifm_data.ifi_ierrors, iFmsgHdr2.ifm_data.ifi_collisions, iFmsgHdr2.ifm_data.ifi_iqdrops, iFmsgHdr2.ifm_data.ifi_baudrate, l2));
                        if (n2 < 0) {
                            continue;
                        }
                        break block19;
                    }
                    return hashMap;
                }
                HashMap<Integer, IFdata> hashMap4 = hashMap;
                return hashMap4;
            }
        }
    }

    public static class IFdata {
        private final int ifType;
        private final long oPackets;
        private final long iPackets;
        private final long oBytes;
        private final long iBytes;
        private final long oErrors;
        private final long iErrors;
        private final long collisions;
        private final long iDrops;
        private final long speed;
        private final long timeStamp;

        IFdata(int n2, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11) {
            this.ifType = n2;
            this.oPackets = l2 & 0xFFFFFFFFL;
            this.iPackets = l3 & 0xFFFFFFFFL;
            this.oBytes = l4 & 0xFFFFFFFFL;
            this.iBytes = l5 & 0xFFFFFFFFL;
            this.oErrors = l6 & 0xFFFFFFFFL;
            this.iErrors = l7 & 0xFFFFFFFFL;
            this.collisions = l8 & 0xFFFFFFFFL;
            this.iDrops = l9 & 0xFFFFFFFFL;
            this.speed = l10 & 0xFFFFFFFFL;
            this.timeStamp = l11;
        }

        public int getIfType() {
            return this.ifType;
        }

        public long getOPackets() {
            return this.oPackets;
        }

        public long getIPackets() {
            return this.iPackets;
        }

        public long getOBytes() {
            return this.oBytes;
        }

        public long getIBytes() {
            return this.iBytes;
        }

        public long getOErrors() {
            return this.oErrors;
        }

        public long getIErrors() {
            return this.iErrors;
        }

        public long getCollisions() {
            return this.collisions;
        }

        public long getIDrops() {
            return this.iDrops;
        }

        public long getSpeed() {
            return this.speed;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }
    }
}

