/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.spi.AbstractLoggerAdapter;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerAdapter;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.util.StackLocatorUtil;

public final class Log4jApiLogFactory
extends LogFactory {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Marker MARKER = MarkerManager.getMarker((String)"COMMONS-LOGGING");
    private final LoggerAdapter<Log> adapter = new LogAdapter();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    @Override
    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(EMPTY_ARRAY);
    }

    @Override
    public Log getInstance(Class<?> clazz) {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String string) {
        return (Log)this.adapter.getLogger(string);
    }

    @Override
    public void release() {
        try {
            this.adapter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.removeAttribute(string);
        }
    }

    private static final class LogAdapter
    extends AbstractLoggerAdapter<Log> {
        private LogAdapter() {
        }

        protected LoggerContext getContext() {
            return this.getContext(LogManager.getFactory().isClassLoaderDependent() ? StackLocatorUtil.getCallerClass(LogFactory.class) : null);
        }

        protected Log newLogger(String string, LoggerContext loggerContext) {
            return new Log4j2Log(loggerContext.getLogger(string));
        }
    }

    private static final class Log4j2Log
    implements Log {
        private static final String FQCN = Log4j2Log.class.getName();
        private final ExtendedLogger logger;

        public Log4j2Log(ExtendedLogger extendedLogger) {
            this.logger = extendedLogger;
        }

        @Override
        public void debug(Object object) {
            this.logIfEnabled(Level.DEBUG, object, null);
        }

        @Override
        public void debug(Object object, Throwable throwable) {
            this.logIfEnabled(Level.DEBUG, object, throwable);
        }

        @Override
        public void error(Object object) {
            this.logIfEnabled(Level.ERROR, object, null);
        }

        @Override
        public void error(Object object, Throwable throwable) {
            this.logIfEnabled(Level.ERROR, object, throwable);
        }

        public void fatal(Object object) {
            this.logIfEnabled(Level.FATAL, object, null);
        }

        public void fatal(Object object, Throwable throwable) {
            this.logIfEnabled(Level.FATAL, object, throwable);
        }

        @Override
        public void info(Object object) {
            this.logIfEnabled(Level.INFO, object, null);
        }

        public void info(Object object, Throwable throwable) {
            this.logIfEnabled(Level.INFO, object, throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isEnabled(Level.DEBUG);
        }

        private boolean isEnabled(Level level) {
            return this.logger.isEnabled(level, MARKER, null);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isEnabled(Level.ERROR);
        }

        public boolean isFatalEnabled() {
            return this.isEnabled(Level.FATAL);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isEnabled(Level.INFO);
        }

        public boolean isTraceEnabled() {
            return this.isEnabled(Level.TRACE);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isEnabled(Level.WARN);
        }

        private void logIfEnabled(Level level, Object object, Throwable throwable) {
            if (object instanceof CharSequence) {
                this.logger.logIfEnabled(FQCN, level, MARKER, (CharSequence)object, throwable);
            } else {
                this.logger.logIfEnabled(FQCN, level, MARKER, object, throwable);
            }
        }

        @Override
        public void trace(Object object) {
            this.logIfEnabled(Level.TRACE, object, null);
        }

        public void trace(Object object, Throwable throwable) {
            this.logIfEnabled(Level.TRACE, object, throwable);
        }

        @Override
        public void warn(Object object) {
            this.logIfEnabled(Level.WARN, object, null);
        }

        @Override
        public void warn(Object object, Throwable throwable) {
            this.logIfEnabled(Level.WARN, object, throwable);
        }
    }
}

