/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.logging;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogConfigurationException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public abstract class LogFactory {
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory";
    private static final String FACTORY_LOG4J_API = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.Log4jApiLogFactory";
    private static final String LOG4J_TO_SLF4J_BRIDGE = "org.apache.logging.slf4j.SLF4JProvider";
    private static final String FACTORY_SLF4J = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.Slf4jLogFactory";
    public static final String FACTORY_DEFAULT = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.diagnostics.dest";
    private static final PrintStream DIAGNOSTICS_STREAM;
    private static final String DIAGNOSTICS_PREFIX;
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory.HashtableImpl";
    private static final String WEAK_HASHTABLE_CLASSNAME = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl.WeakHashtable";
    private static final WeakReference<ClassLoader> thisClassLoaderRef;
    private static final int MAX_BROKEN_SERVICES = 3;
    protected static Hashtable<ClassLoader, LogFactory> factories;
    @Deprecated
    protected static volatile LogFactory nullClassLoaderFactory;

    private static void cacheFactory(ClassLoader classLoader, LogFactory logFactory) {
        if (logFactory != null) {
            if (classLoader == null) {
                nullClassLoaderFactory = logFactory;
            } else {
                factories.put(classLoader, logFactory);
            }
        }
    }

    protected static Object createFactory(String string, ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            block20: {
                if (classLoader != null) {
                    try {
                        clazz = classLoader.loadClass(string);
                        if (LogFactory.class.isAssignableFrom(clazz)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Loaded class " + clazz.getName() + " from class loader " + LogFactory.objectId(classLoader));
                            }
                        } else if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("Factory class " + clazz.getName() + " loaded from class loader " + LogFactory.objectId(clazz.getClassLoader()) + " does not extend '" + LogFactory.class.getName() + "' as loaded by this class loader.");
                            LogFactory.logHierarchy("[BAD CL TREE] ", classLoader);
                        }
                        return LogFactory.class.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (classLoader == thisClassLoaderRef.get()) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Unable to locate any class called '" + string + "' via class loader " + LogFactory.objectId(classLoader));
                            }
                            throw classNotFoundException;
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        if (classLoader == thisClassLoaderRef.get()) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Class '" + string + "' cannot be loaded via class loader " + LogFactory.objectId(classLoader) + " - it depends on some other class that cannot be found.");
                            }
                            throw noClassDefFoundError;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        if (classLoader != thisClassLoaderRef.get()) break block20;
                        boolean bl2 = LogFactory.implementsLogFactory(clazz);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("The application has specified that a custom LogFactory implementation should be used but Class '");
                        stringBuilder.append(string);
                        stringBuilder.append("' cannot be converted to '");
                        stringBuilder.append(LogFactory.class.getName());
                        stringBuilder.append("'. ");
                        if (bl2) {
                            stringBuilder.append("The conflict is caused by the presence of multiple LogFactory classes in incompatible class loaders. Background can");
                            stringBuilder.append(" be found in https://commons.apache.org/logging/tech.html. If you have not explicitly specified a custom LogFactory");
                            stringBuilder.append(" then it is likely that the container has set one without your knowledge. In this case, consider using the ");
                            stringBuilder.append("commons-logging-adapters.jar file or specifying the standard LogFactory from the command line. ");
                        } else {
                            stringBuilder.append("Please check the custom implementation. ");
                        }
                        stringBuilder.append("Help can be found at https://commons.apache.org/logging/troubleshooting.html.");
                        LogFactory.logDiagnostic(stringBuilder.toString());
                        throw new ClassCastException(stringBuilder.toString());
                    }
                }
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to load factory class via class loader " + LogFactory.objectId(classLoader) + " - trying the class loader associated with this LogFactory.");
            }
            clazz = Class.forName(string);
            return LogFactory.class.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exception) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to create LogFactory instance.");
            }
            if (clazz != null && !LogFactory.class.isAssignableFrom(clazz)) {
                return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", exception);
            }
            return new LogConfigurationException(exception);
        }
    }

    private static Hashtable<ClassLoader, LogFactory> createFactoryStore() {
        Hashtable hashtable;
        block7: {
            String string;
            hashtable = null;
            try {
                string = LogFactory.getSystemProperty(HASHTABLE_IMPLEMENTATION_PROPERTY, null);
            }
            catch (SecurityException securityException) {
                string = null;
            }
            if (string == null) {
                string = WEAK_HASHTABLE_CLASSNAME;
            }
            try {
                Class<?> clazz = Class.forName(string);
                hashtable = (Hashtable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                LogFactory.handleThrowable(throwable);
                if (WEAK_HASHTABLE_CLASSNAME.equals(string)) break block7;
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[ERROR] LogFactory: Load of custom Hashtable failed");
                }
                System.err.println("[ERROR] LogFactory: Load of custom Hashtable failed");
            }
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    protected static ClassLoader directGetContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(ClassLoader classLoader) {
        if (classLoader == null) {
            return nullClassLoaderFactory;
        }
        return factories.get(classLoader);
    }

    protected static ClassLoader getClassLoader(Class<?> clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic(() -> "Unable to get class loader for class '" + clazz + "' due to security restrictions - " + securityException.getMessage());
            throw securityException;
        }
    }

    private static Properties getConfigurationFile(ClassLoader classLoader, String string) {
        Properties properties = null;
        double d2 = 0.0;
        URL uRL = null;
        try {
            Enumeration<URL> enumeration = LogFactory.getResources(classLoader, string);
            if (enumeration == null) {
                return null;
            }
            while (enumeration.hasMoreElements()) {
                String string2;
                URL uRL2 = enumeration.nextElement();
                Properties properties2 = LogFactory.getProperties(uRL2);
                if (properties2 == null) continue;
                if (properties == null) {
                    uRL = uRL2;
                    properties = properties2;
                    string2 = properties.getProperty(PRIORITY_KEY);
                    d2 = 0.0;
                    if (string2 != null) {
                        d2 = Double.parseDouble(string2);
                    }
                    if (!LogFactory.isDiagnosticsEnabled()) continue;
                    LogFactory.logDiagnostic("[LOOKUP] Properties file found at '" + uRL2 + "' with priority " + d2);
                    continue;
                }
                string2 = properties2.getProperty(PRIORITY_KEY);
                double d3 = 0.0;
                if (string2 != null) {
                    d3 = Double.parseDouble(string2);
                }
                if (d3 > d2) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + uRL2 + "' with priority " + d3 + " overrides file at '" + uRL + "' with priority " + d2);
                    }
                    uRL = uRL2;
                    properties = properties2;
                    d2 = d3;
                    continue;
                }
                if (!LogFactory.isDiagnosticsEnabled()) continue;
                LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + uRL2 + "' with priority " + d3 + " does not override file at '" + uRL + "' with priority " + d2);
            }
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic("SecurityException thrown while trying to find/read config files.");
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            if (properties == null) {
                LogFactory.logDiagnostic("[LOOKUP] No properties file of name '" + string + "' found.");
            } else {
                LogFactory.logDiagnostic("[LOOKUP] Properties file of name '" + string + "' found at '" + uRL + '\"');
            }
        }
        return properties;
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.directGetContextClassLoader();
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return AccessController.doPrivileged(LogFactory::directGetContextClassLoader);
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        Object object;
        Enumeration<?> enumeration;
        Object object2;
        boolean bl2;
        LogFactory logFactory;
        ClassLoader classLoader = LogFactory.getContextClassLoaderInternal();
        if (classLoader == null) {
            LogFactory.logDiagnostic("Context class loader is null.");
        }
        if ((logFactory = LogFactory.getCachedFactory(classLoader)) != null) {
            return logFactory;
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("[LOOKUP] LogFactory implementation requested for the first time for context class loader " + LogFactory.objectId(classLoader));
            LogFactory.logHierarchy("[LOOKUP] ", classLoader);
        }
        Properties properties = LogFactory.getConfigurationFile(classLoader, FACTORY_PROPERTIES);
        boolean bl3 = bl2 = classLoader != null;
        if (properties != null) {
            object2 = properties.getProperty(TCCL_KEY);
            bl2 &= object2 == null || Boolean.parseBoolean((String)object2);
        }
        if (bl2) {
            try {
                if (!LogFactory.class.equals(Class.forName(LogFactory.class.getName(), false, classLoader))) {
                    LogFactory.logDiagnostic(() -> "The class " + LogFactory.class.getName() + " loaded by the context class loader " + LogFactory.objectId(classLoader) + " and this class differ. Disabling the usage of the context class loader.Background can be found in https://commons.apache.org/logging/tech.html. ");
                    LogFactory.logHierarchy("[BAD CL TREE] ", classLoader);
                    bl2 = false;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogFactory.logDiagnostic(() -> "The class " + LogFactory.class.getName() + " is not present in the the context class loader " + LogFactory.objectId(classLoader) + ". Disabling the usage of the context class loader.Background can be found in https://commons.apache.org/logging/tech.html. ");
                LogFactory.logHierarchy("[BAD CL TREE] ", classLoader);
                bl2 = false;
            }
        }
        object2 = bl2 ? classLoader : (ClassLoader)thisClassLoaderRef.get();
        LogFactory.logDiagnostic(() -> "[LOOKUP] Looking for system property [org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
        try {
            enumeration = LogFactory.getSystemProperty(FACTORY_PROPERTY, null);
            if (enumeration != null) {
                LogFactory.logDiagnostic(() -> LogFactory.lambda$getFactory$4((String)((Object)enumeration)));
                logFactory = LogFactory.newFactory((String)((Object)enumeration), (ClassLoader)object2, classLoader);
            } else {
                LogFactory.logDiagnostic(() -> "[LOOKUP] No system property [org.apache.commons.logging.LogFactory] defined.");
            }
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic(() -> "[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(securityException.getMessage()) + "]. Trying alternative implementations...");
        }
        catch (RuntimeException runtimeException) {
            LogFactory.logDiagnostic(() -> "[LOOKUP] An exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(runtimeException.getMessage()) + "] as specified by a system property.");
            throw runtimeException;
        }
        if (logFactory == null) {
            LogFactory.logDiagnostic("[LOOKUP] Using ServiceLoader  to define the LogFactory subclass to use...");
            try {
                enumeration = ServiceLoader.load(LogFactory.class, (ClassLoader)object2);
                object = ((ServiceLoader)((Object)enumeration)).iterator();
                int n2 = 3;
                while (logFactory == null && n2-- > 0) {
                    try {
                        if (!object.hasNext()) continue;
                        logFactory = (LogFactory)object.next();
                    }
                    catch (LinkageError | ServiceConfigurationError error) {
                        LogFactory.logDiagnostic(() -> "[LOOKUP] An exception occurred while trying to find an instance of LogFactory: [" + LogFactory.trim(error.getMessage()) + "]. Trying alternative implementations...");
                    }
                }
            }
            catch (Exception exception) {
                LogFactory.logDiagnostic(() -> "[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(exception.getMessage()) + "]. Trying alternative implementations...");
            }
        }
        if (logFactory == null) {
            if (properties != null) {
                LogFactory.logDiagnostic(() -> "[LOOKUP] Looking in properties file for entry with key 'org.apache.commons.logging.LogFactory' to define the LogFactory subclass to use...");
                enumeration = properties.getProperty(FACTORY_PROPERTY);
                if (enumeration != null) {
                    LogFactory.logDiagnostic(() -> LogFactory.lambda$getFactory$11((String)((Object)enumeration)));
                    logFactory = LogFactory.newFactory((String)((Object)enumeration), (ClassLoader)object2, classLoader);
                } else {
                    LogFactory.logDiagnostic("[LOOKUP] Properties file has no entry specifying LogFactory subclass.");
                }
            } else {
                LogFactory.logDiagnostic("[LOOKUP] No properties file available to determine LogFactory subclass from..");
            }
        }
        if (logFactory == null) {
            logFactory = LogFactory.newStandardFactory((ClassLoader)object2);
        }
        if (logFactory == null && object2 != thisClassLoaderRef.get()) {
            logFactory = LogFactory.newStandardFactory((ClassLoader)thisClassLoaderRef.get());
        }
        if (logFactory != null) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Created object " + LogFactory.objectId(logFactory) + " to manage class loader " + LogFactory.objectId(classLoader));
            }
        } else {
            LogFactory.logDiagnostic(() -> "[LOOKUP] Loading the default LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl' via the same class loader that loaded this LogFactory class (ie not looking in the context class loader).");
            logFactory = LogFactory.newFactory(FACTORY_DEFAULT, (ClassLoader)thisClassLoaderRef.get(), classLoader);
        }
        if (logFactory != null) {
            LogFactory.cacheFactory(classLoader, logFactory);
            if (properties != null) {
                enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = Objects.toString(enumeration.nextElement(), null);
                    String string = properties.getProperty((String)object);
                    logFactory.setAttribute((String)object, string);
                }
            }
        }
        return logFactory;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(string);
    }

    private static Properties getProperties(URL uRL) {
        return AccessController.doPrivileged(() -> {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                try (InputStream inputStream = uRLConnection.getInputStream();){
                    if (inputStream == null) return null;
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    Properties properties2 = properties;
                    return properties2;
                }
                catch (IOException iOException) {
                    LogFactory.logDiagnostic(() -> "Unable to close stream for URL " + uRL);
                    return null;
                }
            }
            catch (IOException iOException) {
                LogFactory.logDiagnostic(() -> "Unable to read URL " + uRL);
            }
            return null;
        });
    }

    private static Enumeration<URL> getResources(ClassLoader classLoader, String string) {
        return AccessController.doPrivileged(() -> {
            try {
                if (classLoader != null) {
                    return classLoader.getResources(string);
                }
                return ClassLoader.getSystemResources(string);
            }
            catch (IOException iOException) {
                LogFactory.logDiagnostic(() -> "Exception while trying to find configuration file " + string + ":" + iOException.getMessage());
                return null;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                return null;
            }
        });
    }

    private static String getSystemProperty(String string, String string2) throws SecurityException {
        return AccessController.doPrivileged(() -> System.getProperty(string, string2));
    }

    protected static void handleThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    private static boolean implementsLogFactory(Class<?> clazz) {
        boolean bl2 = false;
        if (clazz != null) {
            try {
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) {
                    LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] was loaded by the boot class loader");
                } else {
                    LogFactory.logHierarchy("[CUSTOM LOG FACTORY] ", classLoader);
                    Class<?> clazz2 = Class.forName(FACTORY_PROPERTY, false, classLoader);
                    bl2 = clazz2.isAssignableFrom(clazz);
                    String string = clazz.getName();
                    if (bl2) {
                        LogFactory.logDiagnostic(() -> "[CUSTOM LOG FACTORY] " + string + " implements LogFactory but was loaded by an incompatible class loader.");
                    } else {
                        LogFactory.logDiagnostic(() -> "[CUSTOM LOG FACTORY] " + string + " does not implement LogFactory.");
                    }
                }
            }
            catch (SecurityException securityException) {
                LogFactory.logDiagnostic(() -> "[CUSTOM LOG FACTORY] SecurityException caught trying to determine whether the compatibility was caused by a class loader conflict: " + securityException.getMessage());
            }
            catch (LinkageError linkageError) {
                LogFactory.logDiagnostic(() -> "[CUSTOM LOG FACTORY] LinkageError caught trying to determine whether the compatibility was caused by a class loader conflict: " + linkageError.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogFactory.logDiagnostic(() -> "[CUSTOM LOG FACTORY] LogFactory class cannot be loaded by the class loader which loaded the custom LogFactory implementation. Is the custom factory in the right class loader?");
            }
        }
        return bl2;
    }

    private static PrintStream initDiagnostics() {
        String string;
        try {
            string = LogFactory.getSystemProperty(DIAGNOSTICS_DEST_PROPERTY, null);
            if (string == null) {
                return null;
            }
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (string.equals("STDOUT")) {
            return System.out;
        }
        if (string.equals("STDERR")) {
            return System.err;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            return new PrintStream((OutputStream)fileOutputStream, false, StandardCharsets.UTF_8.name());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean isClassAvailable(String string, ClassLoader classLoader) {
        LogFactory.logDiagnostic(() -> "Checking if class '" + string + "' is available in class loader " + LogFactory.objectId(classLoader));
        try {
            Class.forName(string, true, classLoader);
            return true;
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            LogFactory.logDiagnostic(() -> "Failed to load class '" + string + "' from class loader " + LogFactory.objectId(classLoader) + ": " + throwable.getMessage());
            return false;
        }
    }

    protected static boolean isDiagnosticsEnabled() {
        return DIAGNOSTICS_STREAM != null;
    }

    private static void logClassLoaderEnvironment(Class<?> clazz) {
        ClassLoader classLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        try {
            LogFactory.logDiagnostic("[ENV] Extension directories (java.ext.dir): " + System.getProperty("java.ext.dir"));
            LogFactory.logDiagnostic("[ENV] Application classpath (java.class.path): " + System.getProperty("java.class.path"));
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic("[ENV] Security setting prevent interrogation of system classpaths.");
        }
        String string = clazz.getName();
        try {
            classLoader = LogFactory.getClassLoader(clazz);
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic("[ENV] Security forbids determining the class loader for " + string);
            return;
        }
        LogFactory.logDiagnostic("[ENV] Class " + string + " was loaded via class loader " + LogFactory.objectId(classLoader));
        LogFactory.logHierarchy("[ENV] Ancestry of class loader which loaded " + string + " is ", classLoader);
    }

    private static void logDiagnostic(String string) {
        if (DIAGNOSTICS_STREAM != null) {
            LogFactory.logDiagnosticDirect(string);
        }
    }

    private static void logDiagnostic(Supplier<String> supplier) {
        if (DIAGNOSTICS_STREAM != null) {
            LogFactory.logDiagnosticDirect(supplier.get());
        }
    }

    private static void logDiagnosticDirect(String string) {
        DIAGNOSTICS_STREAM.print(DIAGNOSTICS_PREFIX);
        DIAGNOSTICS_STREAM.println(string);
        DIAGNOSTICS_STREAM.flush();
    }

    private static void logHierarchy(String string, ClassLoader classLoader) {
        ClassLoader classLoader2;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        if (classLoader != null) {
            LogFactory.logDiagnostic(string + LogFactory.objectId(classLoader) + " == '" + classLoader.toString() + "'");
        }
        try {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic(string + "Security forbids determining the system class loader.");
            return;
        }
        if (classLoader != null) {
            StringBuilder stringBuilder;
            block9: {
                stringBuilder = new StringBuilder(string + "ClassLoader tree:");
                do {
                    stringBuilder.append(LogFactory.objectId(classLoader));
                    if (classLoader == classLoader2) {
                        stringBuilder.append(" (SYSTEM) ");
                    }
                    try {
                        classLoader = classLoader.getParent();
                    }
                    catch (SecurityException securityException) {
                        stringBuilder.append(" --> SECRET");
                        break block9;
                    }
                    stringBuilder.append(" --> ");
                } while (classLoader != null);
                stringBuilder.append("BOOT");
            }
            LogFactory.logDiagnostic(stringBuilder.toString());
        }
    }

    protected static final void logRawDiagnostic(String string) {
        if (DIAGNOSTICS_STREAM != null) {
            DIAGNOSTICS_STREAM.println(string);
            DIAGNOSTICS_STREAM.flush();
        }
    }

    protected static LogFactory newFactory(String string, ClassLoader classLoader) {
        return LogFactory.newFactory(string, classLoader, null);
    }

    protected static LogFactory newFactory(String string, ClassLoader classLoader, ClassLoader classLoader2) throws LogConfigurationException {
        Object object = AccessController.doPrivileged(() -> LogFactory.createFactory(string, classLoader));
        if (object instanceof LogConfigurationException) {
            LogConfigurationException logConfigurationException = (LogConfigurationException)object;
            LogFactory.logDiagnostic(() -> "An error occurred while loading the factory class:" + logConfigurationException.getMessage());
            throw logConfigurationException;
        }
        LogFactory.logDiagnostic(() -> "Created object " + LogFactory.objectId(object) + " to manage class loader " + LogFactory.objectId(classLoader2));
        return (LogFactory)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogFactory newStandardFactory(ClassLoader classLoader) {
        if (LogFactory.isClassAvailable(LOG4J_TO_SLF4J_BRIDGE, classLoader)) {
            try {
                LogFactory logFactory = (LogFactory)Class.forName(FACTORY_SLF4J, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
                return logFactory;
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
            }
            finally {
                LogFactory.logDiagnostic(() -> "[LOOKUP] Log4j API to SLF4J redirection detected. Loading the SLF4J LogFactory implementation 'org.apache.commons.logging.impl.Slf4jLogFactory'.");
            }
        }
        try {
            LogFactory logFactory = (LogFactory)Class.forName(FACTORY_LOG4J_API, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            return logFactory;
        }
        catch (LinkageError | ReflectiveOperationException throwable) {
        }
        finally {
            LogFactory.logDiagnostic(() -> "[LOOKUP] Loading the Log4j API LogFactory implementation 'org.apache.commons.logging.impl.Log4jApiLogFactory'.");
        }
        try {
            LogFactory logFactory = (LogFactory)Class.forName(FACTORY_SLF4J, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            return logFactory;
        }
        catch (LinkageError | ReflectiveOperationException throwable) {
        }
        finally {
            LogFactory.logDiagnostic(() -> "[LOOKUP] Loading the SLF4J LogFactory implementation 'org.apache.commons.logging.impl.Slf4jLogFactory'.");
        }
        try {
            LogFactory logFactory = (LogFactory)Class.forName(FACTORY_DEFAULT, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            return logFactory;
        }
        catch (LinkageError | ReflectiveOperationException throwable) {
        }
        finally {
            LogFactory.logDiagnostic(() -> "[LOOKUP] Loading the legacy LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl'.");
        }
        return null;
    }

    public static String objectId(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + "@" + System.identityHashCode(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ClassLoader classLoader) {
        Hashtable<ClassLoader, LogFactory> hashtable;
        LogFactory.logDiagnostic(() -> "Releasing factory for class loader " + LogFactory.objectId(classLoader));
        Hashtable<ClassLoader, LogFactory> hashtable2 = hashtable = factories;
        synchronized (hashtable2) {
            if (classLoader == null) {
                if (nullClassLoaderFactory != null) {
                    nullClassLoaderFactory.release();
                    nullClassLoaderFactory = null;
                }
            } else {
                LogFactory logFactory = hashtable.get(classLoader);
                if (logFactory != null) {
                    logFactory.release();
                    hashtable.remove(classLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Hashtable<ClassLoader, LogFactory> hashtable;
        LogFactory.logDiagnostic("Releasing factory for all class loaders.");
        Hashtable<ClassLoader, LogFactory> hashtable2 = hashtable = factories;
        synchronized (hashtable2) {
            hashtable.values().forEach(LogFactory::release);
            hashtable.clear();
            if (nullClassLoaderFactory != null) {
                nullClassLoaderFactory.release();
                nullClassLoaderFactory = null;
            }
        }
    }

    private static String trim(String string) {
        return string != null ? string.trim() : null;
    }

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class<?> var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    private static /* synthetic */ String lambda$getFactory$11(String string) {
        return "[LOOKUP] Properties file specifies LogFactory subclass '" + string + "'";
    }

    private static /* synthetic */ String lambda$getFactory$4(String string) {
        return "[LOOKUP] Creating an instance of LogFactory class '" + string + "' as specified by system property " + FACTORY_PROPERTY;
    }

    static {
        String string;
        ClassLoader classLoader = LogFactory.getClassLoader(LogFactory.class);
        thisClassLoaderRef = new WeakReference<ClassLoader>(classLoader);
        try {
            string = classLoader != null ? LogFactory.objectId(classLoader) : "BOOTLOADER";
        }
        catch (SecurityException securityException) {
            string = "UNKNOWN";
        }
        DIAGNOSTICS_PREFIX = "[LogFactory from " + string + "] ";
        DIAGNOSTICS_STREAM = LogFactory.initDiagnostics();
        LogFactory.logClassLoaderEnvironment(LogFactory.class);
        factories = LogFactory.createFactoryStore();
        LogFactory.logDiagnostic("BOOTSTRAP COMPLETED");
    }
}

