/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.concurrent;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.Validate;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.concurrent.ConcurrentException;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.exception.ExceptionUtils;
import java.util.concurrent.ExecutionException;

public class ConcurrentUtils {
    static Throwable checkedException(Throwable throwable) {
        Validate.isTrue(ExceptionUtils.isChecked(throwable), "Not a checked exception: %s", throwable);
        return throwable;
    }

    public static ConcurrentException extractCause(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ExceptionUtils.throwUnchecked(executionException.getCause());
        return new ConcurrentException(executionException.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException executionException) throws ConcurrentException {
        ConcurrentException concurrentException = ConcurrentUtils.extractCause(executionException);
        if (concurrentException != null) {
            throw concurrentException;
        }
    }
}

