/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.input;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.ByteOrderMark;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class BOMInputStream
extends ProxyInputStream {
    private static final Comparator<ByteOrderMark> ByteOrderMarkLengthComparator = Comparator.comparing(ByteOrderMark::length).reversed();
    private final List<ByteOrderMark> bomList;
    private ByteOrderMark byteOrderMark;
    private int fbIndex;
    private int[] firstBytes;
    private final boolean include;
    private boolean markedAtStart;
    private int markFbIndex;

    @Deprecated
    public BOMInputStream(InputStream inputStream, boolean bl2, ByteOrderMark ... byteOrderMarkArray) {
        super(inputStream);
        if (IOUtils.length(byteOrderMarkArray) == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.include = bl2;
        List<ByteOrderMark> list = Arrays.asList(byteOrderMarkArray);
        list.sort(ByteOrderMarkLengthComparator);
        this.bomList = list;
    }

    private ByteOrderMark find() {
        return this.bomList.stream().filter(this::matches).findFirst().orElse(null);
    }

    public ByteOrderMark getBOM() throws IOException {
        if (this.firstBytes == null) {
            this.byteOrderMark = this.readBom();
        }
        return this.byteOrderMark;
    }

    public String getBOMCharsetName() throws IOException {
        this.getBOM();
        return this.byteOrderMark == null ? null : this.byteOrderMark.getCharsetName();
    }

    @Override
    public synchronized void mark(int n2) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(n2);
    }

    private boolean matches(ByteOrderMark byteOrderMark) {
        return byteOrderMark.matches(this.firstBytes);
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        int n2 = this.readFirstBytes();
        return n2 >= 0 ? n2 : this.in.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        IOUtils.checkFromIndexSize(byArray, n2, n3);
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        while (n3 > 0 && n5 >= 0) {
            n5 = this.readFirstBytes();
            if (n5 < 0) continue;
            byArray[n2++] = (byte)(n5 & 0xFF);
            --n3;
            ++n4;
        }
        int n6 = this.in.read(byArray, n2, n3);
        this.afterRead(n6);
        return n6 < 0 ? (n4 > 0 ? n4 : -1) : n4 + n6;
    }

    private ByteOrderMark readBom() throws IOException {
        int n2 = 0;
        int n3 = this.bomList.get(0).length();
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.in.read();
            this.afterRead(nArray[i2]);
            ++n2;
            if (nArray[i2] < 0) break;
        }
        this.firstBytes = Arrays.copyOf(nArray, n2);
        ByteOrderMark byteOrderMark = this.find();
        if (byteOrderMark != null && !this.include) {
            if (byteOrderMark.length() < this.firstBytes.length) {
                this.fbIndex = byteOrderMark.length();
            } else {
                this.firstBytes = new int[0];
            }
        }
        return byteOrderMark;
    }

    private int readFirstBytes() throws IOException {
        this.getBOM();
        return this.fbIndex < this.firstBytes.length ? this.firstBytes[this.fbIndex++] : -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    @Override
    public long skip(long l2) throws IOException {
        int n2 = 0;
        while (l2 > (long)n2 && this.readFirstBytes() >= 0) {
            ++n2;
        }
        return this.in.skip(l2 - (long)n2) + (long)n2;
    }
}

