/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FilenameUtils;
import java.util.Locale;
import java.util.Objects;

public final class FileSystem
extends Enum<FileSystem> {
    public static final /* enum */ FileSystem GENERIC = new FileSystem(4096, false, false, 1020, 0x100000, new int[]{0}, new String[0], false, false, '/', NameLengthStrategy.BYTES);
    public static final /* enum */ FileSystem LINUX = new FileSystem(8192, true, true, 255, 4096, new int[]{0, 47}, new String[0], false, false, '/', NameLengthStrategy.BYTES);
    public static final /* enum */ FileSystem MAC_OSX = new FileSystem(4096, true, true, 255, 1024, new int[]{0, 47, 58}, new String[0], false, false, '/', NameLengthStrategy.BYTES);
    public static final /* enum */ FileSystem WINDOWS = new FileSystem(4096, false, true, 255, Short.MAX_VALUE, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124}, new String[]{"AUX", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM\u00b2", "COM\u00b3", "COM\u00b9", "CON", "CONIN$", "CONOUT$", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "LPT\u00b2", "LPT\u00b3", "LPT\u00b9", "NUL", "PRN"}, true, true, '\\', NameLengthStrategy.UTF16_CODE_UNITS);
    private static final boolean IS_OS_LINUX;
    private static final boolean IS_OS_MAC;
    private static final boolean IS_OS_WINDOWS;
    private static final FileSystem CURRENT;
    private final int blockSize;
    private final boolean casePreserving;
    private final boolean caseSensitive;
    private final int[] illegalFileNameChars;
    private final int maxFileNameLength;
    private final int maxPathLength;
    private final String[] reservedFileNames;
    private final boolean reservedFileNamesExtensions;
    private final boolean supportsDriveLetter;
    private final char nameSeparator;
    private final char nameSeparatorOther;
    private final NameLengthStrategy nameLengthStrategy;
    private static final /* synthetic */ FileSystem[] $VALUES;

    public static FileSystem[] values() {
        return (FileSystem[])$VALUES.clone();
    }

    public static FileSystem valueOf(String string) {
        return Enum.valueOf(FileSystem.class, string);
    }

    private static FileSystem current() {
        if (IS_OS_LINUX) {
            return LINUX;
        }
        if (IS_OS_MAC) {
            return MAC_OSX;
        }
        if (IS_OS_WINDOWS) {
            return WINDOWS;
        }
        return GENERIC;
    }

    public static FileSystem getCurrent() {
        return CURRENT;
    }

    private static boolean getOsMatchesName(String string) {
        return FileSystem.isOsNameMatch(FileSystem.getSystemProperty("os.name"), string);
    }

    private static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a SecurityException reading the system property '" + string + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    private static boolean isOsNameMatch(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.toUpperCase(Locale.ROOT).startsWith(string2.toUpperCase(Locale.ROOT));
    }

    private FileSystem(int n3, boolean bl2, boolean bl3, int n4, int n5, int[] nArray, String[] stringArray, boolean bl4, boolean bl5, char c2, NameLengthStrategy nameLengthStrategy) {
        this.blockSize = n3;
        this.maxFileNameLength = n4;
        this.maxPathLength = n5;
        this.illegalFileNameChars = Objects.requireNonNull(nArray, "illegalFileNameChars");
        this.reservedFileNames = Objects.requireNonNull(stringArray, "reservedFileNames");
        this.reservedFileNamesExtensions = bl4;
        this.caseSensitive = bl2;
        this.casePreserving = bl3;
        this.supportsDriveLetter = bl5;
        this.nameSeparator = c2;
        this.nameSeparatorOther = FilenameUtils.flipSeparator(c2);
        this.nameLengthStrategy = nameLengthStrategy;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private static /* synthetic */ FileSystem[] $values() {
        return new FileSystem[]{GENERIC, LINUX, MAC_OSX, WINDOWS};
    }

    static {
        $VALUES = FileSystem.$values();
        IS_OS_LINUX = FileSystem.getOsMatchesName("Linux");
        IS_OS_MAC = FileSystem.getOsMatchesName("Mac");
        IS_OS_WINDOWS = FileSystem.getOsMatchesName("Windows");
        CURRENT = FileSystem.current();
    }

    static enum NameLengthStrategy {
        BYTES{}
        ,
        UTF16_CODE_UNITS{};

    }
}

