/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip;

import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.NioZipEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class ZipEncodingHelper {
    static final ZipEncoding ZIP_ENCODING_UTF_8 = ZipEncodingHelper.getZipEncoding(StandardCharsets.UTF_8);

    public static ZipEncoding getZipEncoding(Charset charset) {
        return new NioZipEncoding(Charsets.toCharset(charset));
    }

    public static ZipEncoding getZipEncoding(String string) {
        return new NioZipEncoding(ZipEncodingHelper.toSafeCharset(string));
    }

    static ByteBuffer growBufferBy(ByteBuffer byteBuffer, int n2) {
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity() + n2);
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    static boolean isUTF8(Charset charset) {
        return ZipEncodingHelper.isUTF8Alias(Charsets.toCharset(charset).name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isUTF8Alias(String string) {
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(string)) return true;
        if (!StandardCharsets.UTF_8.aliases().stream().anyMatch(string::equalsIgnoreCase)) return false;
        return true;
    }

    private static Charset toSafeCharset(String string) {
        try {
            return Charsets.toCharset(string);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return Charset.defaultCharset();
        }
    }
}

