/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar;

import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.ArchiveInputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveSparseEntry;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveSparseZeroInputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils.ArchiveUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.BoundedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TarArchiveInputStream
extends ArchiveInputStream<TarArchiveEntry> {
    private final byte[] smallBuf = new byte[256];
    private final byte[] recordBuffer;
    private final int blockSize;
    private boolean atEof;
    private long entrySize;
    private long entryOffset;
    private List<InputStream> sparseInputStreams;
    private int currentSparseInputStreamIndex;
    private TarArchiveEntry currEntry;
    private final ZipEncoding zipEncoding;
    private Map<String, String> globalPaxHeaders = new HashMap<String, String>();
    private final List<TarArchiveStructSparse> globalSparseHeaders = new ArrayList<TarArchiveStructSparse>();
    private final boolean lenient;

    public TarArchiveInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    public TarArchiveInputStream(InputStream inputStream, int n2, int n3) {
        this(inputStream, n2, n3, null);
    }

    public TarArchiveInputStream(InputStream inputStream, int n2, int n3, String string) {
        this(inputStream, n2, n3, string, false);
    }

    public TarArchiveInputStream(InputStream inputStream, int n2, int n3, String string, boolean bl2) {
        super(inputStream, string);
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.recordBuffer = new byte[n3];
        this.blockSize = n2;
        this.lenient = bl2;
    }

    public TarArchiveInputStream(InputStream inputStream, String string) {
        this(inputStream, 10240, 512, string);
    }

    private void applyPaxHeadersToCurrentEntry(Map<String, String> map, List<TarArchiveStructSparse> list) throws IOException {
        this.currEntry.updateEntryFromPaxHeaders(map);
        this.currEntry.setSparseHeaders(list);
    }

    @Override
    public int available() throws IOException {
        if (this.isDirectory()) {
            return 0;
        }
        long l2 = this.currEntry.getRealSize() - this.entryOffset;
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    private void buildSparseInputStreams() throws IOException {
        this.currentSparseInputStreamIndex = -1;
        this.sparseInputStreams = new ArrayList<InputStream>();
        List<TarArchiveStructSparse> list = this.currEntry.getOrderedSparseHeaders();
        TarArchiveSparseZeroInputStream tarArchiveSparseZeroInputStream = new TarArchiveSparseZeroInputStream();
        long l2 = 0L;
        for (TarArchiveStructSparse tarArchiveStructSparse : list) {
            long l3 = tarArchiveStructSparse.getOffset() - l2;
            if (l3 < 0L) {
                throw new IOException("Corrupted struct sparse detected");
            }
            if (l3 > 0L) {
                this.sparseInputStreams.add(((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(tarArchiveSparseZeroInputStream)).setMaxCount(tarArchiveStructSparse.getOffset() - l2)).get());
            }
            if (tarArchiveStructSparse.getNumbytes() > 0L) {
                this.sparseInputStreams.add(((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(this.in)).setMaxCount(tarArchiveStructSparse.getNumbytes())).get());
            }
            l2 = tarArchiveStructSparse.getOffset() + tarArchiveStructSparse.getNumbytes();
        }
        if (!this.sparseInputStreams.isEmpty()) {
            this.currentSparseInputStreamIndex = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sparseInputStreams != null) {
            for (InputStream inputStream : this.sparseInputStreams) {
                inputStream.close();
            }
        }
        this.in.close();
    }

    private void consumeRemainderOfLastBlock() throws IOException {
        long l2 = this.getBytesRead() % (long)this.blockSize;
        if (l2 > 0L) {
            this.count(IOUtils.skip(this.in, (long)this.blockSize - l2));
        }
    }

    private long getActuallySkipped(long l2, long l3, long l4) throws IOException {
        long l5 = l3;
        if (this.in instanceof FileInputStream) {
            l5 = Math.min(l3, l2);
        }
        if (l5 != l4) {
            throw new IOException("Truncated TAR archive");
        }
        return l5;
    }

    protected byte[] getLongNameData() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while ((n2 = this.read(this.smallBuf)) >= 0) {
            byteArrayOutputStream.write(this.smallBuf, 0, n2);
        }
        this.getNextEntry();
        if (this.currEntry == null) {
            return null;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (n2 = byArray.length; n2 > 0 && byArray[n2 - 1] == 0; --n2) {
        }
        if (n2 != byArray.length) {
            byArray = Arrays.copyOf(byArray, n2);
        }
        return byArray;
    }

    public TarArchiveEntry getNextEntry() throws IOException {
        return this.getNextTarEntry();
    }

    @Deprecated
    public TarArchiveEntry getNextTarEntry() throws IOException {
        byte[] byArray;
        byte[] byArray2;
        if (this.isAtEOF()) {
            return null;
        }
        if (this.currEntry != null) {
            IOUtils.skip(this, Long.MAX_VALUE);
            this.skipRecordPadding();
        }
        if ((byArray2 = this.getRecord()) == null) {
            this.currEntry = null;
            return null;
        }
        try {
            this.currEntry = new TarArchiveEntry(this.globalPaxHeaders, byArray2, this.zipEncoding, this.lenient);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Error detected parsing the header", illegalArgumentException);
        }
        this.entryOffset = 0L;
        this.entrySize = this.currEntry.getSize();
        if (this.currEntry.isGNULongLinkEntry()) {
            byArray = this.getLongNameData();
            if (byArray == null) {
                return null;
            }
            this.currEntry.setLinkName(this.zipEncoding.decode(byArray));
        }
        if (this.currEntry.isGNULongNameEntry()) {
            byArray = this.getLongNameData();
            if (byArray == null) {
                return null;
            }
            String string = this.zipEncoding.decode(byArray);
            this.currEntry.setName(string);
            if (this.currEntry.isDirectory() && !string.endsWith("/")) {
                this.currEntry.setName(string + "/");
            }
        }
        if (this.currEntry.isGlobalPaxHeader()) {
            this.readGlobalPaxHeaders();
        }
        try {
            if (this.currEntry.isPaxHeader()) {
                this.paxHeaders();
            } else if (!this.globalPaxHeaders.isEmpty()) {
                this.applyPaxHeadersToCurrentEntry(this.globalPaxHeaders, this.globalSparseHeaders);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error detected parsing the pax header", numberFormatException);
        }
        if (this.currEntry.isOldGNUSparse()) {
            this.readOldGNUSparse();
        }
        this.entrySize = this.currEntry.getSize();
        return this.currEntry;
    }

    private byte[] getRecord() throws IOException {
        byte[] byArray = this.readRecord();
        this.setAtEOF(this.isEOFRecord(byArray));
        if (this.isAtEOF() && byArray != null) {
            this.tryToConsumeSecondEOFRecord();
            this.consumeRemainderOfLastBlock();
            byArray = null;
        }
        return byArray;
    }

    public int getRecordSize() {
        return this.recordBuffer.length;
    }

    protected final boolean isAtEOF() {
        return this.atEof;
    }

    private boolean isDirectory() {
        return this.currEntry != null && this.currEntry.isDirectory();
    }

    protected boolean isEOFRecord(byte[] byArray) {
        return byArray == null || ArchiveUtils.isArrayZero(byArray, this.getRecordSize());
    }

    @Override
    public synchronized void mark(int n2) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void paxHeaders() throws IOException {
        List<TarArchiveStructSparse> list = new ArrayList<TarArchiveStructSparse>();
        Map<String, String> map = TarUtils.parsePaxHeaders(this, list, this.globalPaxHeaders, this.entrySize);
        if (map.containsKey("GNU.sparse.map")) {
            list = new ArrayList<TarArchiveStructSparse>(TarUtils.parseFromPAX01SparseHeaders(map.get("GNU.sparse.map")));
        }
        this.getNextEntry();
        if (this.currEntry == null) {
            throw new IOException("premature end of tar archive. Didn't find any entry after PAX header.");
        }
        this.applyPaxHeadersToCurrentEntry(map, list);
        if (this.currEntry.isPaxGNU1XSparse()) {
            list = TarUtils.parsePAX1XSparseHeaders(this.in, this.getRecordSize());
            this.currEntry.setSparseHeaders(list);
        }
        this.buildSparseInputStreams();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        if (this.isAtEOF() || this.isDirectory()) {
            return -1;
        }
        if (this.currEntry == null) {
            throw new IllegalStateException("No current tar entry");
        }
        if (this.entryOffset >= this.currEntry.getRealSize()) {
            return -1;
        }
        n3 = Math.min(n3, this.available());
        n4 = this.currEntry.isSparse() ? this.readSparse(byArray, n2, n3) : this.in.read(byArray, n2, n3);
        if (n4 == -1) {
            if (n3 > 0) {
                throw new IOException("Truncated TAR archive");
            }
            this.setAtEOF(true);
        } else {
            this.count(n4);
            this.entryOffset += (long)n4;
        }
        return n4;
    }

    private void readGlobalPaxHeaders() throws IOException {
        this.globalPaxHeaders = TarUtils.parsePaxHeaders(this, this.globalSparseHeaders, this.globalPaxHeaders, this.entrySize);
        this.getNextEntry();
        if (this.currEntry == null) {
            throw new IOException("Error detected parsing the pax header");
        }
    }

    private void readOldGNUSparse() throws IOException {
        if (this.currEntry.isExtended()) {
            TarArchiveSparseEntry tarArchiveSparseEntry;
            do {
                byte[] byArray;
                if ((byArray = this.getRecord()) == null) {
                    throw new IOException("premature end of tar archive. Didn't find extended_header after header with extended flag.");
                }
                tarArchiveSparseEntry = new TarArchiveSparseEntry(byArray);
                this.currEntry.getSparseHeaders().addAll(tarArchiveSparseEntry.getSparseHeaders());
            } while (tarArchiveSparseEntry.isExtended());
        }
        this.buildSparseInputStreams();
    }

    protected byte[] readRecord() throws IOException {
        int n2 = IOUtils.readFully(this.in, this.recordBuffer);
        this.count(n2);
        if (n2 != this.getRecordSize()) {
            return null;
        }
        return this.recordBuffer;
    }

    private int readSparse(byte[] byArray, int n2, int n3) throws IOException {
        if (this.sparseInputStreams == null || this.sparseInputStreams.isEmpty()) {
            return this.in.read(byArray, n2, n3);
        }
        if (this.currentSparseInputStreamIndex >= this.sparseInputStreams.size()) {
            return -1;
        }
        InputStream inputStream = this.sparseInputStreams.get(this.currentSparseInputStreamIndex);
        int n4 = inputStream.read(byArray, n2, n3);
        if (this.currentSparseInputStreamIndex == this.sparseInputStreams.size() - 1) {
            return n4;
        }
        if (n4 == -1) {
            ++this.currentSparseInputStreamIndex;
            return this.readSparse(byArray, n2, n3);
        }
        if (n4 < n3) {
            ++this.currentSparseInputStreamIndex;
            int n5 = this.readSparse(byArray, n2 + n4, n3 - n4);
            if (n5 == -1) {
                return n4;
            }
            return n4 + n5;
        }
        return n4;
    }

    @Override
    public synchronized void reset() {
    }

    protected final void setAtEOF(boolean bl2) {
        this.atEof = bl2;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        if (l2 <= 0L || this.isDirectory()) {
            return 0L;
        }
        long l4 = this.in.available();
        long l5 = this.currEntry.getRealSize() - this.entryOffset;
        long l6 = Math.min(l2, l5);
        if (!this.currEntry.isSparse()) {
            l3 = IOUtils.skip(this.in, l6);
            l3 = this.getActuallySkipped(l4, l3, l6);
        } else {
            l3 = this.skipSparse(l6);
        }
        this.count(l3);
        this.entryOffset += l3;
        return l3;
    }

    private void skipRecordPadding() throws IOException {
        if (!this.isDirectory() && this.entrySize > 0L && this.entrySize % (long)this.getRecordSize() != 0L) {
            long l2 = this.in.available();
            long l3 = this.entrySize / (long)this.getRecordSize() + 1L;
            long l4 = l3 * (long)this.getRecordSize() - this.entrySize;
            long l5 = IOUtils.skip(this.in, l4);
            l5 = this.getActuallySkipped(l2, l5, l4);
            this.count(l5);
        }
    }

    private long skipSparse(long l2) throws IOException {
        if (this.sparseInputStreams == null || this.sparseInputStreams.isEmpty()) {
            return this.in.skip(l2);
        }
        long l3 = 0L;
        while (l3 < l2 && this.currentSparseInputStreamIndex < this.sparseInputStreams.size()) {
            InputStream inputStream = this.sparseInputStreams.get(this.currentSparseInputStreamIndex);
            if ((l3 += inputStream.skip(l2 - l3)) >= l2) continue;
            ++this.currentSparseInputStreamIndex;
        }
        return l3;
    }

    private void tryToConsumeSecondEOFRecord() throws IOException {
        boolean bl2 = true;
        boolean bl3 = this.in.markSupported();
        if (bl3) {
            this.in.mark(this.getRecordSize());
        }
        try {
            bl2 = !this.isEOFRecord(this.readRecord());
        }
        finally {
            if (bl2 && bl3) {
                this.pushedBackBytes(this.getRecordSize());
                this.in.reset();
            }
        }
    }
}

