/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary;

import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.BaseNCodec;
import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.BinaryCodec;
import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.StringUtils;
import java.util.Arrays;

public class Base64
extends BaseNCodec {
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private final byte[] lineSeparator;
    private final int encodeSize;
    private final boolean isUrlSafe;
    private final boolean isStandardEncodeTable;

    public static Builder builder() {
        return new Builder();
    }

    public static byte[] decodeBase64(byte[] byArray) {
        return new Base64().decode(byArray);
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2) {
        return Base64.encodeBase64(byArray, bl2, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2, boolean bl3) {
        return Base64.encodeBase64(byArray, bl2, bl3, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl2, boolean bl3, int n2) {
        if (BinaryCodec.isEmpty(byArray)) {
            return byArray;
        }
        Base64 base64 = bl2 ? new Base64(bl3) : new Base64(0, CHUNK_SEPARATOR, bl3);
        long l2 = base64.getEncodedLength(byArray);
        if (l2 > (long)n2) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l2 + ") than the specified maximum size of " + n2);
        }
        return base64.encode(byArray);
    }

    static byte[] toUrlSafeEncodeTable(boolean bl2) {
        return bl2 ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    public Base64() {
        this(0);
    }

    @Deprecated
    public Base64(boolean bl2) {
        this(76, CHUNK_SEPARATOR, bl2);
    }

    private Base64(Builder builder) {
        super(builder);
        byte[] byArray = builder.getEncodeTable();
        if (byArray.length != STANDARD_ENCODE_TABLE.length) {
            throw new IllegalArgumentException("encodeTable must have exactly 64 entries.");
        }
        this.isStandardEncodeTable = Arrays.equals(byArray, STANDARD_ENCODE_TABLE);
        this.isUrlSafe = Arrays.equals(byArray, URL_SAFE_ENCODE_TABLE);
        if (builder.getLineSeparator().length > 0) {
            byte[] byArray2 = builder.getLineSeparator();
            if (this.containsAlphabetOrPad(byArray2)) {
                String string = StringUtils.newStringUtf8(byArray2);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + string + "]");
            }
            if (builder.getLineLength() > 0) {
                this.encodeSize = 4 + byArray2.length;
                this.lineSeparator = byArray2;
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
    }

    @Deprecated
    public Base64(int n2) {
        this(n2, CHUNK_SEPARATOR);
    }

    @Deprecated
    public Base64(int n2, byte[] byArray) {
        this(n2, byArray, false);
    }

    @Deprecated
    public Base64(int n2, byte[] byArray, boolean bl2) {
        this((Builder)((Builder)((Builder)((Builder)((Builder)Base64.builder().setLineLength(n2)).setLineSeparator(byArray != null ? byArray : EMPTY_BYTE_ARRAY)).setPadding((byte)61)).setEncodeTableRaw(Base64.toUrlSafeEncodeTable(bl2))).setDecodingPolicy(DECODING_POLICY_DEFAULT));
    }

    @Override
    void decode(byte[] byArray, int n2, int n3, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n3 < 0) {
            context.eof = true;
        }
        int n4 = this.encodeSize - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by2;
            byte by3;
            byte[] byArray2 = this.ensureBufferSize(n4, context);
            if ((by3 = byArray[n2++]) == this.pad) {
                context.eof = true;
                break;
            }
            if (by3 < 0 || by3 >= this.decodeTable.length || (by2 = this.decodeTable[by3]) < 0) continue;
            context.modulus = (context.modulus + 1) % 4;
            context.ibitWorkArea = (context.ibitWorkArea << 6) + by2;
            if (context.modulus != 0) continue;
            byArray2[context.pos++] = (byte)(context.ibitWorkArea >> 16 & 0xFF);
            byArray2[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
            byArray2[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
        }
        if (context.eof && context.modulus != 0) {
            byte[] byArray3 = this.ensureBufferSize(n4, context);
            switch (context.modulus) {
                case 1: {
                    this.validateTrailingCharacter();
                    break;
                }
                case 2: {
                    this.validateCharacter(15, context);
                    context.ibitWorkArea >>= 4;
                    byArray3[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                    break;
                }
                case 3: {
                    this.validateCharacter(3, context);
                    context.ibitWorkArea >>= 2;
                    byArray3[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
                    byArray3[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
        }
    }

    @Override
    void encode(byte[] byArray, int n2, int n3, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n3 < 0) {
            context.eof = true;
            if (0 == context.modulus && this.lineLength == 0) {
                return;
            }
            byte[] byArray2 = this.ensureBufferSize(this.encodeSize, context);
            int n4 = context.pos;
            switch (context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea >> 2 & 0x3F];
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea << 4 & 0x3F];
                    if (!this.isStandardEncodeTable) break;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea >> 10 & 0x3F];
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea >> 4 & 0x3F];
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea << 2 & 0x3F];
                    if (!this.isStandardEncodeTable) break;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
            context.currentLinePos += context.pos - n4;
            if (this.lineLength > 0 && context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, byArray2, context.pos, this.lineSeparator.length);
                context.pos += this.lineSeparator.length;
            }
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5;
                byte[] byArray3 = this.ensureBufferSize(this.encodeSize, context);
                context.modulus = (context.modulus + 1) % 3;
                if ((n5 = byArray[n2++]) < 0) {
                    n5 += 256;
                }
                context.ibitWorkArea = (context.ibitWorkArea << 8) + n5;
                if (0 != context.modulus) continue;
                byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea >> 18 & 0x3F];
                byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea >> 12 & 0x3F];
                byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea >> 6 & 0x3F];
                byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea & 0x3F];
                context.currentLinePos += 4;
                if (this.lineLength <= 0 || this.lineLength > context.currentLinePos) continue;
                System.arraycopy(this.lineSeparator, 0, byArray3, context.pos, this.lineSeparator.length);
                context.pos += this.lineSeparator.length;
                context.currentLinePos = 0;
            }
        }
    }

    @Override
    protected boolean isInAlphabet(byte by2) {
        return by2 >= 0 && by2 < this.decodeTable.length && this.decodeTable[by2] != -1;
    }

    private void validateCharacter(int n2, BaseNCodec.Context context) {
        if (this.isStrictDecoding() && (context.ibitWorkArea & n2) != 0) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Expected the discarded bits from the character to be zero.");
        }
    }

    private void validateTrailingCharacter() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Decoding requires at least two trailing 6-bit characters to create bytes.");
        }
    }

    public static class Builder
    extends BaseNCodec.AbstractBuilder<Base64, Builder> {
        public Builder() {
            super(STANDARD_ENCODE_TABLE);
            this.setDecodeTableRaw(DECODE_TABLE);
            this.setEncodeTableRaw(STANDARD_ENCODE_TABLE);
            this.setEncodedBlockSize(4);
            this.setUnencodedBlockSize(3);
        }

        @Override
        public Base64 get() {
            return new Base64(this);
        }
    }
}

