/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class ShortComparators {
    public static final ShortComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final ShortComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static ShortComparator oppositeComparator(ShortComparator shortComparator) {
        if (shortComparator instanceof OppositeComparator) {
            return ((OppositeComparator)shortComparator).comparator;
        }
        return new OppositeComparator(shortComparator);
    }

    public static ShortComparator asShortComparator(final Comparator<? super Short> comparator) {
        if (comparator == null || comparator instanceof ShortComparator) {
            return (ShortComparator)comparator;
        }
        return new ShortComparator(){

            @Override
            public int compare(short s2, short s3) {
                return comparator.compare(s2, s3);
            }

            @Override
            public int compare(Short s2, Short s3) {
                return comparator.compare(s2, s3);
            }
        };
    }

    protected static class OppositeComparator
    implements ShortComparator,
    Serializable {
        final ShortComparator comparator;

        protected OppositeComparator(ShortComparator shortComparator) {
            this.comparator = shortComparator;
        }

        @Override
        public final int compare(short s2, short s3) {
            return this.comparator.compare(s3, s2);
        }

        @Override
        public final ShortComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements ShortComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(short s2, short s3) {
            return Short.compare(s2, s3);
        }

        @Override
        public ShortComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements ShortComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(short s2, short s3) {
            return -Short.compare(s2, s3);
        }

        @Override
        public ShortComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

