/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.AbstractLongSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public final class LongSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static LongSpliterator wrap(long[] lArray, int n2, int n3, int n4) {
        LongArrays.ensureOffsetLength(lArray, n2, n3);
        return new ArraySpliterator(lArray, n2, n3, n4);
    }

    public static LongSpliterator wrapPreSorted(long[] lArray, int n2, int n3, int n4, LongComparator longComparator) {
        LongArrays.ensureOffsetLength(lArray, n2, n3);
        return new ArraySpliteratorWithComparator(lArray, n2, n3, n4, longComparator);
    }

    public static LongSpliterator asSpliterator(LongIterator longIterator, long l2, int n2) {
        return new SpliteratorFromIterator(longIterator, l2, n2);
    }

    public static LongSpliterator asSpliteratorFromSorted(LongIterator longIterator, long l2, int n2, LongComparator longComparator) {
        return new SpliteratorFromIteratorWithComparator(longIterator, l2, n2, longComparator);
    }

    public static LongSpliterator asSpliteratorUnknownSize(LongIterator longIterator, int n2) {
        return new SpliteratorFromIterator(longIterator, n2);
    }

    private static class ArraySpliterator
    implements LongSpliterator {
        final long[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(long[] lArray, int n2, int n3, int n4) {
            this.array = lArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(longConsumer);
            longConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public LongSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            Objects.requireNonNull(longConsumer);
            long[] lArray = this.array;
            while (this.curr < this.length) {
                longConsumer.accept(lArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator
    extends ArraySpliterator {
        private final LongComparator comparator;

        public ArraySpliteratorWithComparator(long[] lArray, int n2, int n3, int n4, LongComparator longComparator) {
            super(lArray, n2, n3, n4 | 0x14);
            this.comparator = longComparator;
        }

        @Override
        protected ArraySpliteratorWithComparator makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public LongComparator getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator
    implements LongSpliterator {
        private final LongIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private LongSpliterator delegate = null;

        SpliteratorFromIterator(LongIterator longIterator, int n2) {
            this.iter = longIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(LongIterator longIterator, long l2, int n2) {
            this.iter = longIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(longConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            longConsumer.accept(this.iter.nextLong());
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(longConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(longConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected LongSpliterator makeForSplit(long[] lArray, int n2) {
            return LongSpliterators.wrap(lArray, 0, n2, this.characteristics);
        }

        @Override
        public LongSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            long[] lArray = new long[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                lArray[n3++] = this.iter.nextLong();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                lArray = Arrays.copyOf(lArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    lArray[n3++] = this.iter.nextLong();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            LongSpliterator longSpliterator = this.makeForSplit(lArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = longSpliterator;
                return longSpliterator.trySplit();
            }
            return longSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator
    extends SpliteratorFromIterator {
        private final LongComparator comparator;

        SpliteratorFromIteratorWithComparator(LongIterator longIterator, long l2, int n2, LongComparator longComparator) {
            super(longIterator, l2, n2 | 0x14);
            this.comparator = longComparator;
        }

        @Override
        public LongComparator getComparator() {
            return this.comparator;
        }

        @Override
        protected LongSpliterator makeForSplit(long[] lArray, int n2) {
            return LongSpliterators.wrapPreSorted(lArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static class EmptySpliterator
    implements LongSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Long> consumer) {
            return false;
        }

        @Override
        public LongSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Long> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public LongSpliterator trySplit() {
            LongSpliterator longSpliterator = super.trySplit();
            if (!this.maxPosFixed && longSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return longSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractLongSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract long get(int var1);

        protected abstract int getMaxPos();

        protected abstract LongSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            longConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                longConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public LongSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            LongSpliterator longSpliterator = this.makeForSplit(n4, n3);
            if (longSpliterator != null) {
                this.pos = n3;
            }
            return longSpliterator;
        }
    }
}

