/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.HashCommon;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.LongConsumer;

public abstract class AbstractLongList
extends AbstractLongCollection
implements LongList {
    protected AbstractLongList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(long l2) {
        this.add(this.size(), l2);
        return true;
    }

    @Override
    public long removeLong(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long set(int n2, long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Long> collection) {
        if (collection instanceof LongCollection) {
            return this.addAll(n2, (LongCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Long> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, (long)iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public LongListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public LongListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new LongIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final long get(int n2) {
                return AbstractLongList.this.getLong(n2);
            }

            @Override
            protected final void add(int n2, long l2) {
                AbstractLongList.this.add(n2, l2);
            }

            @Override
            protected final void set(int n2, long l2) {
                AbstractLongList.this.set(n2, l2);
            }

            @Override
            protected final void remove(int n2) {
                AbstractLongList.this.removeLong(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractLongList.this.size();
            }
        };
    }

    @Override
    public boolean contains(long l2) {
        return this.indexOf(l2) >= 0;
    }

    @Override
    public int indexOf(long l2) {
        LongListIterator longListIterator = this.listIterator();
        while (longListIterator.hasNext()) {
            long l3 = longListIterator.nextLong();
            if (l2 != l3) continue;
            return longListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long l2) {
        LongListIterator longListIterator = this.listIterator(this.size());
        while (longListIterator.hasPrevious()) {
            long l3 = longListIterator.previousLong();
            if (l2 != l3) continue;
            return longListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public LongList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new LongRandomAccessSubList(this, n2, n3) : new LongSubList(this, n2, n3);
    }

    @Override
    public void forEach(LongConsumer longConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                longConsumer.accept(this.getLong(i2));
            }
        } else {
            LongList.super.forEach(longConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        LongListIterator longListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            longListIterator.nextLong();
            longListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, long[] lArray, int n3, int n4) {
        this.ensureIndex(n2);
        LongArrays.ensureOffsetLength(lArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                lArray[n3++] = this.getLong(n5++);
            }
        } else {
            LongListIterator longListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                lArray[n3++] = longListIterator.nextLong();
            }
        }
    }

    @Override
    public void setElements(int n2, long[] lArray, int n3, int n4) {
        this.ensureIndex(n2);
        LongArrays.ensureOffsetLength(lArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, lArray[i2 + n3]);
            }
        } else {
            LongListIterator longListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                longListIterator.nextLong();
                longListIterator.set(lArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        LongListIterator longListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            long l2 = longListIterator.nextLong();
            n2 = 31 * n2 + HashCommon.long2int(l2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof LongList) {
            LongListIterator longListIterator = this.listIterator();
            LongListIterator longListIterator2 = ((LongList)list).listIterator();
            while (n2-- != 0) {
                if (longListIterator.nextLong() == longListIterator2.nextLong()) continue;
                return false;
            }
            return true;
        }
        LongListIterator longListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(longListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Long> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof LongList) {
            LongListIterator longListIterator = this.listIterator();
            LongListIterator longListIterator2 = ((LongList)list).listIterator();
            while (longListIterator.hasNext() && longListIterator2.hasNext()) {
                long l2;
                long l3 = longListIterator.nextLong();
                int n2 = Long.compare(l3, l2 = longListIterator2.nextLong());
                if (n2 == 0) continue;
                return n2;
            }
            return longListIterator2.hasNext() ? -1 : (longListIterator.hasNext() ? 1 : 0);
        }
        LongListIterator longListIterator = this.listIterator();
        ListIterator<? extends Long> listIterator = list.listIterator();
        while (longListIterator.hasNext() && listIterator.hasNext()) {
            int n3 = ((Comparable)longListIterator.next()).compareTo(listIterator.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator.hasNext() ? -1 : (longListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(long l2) {
        int n2 = this.indexOf(l2);
        if (n2 == -1) {
            return false;
        }
        this.removeLong(n2);
        return true;
    }

    @Override
    public long[] toLongArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return LongArrays.EMPTY_ARRAY;
        }
        long[] lArray = new long[n2];
        this.getElements(0, lArray, 0, n2);
        return lArray;
    }

    public boolean addAll(int n2, LongCollection longCollection) {
        this.ensureIndex(n2);
        LongIterator longIterator = longCollection.iterator();
        boolean bl2 = longIterator.hasNext();
        while (longIterator.hasNext()) {
            this.add(n2++, longIterator.nextLong());
        }
        return bl2;
    }

    @Override
    public boolean addAll(LongCollection longCollection) {
        return this.addAll(this.size(), longCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        LongListIterator longListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            long l2 = longListIterator.nextLong();
            stringBuilder.append(String.valueOf(l2));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class LongRandomAccessSubList
    extends LongSubList
    implements RandomAccess {
        public LongRandomAccessSubList(LongList longList, int n2, int n3) {
            super(longList, n2, n3);
        }

        @Override
        public LongList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new LongRandomAccessSubList(this, n2, n3);
        }
    }

    public static class LongSubList
    extends AbstractLongList
    implements Serializable {
        protected final LongList l;
        protected final int from;
        protected int to;

        public LongSubList(LongList longList, int n2, int n3) {
            this.l = longList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(long l2) {
            this.l.add(this.to, l2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, long l2) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, l2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Long> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public long getLong(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getLong(this.from + n2);
        }

        @Override
        public long removeLong(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeLong(this.from + n2);
        }

        @Override
        public long set(int n2, long l2) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, l2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, long[] lArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, lArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, long[] lArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, lArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public LongListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public LongSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public LongList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new LongSubList(this, n2, n3);
        }

        @Override
        public boolean rem(long l2) {
            int n2 = this.indexOf(l2);
            if (n2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeLong(this.from + n2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, LongCollection longCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, longCollection);
        }

        private final class RandomAccessIter
        extends LongIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final long get(int n2) {
                return LongSubList.this.l.getLong(LongSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, long l2) {
                LongSubList.this.add(n2, l2);
            }

            @Override
            protected final void set(int n2, long l2) {
                LongSubList.this.set(n2, l2);
            }

            @Override
            protected final void remove(int n2) {
                LongSubList.this.removeLong(n2);
            }

            @Override
            protected final int getMaxPos() {
                return LongSubList.this.to - LongSubList.this.from;
            }

            @Override
            public void add(long l2) {
                super.add(l2);
                assert (LongSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (LongSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements LongListIterator {
            private LongListIterator parent;

            ParentWrappingIter(LongListIterator longListIterator) {
                this.parent = longListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - LongSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - LongSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < LongSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= LongSubList.this.from;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextLong();
            }

            @Override
            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousLong();
            }

            @Override
            public void add(long l2) {
                this.parent.add(l2);
            }

            @Override
            public void set(long l2) {
                this.parent.set(l2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends LongSpliterators.LateBindingSizeIndexBasedSpliterator {
        final LongList l;

        IndexBasedSpliterator(LongList longList, int n2) {
            super(n2);
            this.l = longList;
        }

        IndexBasedSpliterator(LongList longList, int n2, int n3) {
            super(n2, n3);
            this.l = longList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final long get(int n2) {
            return this.l.getLong(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

