/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.AbstractIntSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public final class IntSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static IntSpliterator wrap(int[] nArray, int n2, int n3, int n4) {
        IntArrays.ensureOffsetLength(nArray, n2, n3);
        return new ArraySpliterator(nArray, n2, n3, n4);
    }

    public static IntSpliterator wrapPreSorted(int[] nArray, int n2, int n3, int n4, IntComparator intComparator) {
        IntArrays.ensureOffsetLength(nArray, n2, n3);
        return new ArraySpliteratorWithComparator(nArray, n2, n3, n4, intComparator);
    }

    public static IntSpliterator asSpliterator(IntIterator intIterator, long l2, int n2) {
        return new SpliteratorFromIterator(intIterator, l2, n2);
    }

    public static IntSpliterator asSpliteratorFromSorted(IntIterator intIterator, long l2, int n2, IntComparator intComparator) {
        return new SpliteratorFromIteratorWithComparator(intIterator, l2, n2, intComparator);
    }

    public static IntSpliterator asSpliteratorUnknownSize(IntIterator intIterator, int n2) {
        return new SpliteratorFromIterator(intIterator, n2);
    }

    private static class ArraySpliterator
    implements IntSpliterator {
        final int[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(int[] nArray, int n2, int n3, int n4) {
            this.array = nArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(intConsumer);
            intConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public IntSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            Objects.requireNonNull(intConsumer);
            int[] nArray = this.array;
            while (this.curr < this.length) {
                intConsumer.accept(nArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator
    extends ArraySpliterator {
        private final IntComparator comparator;

        public ArraySpliteratorWithComparator(int[] nArray, int n2, int n3, int n4, IntComparator intComparator) {
            super(nArray, n2, n3, n4 | 0x14);
            this.comparator = intComparator;
        }

        @Override
        protected ArraySpliteratorWithComparator makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public IntComparator getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator
    implements IntSpliterator {
        private final IntIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private IntSpliterator delegate = null;

        SpliteratorFromIterator(IntIterator intIterator, int n2) {
            this.iter = intIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(IntIterator intIterator, long l2, int n2) {
            this.iter = intIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(intConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            intConsumer.accept(this.iter.nextInt());
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(intConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(intConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected IntSpliterator makeForSplit(int[] nArray, int n2) {
            return IntSpliterators.wrap(nArray, 0, n2, this.characteristics);
        }

        @Override
        public IntSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                nArray[n3++] = this.iter.nextInt();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                nArray = Arrays.copyOf(nArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    nArray[n3++] = this.iter.nextInt();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            IntSpliterator intSpliterator = this.makeForSplit(nArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = intSpliterator;
                return intSpliterator.trySplit();
            }
            return intSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator
    extends SpliteratorFromIterator {
        private final IntComparator comparator;

        SpliteratorFromIteratorWithComparator(IntIterator intIterator, long l2, int n2, IntComparator intComparator) {
            super(intIterator, l2, n2 | 0x14);
            this.comparator = intComparator;
        }

        @Override
        public IntComparator getComparator() {
            return this.comparator;
        }

        @Override
        protected IntSpliterator makeForSplit(int[] nArray, int n2) {
            return IntSpliterators.wrapPreSorted(nArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static class EmptySpliterator
    implements IntSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Integer> consumer) {
            return false;
        }

        @Override
        public IntSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Integer> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public IntSpliterator trySplit() {
            IntSpliterator intSpliterator = super.trySplit();
            if (!this.maxPosFixed && intSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return intSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractIntSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract int get(int var1);

        protected abstract int getMaxPos();

        protected abstract IntSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            intConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                intConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public IntSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            IntSpliterator intSpliterator = this.makeForSplit(n4, n3);
            if (intSpliterator != null) {
                this.pos = n3;
            }
            return intSpliterator;
        }
    }
}

