/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public final class IntIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public static int unwrap(IntIterator intIterator, int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + n3 + ") is negative");
        }
        if (n2 < 0 || n2 + n3 > nArray.length) {
            throw new IllegalArgumentException();
        }
        int n4 = n3;
        while (n4-- != 0 && intIterator.hasNext()) {
            nArray[n2++] = intIterator.nextInt();
        }
        return n3 - n4 - 1;
    }

    public static int unwrap(IntIterator intIterator, int[] nArray) {
        return IntIterators.unwrap(intIterator, nArray, 0, nArray.length);
    }

    public static class EmptyIterator
    implements IntListIterator,
    Serializable,
    Cloneable {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public int previousInt() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Integer> consumer) {
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }
    }

    public static abstract class AbstractIndexBasedListIterator
    extends AbstractIndexBasedIterator
    implements IntListIterator {
        protected AbstractIndexBasedListIterator(int n2, int n3) {
            super(n2, n3);
        }

        protected abstract void add(int var1, int var2);

        protected abstract void set(int var1, int var2);

        @Override
        public boolean hasPrevious() {
            return this.pos > this.minPos;
        }

        @Override
        public int previousInt() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = --this.pos;
            return this.get(this.pos);
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void add(int n2) {
            this.add(this.pos++, n2);
            this.lastReturned = -1;
        }

        @Override
        public void set(int n2) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.set(this.lastReturned, n2);
        }
    }

    public static abstract class AbstractIndexBasedIterator
    extends AbstractIntIterator {
        protected final int minPos;
        protected int pos;
        protected int lastReturned;

        protected AbstractIndexBasedIterator(int n2, int n3) {
            this.minPos = n2;
            this.pos = n3;
        }

        protected abstract int get(int var1);

        protected abstract void remove(int var1);

        protected abstract int getMaxPos();

        @Override
        public boolean hasNext() {
            return this.pos < this.getMaxPos();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.pos++;
            return this.get(this.lastReturned);
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.remove(this.lastReturned);
            if (this.lastReturned < this.pos) {
                --this.pos;
            }
            this.lastReturned = -1;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            while (this.pos < this.getMaxPos()) {
                ++this.pos;
                this.lastReturned = this.lastReturned;
                intConsumer.accept(this.get(this.lastReturned));
            }
        }
    }
}

