/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.SafeMath;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Size64;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatIterable;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatPredicate;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface FloatCollection
extends FloatIterable,
Collection<Float> {
    @Override
    public FloatIterator iterator();

    @Override
    default public FloatSpliterator spliterator() {
        return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(float var1);

    public boolean contains(float var1);

    public boolean rem(float var1);

    @Override
    @Deprecated
    default public boolean add(Float f2) {
        return this.add(f2.floatValue());
    }

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        return this.contains(((Float)object).floatValue());
    }

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        return this.rem(((Float)object).floatValue());
    }

    public float[] toFloatArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Float> predicate) {
        return this.removeIf(predicate instanceof FloatPredicate ? (FloatPredicate)predicate : f2 -> predicate.test(Float.valueOf(SafeMath.safeDoubleToFloat(f2))));
    }

    default public boolean removeIf(FloatPredicate floatPredicate) {
        Objects.requireNonNull(floatPredicate);
        boolean bl2 = false;
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (!floatPredicate.test(floatIterator.nextFloat())) continue;
            floatIterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    @Deprecated
    default public Stream<Float> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Float> parallelStream() {
        return Collection.super.parallelStream();
    }
}

