/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.AbstractDoubleSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;

public final class DoubleSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static DoubleSpliterator wrap(double[] dArray, int n2, int n3, int n4) {
        DoubleArrays.ensureOffsetLength(dArray, n2, n3);
        return new ArraySpliterator(dArray, n2, n3, n4);
    }

    public static DoubleSpliterator wrapPreSorted(double[] dArray, int n2, int n3, int n4, DoubleComparator doubleComparator) {
        DoubleArrays.ensureOffsetLength(dArray, n2, n3);
        return new ArraySpliteratorWithComparator(dArray, n2, n3, n4, doubleComparator);
    }

    public static DoubleSpliterator asSpliterator(DoubleIterator doubleIterator, long l2, int n2) {
        return new SpliteratorFromIterator(doubleIterator, l2, n2);
    }

    public static DoubleSpliterator asSpliteratorFromSorted(DoubleIterator doubleIterator, long l2, int n2, DoubleComparator doubleComparator) {
        return new SpliteratorFromIteratorWithComparator(doubleIterator, l2, n2, doubleComparator);
    }

    public static DoubleSpliterator asSpliteratorUnknownSize(DoubleIterator doubleIterator, int n2) {
        return new SpliteratorFromIterator(doubleIterator, n2);
    }

    private static class ArraySpliterator
    implements DoubleSpliterator {
        final double[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(double[] dArray, int n2, int n3, int n4) {
            this.array = dArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(doubleConsumer);
            doubleConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public DoubleSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            Objects.requireNonNull(doubleConsumer);
            double[] dArray = this.array;
            while (this.curr < this.length) {
                doubleConsumer.accept(dArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator
    extends ArraySpliterator {
        private final DoubleComparator comparator;

        public ArraySpliteratorWithComparator(double[] dArray, int n2, int n3, int n4, DoubleComparator doubleComparator) {
            super(dArray, n2, n3, n4 | 0x14);
            this.comparator = doubleComparator;
        }

        @Override
        protected ArraySpliteratorWithComparator makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public DoubleComparator getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator
    implements DoubleSpliterator {
        private final DoubleIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private DoubleSpliterator delegate = null;

        SpliteratorFromIterator(DoubleIterator doubleIterator, int n2) {
            this.iter = doubleIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(DoubleIterator doubleIterator, long l2, int n2) {
            this.iter = doubleIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(doubleConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            doubleConsumer.accept(this.iter.nextDouble());
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(doubleConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(doubleConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected DoubleSpliterator makeForSplit(double[] dArray, int n2) {
            return DoubleSpliterators.wrap(dArray, 0, n2, this.characteristics);
        }

        @Override
        public DoubleSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            double[] dArray = new double[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                dArray[n3++] = this.iter.nextDouble();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                dArray = Arrays.copyOf(dArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    dArray[n3++] = this.iter.nextDouble();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            DoubleSpliterator doubleSpliterator = this.makeForSplit(dArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = doubleSpliterator;
                return doubleSpliterator.trySplit();
            }
            return doubleSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator
    extends SpliteratorFromIterator {
        private final DoubleComparator comparator;

        SpliteratorFromIteratorWithComparator(DoubleIterator doubleIterator, long l2, int n2, DoubleComparator doubleComparator) {
            super(doubleIterator, l2, n2 | 0x14);
            this.comparator = doubleComparator;
        }

        @Override
        public DoubleComparator getComparator() {
            return this.comparator;
        }

        @Override
        protected DoubleSpliterator makeForSplit(double[] dArray, int n2) {
            return DoubleSpliterators.wrapPreSorted(dArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static class EmptySpliterator
    implements DoubleSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Double> consumer) {
            return false;
        }

        @Override
        public DoubleSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Double> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public DoubleSpliterator trySplit() {
            DoubleSpliterator doubleSpliterator = super.trySplit();
            if (!this.maxPosFixed && doubleSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return doubleSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractDoubleSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract double get(int var1);

        protected abstract int getMaxPos();

        protected abstract DoubleSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            doubleConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                doubleConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public DoubleSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            DoubleSpliterator doubleSpliterator = this.makeForSplit(n4, n3);
            if (doubleSpliterator != null) {
                this.pos = n3;
            }
            return doubleSpliterator;
        }
    }
}

