/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class CharComparators {
    public static final CharComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final CharComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static CharComparator oppositeComparator(CharComparator charComparator) {
        if (charComparator instanceof OppositeComparator) {
            return ((OppositeComparator)charComparator).comparator;
        }
        return new OppositeComparator(charComparator);
    }

    public static CharComparator asCharComparator(final Comparator<? super Character> comparator) {
        if (comparator == null || comparator instanceof CharComparator) {
            return (CharComparator)comparator;
        }
        return new CharComparator(){

            @Override
            public int compare(char c2, char c3) {
                return comparator.compare(Character.valueOf(c2), Character.valueOf(c3));
            }

            @Override
            public int compare(Character c2, Character c3) {
                return comparator.compare(c2, c3);
            }
        };
    }

    protected static class OppositeComparator
    implements CharComparator,
    Serializable {
        final CharComparator comparator;

        protected OppositeComparator(CharComparator charComparator) {
            this.comparator = charComparator;
        }

        @Override
        public final int compare(char c2, char c3) {
            return this.comparator.compare(c3, c2);
        }

        @Override
        public final CharComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements CharComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(char c2, char c3) {
            return Character.compare(c2, c3);
        }

        @Override
        public CharComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements CharComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(char c2, char c3) {
            return -Character.compare(c2, c3);
        }

        @Override
        public CharComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

