/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Arrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Hash;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharComparator;
import java.io.Serializable;

public final class CharArrays {
    public static final char[] EMPTY_ARRAY = new char[0];
    public static final char[] DEFAULT_EMPTY_ARRAY = new char[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<char[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(char[] cArray, int n2, int n3) {
        Arrays.ensureOffsetLength(cArray.length, n2, n3);
    }

    public static void swap(char[] cArray, int n2, int n3) {
        char c2 = cArray[n2];
        cArray[n2] = cArray[n3];
        cArray[n3] = c2;
    }

    public static void swap(char[] cArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            CharArrays.swap(cArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(char[] cArray, int n2, int n3, int n4, CharComparator charComparator) {
        int n5 = charComparator.compare(cArray[n2], cArray[n3]);
        int n6 = charComparator.compare(cArray[n2], cArray[n4]);
        int n7 = charComparator.compare(cArray[n3], cArray[n4]);
        return n5 < 0 ? (n7 < 0 ? n3 : (n6 < 0 ? n4 : n2)) : (n7 > 0 ? n3 : (n6 > 0 ? n4 : n2));
    }

    private static void selectionSort(char[] cArray, int n2, int n3, CharComparator charComparator) {
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (charComparator.compare(cArray[n4], cArray[n5]) >= 0) continue;
                n5 = n4;
            }
            if (n5 == i2) continue;
            n4 = cArray[i2];
            cArray[i2] = cArray[n5];
            cArray[n5] = n4;
        }
    }

    private static void insertionSort(char[] cArray, int n2, int n3, CharComparator charComparator) {
        int n4 = n2;
        while (++n4 < n3) {
            char c2 = cArray[n4];
            int n5 = n4;
            char c3 = cArray[n5 - 1];
            while (charComparator.compare(c2, c3) < 0) {
                cArray[n5] = c3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                c3 = cArray[--n5 - 1];
            }
            cArray[n5] = c2;
        }
    }

    public static void quickSort(char[] cArray, int n2, int n3, CharComparator charComparator) {
        int n4;
        int n5;
        int n6;
        char c2;
        int n7 = n3 - n2;
        if (n7 < 16) {
            CharArrays.selectionSort(cArray, n2, n3, charComparator);
            return;
        }
        int n8 = n2 + n7 / 2;
        int n9 = n2;
        int n10 = n3 - 1;
        if (n7 > 128) {
            c2 = n7 / 8;
            n9 = CharArrays.med3(cArray, n9, n9 + c2, n9 + 2 * c2, charComparator);
            n8 = CharArrays.med3(cArray, n8 - c2, n8, n8 + c2, charComparator);
            n10 = CharArrays.med3(cArray, n10 - 2 * c2, n10 - c2, n10, charComparator);
        }
        n8 = CharArrays.med3(cArray, n9, n8, n10, charComparator);
        c2 = cArray[n8];
        int n11 = n6 = n2;
        int n12 = n5 = n3 - 1;
        while (true) {
            if (n11 <= n5 && (n4 = charComparator.compare(cArray[n11], c2)) <= 0) {
                if (n4 == 0) {
                    CharArrays.swap(cArray, n6++, n11);
                }
                ++n11;
                continue;
            }
            while (n5 >= n11 && (n4 = charComparator.compare(cArray[n5], c2)) >= 0) {
                if (n4 == 0) {
                    CharArrays.swap(cArray, n5, n12--);
                }
                --n5;
            }
            if (n11 > n5) break;
            CharArrays.swap(cArray, n11++, n5--);
        }
        n4 = Math.min(n6 - n2, n11 - n6);
        CharArrays.swap(cArray, n2, n11 - n4, n4);
        n4 = Math.min(n12 - n5, n3 - n12 - 1);
        CharArrays.swap(cArray, n11, n3 - n4, n4);
        n4 = n11 - n6;
        if (n4 > 1) {
            CharArrays.quickSort(cArray, n2, n2 + n4, charComparator);
        }
        if ((n4 = n12 - n5) > 1) {
            CharArrays.quickSort(cArray, n3 - n4, n3, charComparator);
        }
    }

    private static int med3(char[] cArray, int n2, int n3, int n4) {
        int n5 = Character.compare(cArray[n2], cArray[n3]);
        int n6 = Character.compare(cArray[n2], cArray[n4]);
        int n7 = Character.compare(cArray[n3], cArray[n4]);
        return n5 < 0 ? (n7 < 0 ? n3 : (n6 < 0 ? n4 : n2)) : (n7 > 0 ? n3 : (n6 > 0 ? n4 : n2));
    }

    private static void selectionSort(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (cArray[n4] >= cArray[n5]) continue;
                n5 = n4;
            }
            if (n5 == i2) continue;
            n4 = cArray[i2];
            cArray[i2] = cArray[n5];
            cArray[n5] = n4;
        }
    }

    public static void quickSort(char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        char c2;
        int n7 = n3 - n2;
        if (n7 < 16) {
            CharArrays.selectionSort(cArray, n2, n3);
            return;
        }
        int n8 = n2 + n7 / 2;
        int n9 = n2;
        int n10 = n3 - 1;
        if (n7 > 128) {
            c2 = n7 / 8;
            n9 = CharArrays.med3(cArray, n9, n9 + c2, n9 + 2 * c2);
            n8 = CharArrays.med3(cArray, n8 - c2, n8, n8 + c2);
            n10 = CharArrays.med3(cArray, n10 - 2 * c2, n10 - c2, n10);
        }
        n8 = CharArrays.med3(cArray, n9, n8, n10);
        c2 = cArray[n8];
        int n11 = n6 = n2;
        int n12 = n5 = n3 - 1;
        while (true) {
            if (n11 <= n5 && (n4 = Character.compare(cArray[n11], c2)) <= 0) {
                if (n4 == 0) {
                    CharArrays.swap(cArray, n6++, n11);
                }
                ++n11;
                continue;
            }
            while (n5 >= n11 && (n4 = Character.compare(cArray[n5], c2)) >= 0) {
                if (n4 == 0) {
                    CharArrays.swap(cArray, n5, n12--);
                }
                --n5;
            }
            if (n11 > n5) break;
            CharArrays.swap(cArray, n11++, n5--);
        }
        n4 = Math.min(n6 - n2, n11 - n6);
        CharArrays.swap(cArray, n2, n11 - n4, n4);
        n4 = Math.min(n12 - n5, n3 - n12 - 1);
        CharArrays.swap(cArray, n11, n3 - n4, n4);
        n4 = n11 - n6;
        if (n4 > 1) {
            CharArrays.quickSort(cArray, n2, n2 + n4);
        }
        if ((n4 = n12 - n5) > 1) {
            CharArrays.quickSort(cArray, n3 - n4, n3);
        }
    }

    public static void unstableSort(char[] cArray, int n2, int n3) {
        if (n3 - n2 >= 2000) {
            CharArrays.radixSort(cArray, n2, n3);
        } else {
            CharArrays.quickSort(cArray, n2, n3);
        }
    }

    public static void unstableSort(char[] cArray) {
        CharArrays.unstableSort(cArray, 0, cArray.length);
    }

    public static void unstableSort(char[] cArray, int n2, int n3, CharComparator charComparator) {
        CharArrays.quickSort(cArray, n2, n3, charComparator);
    }

    public static void unstableSort(char[] cArray, CharComparator charComparator) {
        CharArrays.unstableSort(cArray, 0, cArray.length, charComparator);
    }

    public static void mergeSort(char[] cArray, int n2, int n3, CharComparator charComparator, char[] cArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            CharArrays.insertionSort(cArray, n2, n3, charComparator);
            return;
        }
        if (cArray2 == null) {
            cArray2 = java.util.Arrays.copyOf(cArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        CharArrays.mergeSort(cArray2, n2, n5, charComparator, cArray);
        CharArrays.mergeSort(cArray2, n5, n3, charComparator, cArray);
        if (charComparator.compare(cArray2[n5 - 1], cArray2[n5]) <= 0) {
            System.arraycopy(cArray2, n2, cArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            cArray[i2] = n7 >= n3 || n6 < n5 && charComparator.compare(cArray2[n6], cArray2[n7]) <= 0 ? cArray2[n6++] : cArray2[n7++];
        }
    }

    public static void mergeSort(char[] cArray, int n2, int n3, CharComparator charComparator) {
        CharArrays.mergeSort(cArray, n2, n3, charComparator, null);
    }

    public static void stableSort(char[] cArray, int n2, int n3, CharComparator charComparator) {
        CharArrays.mergeSort(cArray, n2, n3, charComparator);
    }

    public static void stableSort(char[] cArray, CharComparator charComparator) {
        CharArrays.stableSort(cArray, 0, cArray.length, charComparator);
    }

    public static void radixSort(char[] cArray, int n2, int n3) {
        if (n3 - n2 < 1024) {
            CharArrays.quickSort(cArray, n2, n3);
            return;
        }
        boolean bl2 = true;
        int n4 = 256;
        int n5 = 0;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        nArray[n5] = n2;
        nArray2[n5] = n3 - n2;
        nArray3[n5++] = 0;
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        while (n5 > 0) {
            int n6;
            int n7 = nArray[--n5];
            int n8 = nArray2[n5];
            int n9 = nArray3[n5];
            boolean bl3 = false;
            int n10 = (1 - n9 % 2) * 8;
            int n11 = n7 + n8;
            while (n11-- != n7) {
                int n12 = cArray[n11] >>> n10 & 0xFF ^ 0;
                nArray4[n12] = nArray4[n12] + 1;
            }
            n11 = -1;
            int n13 = n7;
            for (n6 = 0; n6 < 256; ++n6) {
                if (nArray4[n6] != 0) {
                    n11 = n6;
                }
                nArray5[n6] = n13 += nArray4[n6];
            }
            n6 = n7 + n8 - nArray4[n11];
            int n14 = -1;
            for (n13 = n7; n13 <= n6; n13 += nArray4[n14]) {
                char c2 = cArray[n13];
                n14 = c2 >>> n10 & 0xFF ^ 0;
                if (n13 < n6) {
                    while (true) {
                        int n15 = n14;
                        int n16 = nArray5[n15] - 1;
                        nArray5[n15] = n16;
                        int n17 = n16;
                        if (n16 <= n13) break;
                        char c3 = c2;
                        c2 = cArray[n17];
                        cArray[n17] = c3;
                        n14 = c2 >>> n10 & 0xFF ^ 0;
                    }
                    cArray[n13] = c2;
                }
                if (n9 < 1 && nArray4[n14] > 1) {
                    if (nArray4[n14] < 1024) {
                        CharArrays.quickSort(cArray, n13, n13 + nArray4[n14]);
                    } else {
                        nArray[n5] = n13;
                        nArray2[n5] = nArray4[n14];
                        nArray3[n5++] = n9 + 1;
                    }
                }
                nArray4[n14] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int n2, int n3, int n4) {
            this.offset = n2;
            this.length = n3;
            this.level = n4;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<char[]>,
    Serializable {
        private ArrayHashStrategy() {
        }
    }
}

