/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class ByteComparators {
    public static final ByteComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final ByteComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    public static ByteComparator oppositeComparator(ByteComparator byteComparator) {
        if (byteComparator instanceof OppositeComparator) {
            return ((OppositeComparator)byteComparator).comparator;
        }
        return new OppositeComparator(byteComparator);
    }

    public static ByteComparator asByteComparator(final Comparator<? super Byte> comparator) {
        if (comparator == null || comparator instanceof ByteComparator) {
            return (ByteComparator)comparator;
        }
        return new ByteComparator(){

            @Override
            public int compare(byte by2, byte by3) {
                return comparator.compare(by2, by3);
            }

            @Override
            public int compare(Byte by2, Byte by3) {
                return comparator.compare(by2, by3);
            }
        };
    }

    protected static class OppositeComparator
    implements ByteComparator,
    Serializable {
        final ByteComparator comparator;

        protected OppositeComparator(ByteComparator byteComparator) {
            this.comparator = byteComparator;
        }

        @Override
        public final int compare(byte by2, byte by3) {
            return this.comparator.compare(by3, by2);
        }

        @Override
        public final ByteComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements ByteComparator,
    Serializable {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(byte by2, byte by3) {
            return Byte.compare(by2, by3);
        }

        @Override
        public ByteComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements ByteComparator,
    Serializable {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(byte by2, byte by3) {
            return -Byte.compare(by2, by3);
        }

        @Override
        public ByteComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

