/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogLevel;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import java.io.Serializable;

public abstract class AbstractInternalLogger
implements InternalLogger,
Serializable {
    private final String name;

    protected AbstractInternalLogger(String string) {
        this.name = ObjectUtil.checkNotNull(string, "name");
    }

    public String name() {
        return this.name;
    }

    @Override
    public boolean isEnabled(InternalLogLevel internalLogLevel) {
        switch (internalLogLevel) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error("Unexpected log level: " + (Object)((Object)internalLogLevel));
    }

    @Override
    public void warn(Throwable throwable) {
        this.warn("Unexpected exception:", throwable);
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Throwable throwable) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, throwable);
                break;
            }
            case DEBUG: {
                this.debug(string, throwable);
                break;
            }
            case INFO: {
                this.info(string, throwable);
                break;
            }
            case WARN: {
                this.warn(string, throwable);
                break;
            }
            case ERROR: {
                this.error(string, throwable);
                break;
            }
            default: {
                throw new Error("Unexpected log level: " + (Object)((Object)internalLogLevel));
            }
        }
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string);
                break;
            }
            case DEBUG: {
                this.debug(string);
                break;
            }
            case INFO: {
                this.info(string);
                break;
            }
            case WARN: {
                this.warn(string);
                break;
            }
            case ERROR: {
                this.error(string);
                break;
            }
            default: {
                throw new Error("Unexpected log level: " + (Object)((Object)internalLogLevel));
            }
        }
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.name() + ')';
    }
}

