/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final Recycler<RecyclableArrayList> RECYCLER = new Recycler<RecyclableArrayList>(){

        @Override
        protected RecyclableArrayList newObject(Recycler.Handle<RecyclableArrayList> handle) {
            return new RecyclableArrayList(handle);
        }
    };
    private boolean insertSinceRecycled;
    private final ObjectPool.Handle<RecyclableArrayList> handle;

    public static RecyclableArrayList newInstance(int n2) {
        RecyclableArrayList recyclableArrayList = RECYCLER.get();
        recyclableArrayList.ensureCapacity(n2);
        return recyclableArrayList;
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle) {
        this(handle, 8);
    }

    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle, int n2) {
        super(n2);
        this.handle = handle;
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n2, Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(n2, collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> collection) {
        if (collection instanceof RandomAccess && collection instanceof List) {
            List list = (List)collection;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (list.get(i2) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        } else {
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        }
    }

    @Override
    public boolean add(Object object) {
        if (super.add(ObjectUtil.checkNotNull(object, "element"))) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public void add(int n2, Object object) {
        super.add(n2, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
    }

    @Override
    public Object set(int n2, Object object) {
        Object object2 = super.set(n2, ObjectUtil.checkNotNull(object, "element"));
        this.insertSinceRecycled = true;
        return object2;
    }

    public boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
        return true;
    }
}

