/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.BoundedInputStream;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.Cleaner;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanerJava24Linker;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanerJava25;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanerJava6;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanerJava9;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.DirectCleaner;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.OutOfDirectMemoryError;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent0;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.VarHandleFactory;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.MpscUnboundedArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpmcAtomicArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscChunkedAtomicArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscUnboundedAtomicArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.atomic.unpadded.MpscAtomicUnpaddedArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.unpadded.MpscUnpaddedArrayQueue;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jfr.FlightRecorder;

public final class PlatformDependent {
    private static final InternalLogger logger;
    private static Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN;
    private static final boolean MAYBE_SUPER_USER;
    private static final boolean CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final boolean DIRECT_BUFFER_PREFERRED;
    private static final boolean EXPLICIT_NO_PREFER_DIRECT;
    private static final long MAX_DIRECT_MEMORY;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final File TMPDIR;
    private static final int BIT_MODE;
    private static final String NORMALIZED_ARCH;
    private static final String NORMALIZED_OS;
    private static final Set<String> LINUX_OS_CLASSIFIERS;
    private static final boolean IS_WINDOWS;
    private static final boolean IS_OSX;
    private static final boolean IS_J9_JVM;
    private static final boolean IS_IVKVM_DOT_NET;
    private static final int ADDRESS_SIZE;
    private static final boolean USE_DIRECT_BUFFER_NO_CLEANER;
    private static final AtomicLong DIRECT_MEMORY_COUNTER;
    private static final long DIRECT_MEMORY_LIMIT;
    private static final Cleaner CLEANER;
    private static final Cleaner DIRECT_CLEANER;
    private static final Cleaner LEGACY_CLEANER;
    private static final boolean HAS_ALLOCATE_UNINIT_ARRAY;
    public static final boolean BIG_ENDIAN_NATIVE_ORDER;
    private static final boolean JFR;
    private static final boolean VAR_HANDLE;
    private static final Cleaner NOOP;

    private static boolean initializeVarHandle() {
        boolean bl2;
        Throwable throwable;
        if (UNSAFE_UNAVAILABILITY_CAUSE == null || PlatformDependent.javaVersion() < 9 || PlatformDependent0.isNativeImage()) {
            return false;
        }
        boolean bl3 = false;
        try {
            VarHandle.storeStoreFence();
            bl3 = VarHandleFactory.isSupported();
            throwable = VarHandleFactory.unavailableCause();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            logger.debug("java.lang.invoke.VarHandle: unavailable, reason: {}", (Object)throwable.toString());
        } else {
            logger.debug("java.lang.invoke.VarHandle: available");
        }
        boolean bl4 = bl2 = bl3 && SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.varHandle.enabled", bl3);
        if (logger.isTraceEnabled() && throwable != null) {
            logger.debug("-Dio.netty.varHandle.enabled: {}", (Object)bl2, (Object)throwable);
        } else if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.varHandle.enabled: {}", (Object)bl2);
        }
        return bl2;
    }

    static void addFilesystemOsClassifiers(Set<String> set) {
        if (PlatformDependent.processOsReleaseFile("/etc/os-release", set)) {
            return;
        }
        PlatformDependent.processOsReleaseFile("/usr/lib/os-release", set);
    }

    private static boolean processOsReleaseFile(String string, Set<String> set) {
        Path path = Paths.get(string, new String[0]);
        return AccessController.doPrivileged(() -> {
            block12: {
                try {
                    if (!Files.exists(path, new LinkOption[0])) break block12;
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BoundedInputStream(Files.newInputStream(path, new OpenOption[0])), StandardCharsets.UTF_8));){
                        String string2;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            if (string2.startsWith("ID=")) {
                                String string3 = PlatformDependent.normalizeOsReleaseVariableValue(string2.substring("ID=".length()));
                                PlatformDependent.addClassifier(set, string3);
                                continue;
                            }
                            if (!string2.startsWith("ID_LIKE=")) continue;
                            string2 = PlatformDependent.normalizeOsReleaseVariableValue(string2.substring("ID_LIKE=".length()));
                            PlatformDependent.addClassifier(set, string2.split(" "));
                        }
                    }
                    catch (SecurityException securityException) {
                        logger.debug("Unable to read {}", (Object)string, (Object)securityException);
                    }
                    catch (IOException iOException) {
                        logger.debug("Error while reading content of {}", (Object)string, (Object)iOException);
                    }
                    return true;
                }
                catch (SecurityException securityException) {
                    logger.debug("Unable to check if {} exists", (Object)string, (Object)securityException);
                }
            }
            return false;
        });
    }

    static boolean addPropertyOsClassifiers(Set<String> set) {
        String string = "com.gradle.maven.extension.internal.dep.io.netty.osClassifiers";
        String string2 = SystemPropertyUtil.get(string);
        if (string2 == null) {
            return false;
        }
        if (string2.isEmpty()) {
            return true;
        }
        String[] stringArray = string2.split(",");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException(string + " property is not empty, but contains no classifiers: " + string2);
        }
        if (stringArray.length > 2) {
            throw new IllegalArgumentException(string + " property contains more than 2 classifiers: " + string2);
        }
        for (String string3 : stringArray) {
            PlatformDependent.addClassifier(set, string3);
        }
        return true;
    }

    public static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    public static boolean hasDirectBufferNoCleanerConstructor() {
        return PlatformDependent0.hasDirectBufferNoCleanerConstructor();
    }

    public static byte[] allocateUninitializedArray(int n2) {
        return HAS_ALLOCATE_UNINIT_ARRAY ? PlatformDependent0.allocateUninitializedArray(n2) : new byte[n2];
    }

    public static boolean isAndroid() {
        return PlatformDependent0.isAndroid();
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isOsx() {
        return IS_OSX;
    }

    public static boolean maybeSuperUser() {
        return MAYBE_SUPER_USER;
    }

    public static int javaVersion() {
        return PlatformDependent0.javaVersion();
    }

    public static boolean isVirtualThread(Thread thread) {
        return PlatformDependent0.isVirtualThread(thread);
    }

    public static boolean canEnableTcpNoDelayByDefault() {
        return CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    }

    public static boolean hasUnsafe() {
        return UNSAFE_UNAVAILABILITY_CAUSE == null;
    }

    public static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    public static boolean isUnaligned() {
        return PlatformDependent0.isUnaligned();
    }

    public static boolean directBufferPreferred() {
        return DIRECT_BUFFER_PREFERRED;
    }

    public static boolean isExplicitNoPreferDirect() {
        return EXPLICIT_NO_PREFER_DIRECT;
    }

    public static boolean canReliabilyFreeDirectBuffers() {
        return CLEANER != NOOP;
    }

    public static long maxDirectMemory() {
        return DIRECT_MEMORY_LIMIT;
    }

    public static File tmpdir() {
        return TMPDIR;
    }

    public static void throwException(Throwable throwable) {
        PlatformDependent0.throwException(throwable);
    }

    public static CleanableDirectBuffer allocateDirect(int n2) {
        return CLEANER.allocate(n2);
    }

    @Deprecated
    public static void freeDirectBuffer(ByteBuffer byteBuffer) {
        LEGACY_CLEANER.freeDirectBuffer(byteBuffer);
    }

    public static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.directBufferAddress(byteBuffer);
    }

    public static boolean hasVarHandle() {
        return VAR_HANDLE;
    }

    public static VarHandle findVarHandleOfIntField(MethodHandles.Lookup lookup, Class<?> clazz, String string) {
        if (VAR_HANDLE) {
            return VarHandleFactory.privateFindVarHandle(lookup, clazz, string, Integer.TYPE);
        }
        return null;
    }

    public static VarHandle intBeArrayView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.intBeArrayView();
        }
        return null;
    }

    public static VarHandle intLeArrayView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.intLeArrayView();
        }
        return null;
    }

    public static VarHandle longBeArrayView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.longBeArrayView();
        }
        return null;
    }

    public static VarHandle longLeArrayView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.longLeArrayView();
        }
        return null;
    }

    public static VarHandle shortBeArrayView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.shortBeArrayView();
        }
        return null;
    }

    public static VarHandle shortLeArrayView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.shortLeArrayView();
        }
        return null;
    }

    public static VarHandle longBeByteBufferView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.longBeByteBufferView();
        }
        return null;
    }

    public static VarHandle longLeByteBufferView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.longLeByteBufferView();
        }
        return null;
    }

    public static VarHandle intBeByteBufferView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.intBeByteBufferView();
        }
        return null;
    }

    public static VarHandle intLeByteBufferView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.intLeByteBufferView();
        }
        return null;
    }

    public static VarHandle shortBeByteBufferView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.shortBeByteBufferView();
        }
        return null;
    }

    public static VarHandle shortLeByteBufferView() {
        if (VAR_HANDLE) {
            return VarHandleFactory.shortLeByteBufferView();
        }
        return null;
    }

    public static Object getObject(Object object, long l2) {
        return PlatformDependent0.getObject(object, l2);
    }

    public static int getVolatileInt(Object object, long l2) {
        return PlatformDependent0.getIntVolatile(object, l2);
    }

    public static int getInt(Object object, long l2) {
        return PlatformDependent0.getInt(object, l2);
    }

    public static void putOrderedInt(Object object, long l2, int n2) {
        PlatformDependent0.putOrderedInt(object, l2, n2);
    }

    public static int getAndAddInt(Object object, long l2, int n2) {
        return PlatformDependent0.getAndAddInt(object, l2, n2);
    }

    public static boolean compareAndSwapInt(Object object, long l2, int n2, int n3) {
        return PlatformDependent0.compareAndSwapInt(object, l2, n2, n3);
    }

    static void safeConstructPutInt(Object object, long l2, int n2) {
        PlatformDependent0.safeConstructPutInt(object, l2, n2);
    }

    public static byte getByte(long l2) {
        return PlatformDependent0.getByte(l2);
    }

    public static short getShort(long l2) {
        return PlatformDependent0.getShort(l2);
    }

    public static int getInt(long l2) {
        return PlatformDependent0.getInt(l2);
    }

    public static long getLong(long l2) {
        return PlatformDependent0.getLong(l2);
    }

    public static byte getByte(byte[] byArray, int n2) {
        return PlatformDependent.hasUnsafe() ? PlatformDependent0.getByte(byArray, n2) : byArray[n2];
    }

    public static short getShort(byte[] byArray, int n2) {
        return PlatformDependent.hasUnsafe() ? PlatformDependent0.getShort(byArray, n2) : (short)byArray[n2];
    }

    public static int getInt(byte[] byArray, int n2) {
        return PlatformDependent.hasUnsafe() ? PlatformDependent0.getInt(byArray, n2) : byArray[n2];
    }

    public static long getLong(byte[] byArray, int n2) {
        return PlatformDependent.hasUnsafe() ? PlatformDependent0.getLong(byArray, n2) : (long)byArray[n2];
    }

    private static long getLongSafe(byte[] byArray, int n2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (long)byArray[n2] << 56 | ((long)byArray[n2 + 1] & 0xFFL) << 48 | ((long)byArray[n2 + 2] & 0xFFL) << 40 | ((long)byArray[n2 + 3] & 0xFFL) << 32 | ((long)byArray[n2 + 4] & 0xFFL) << 24 | ((long)byArray[n2 + 5] & 0xFFL) << 16 | ((long)byArray[n2 + 6] & 0xFFL) << 8 | (long)byArray[n2 + 7] & 0xFFL;
        }
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | (long)byArray[n2 + 7] << 56;
    }

    private static int getIntSafe(byte[] byArray, int n2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
        }
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | byArray[n2 + 3] << 24;
    }

    private static short getShortSafe(byte[] byArray, int n2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (short)(byArray[n2] << 8 | byArray[n2 + 1] & 0xFF);
        }
        return (short)(byArray[n2] & 0xFF | byArray[n2 + 1] << 8);
    }

    private static int hashCodeAsciiCompute(CharSequence charSequence, int n2, int n3) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return n3 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n2 + 4) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n2);
        }
        return n3 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n2) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n2 + 4);
    }

    private static int hashCodeAsciiSanitizeInt(CharSequence charSequence, int n2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n2 + 3) & 0x1F | (charSequence.charAt(n2 + 2) & 0x1F) << 8 | (charSequence.charAt(n2 + 1) & 0x1F) << 16 | (charSequence.charAt(n2) & 0x1F) << 24;
        }
        return (charSequence.charAt(n2 + 3) & 0x1F) << 24 | (charSequence.charAt(n2 + 2) & 0x1F) << 16 | (charSequence.charAt(n2 + 1) & 0x1F) << 8 | charSequence.charAt(n2) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeShort(CharSequence charSequence, int n2) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n2 + 1) & 0x1F | (charSequence.charAt(n2) & 0x1F) << 8;
        }
        return (charSequence.charAt(n2 + 1) & 0x1F) << 8 | charSequence.charAt(n2) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeByte(char c2) {
        return c2 & 0x1F;
    }

    public static void putByte(long l2, byte by2) {
        PlatformDependent0.putByte(l2, by2);
    }

    public static void putShort(long l2, short s2) {
        PlatformDependent0.putShort(l2, s2);
    }

    public static void putInt(long l2, int n2) {
        PlatformDependent0.putInt(l2, n2);
    }

    public static void putLong(long l2, long l3) {
        PlatformDependent0.putLong(l2, l3);
    }

    public static void putByte(byte[] byArray, int n2, byte by2) {
        PlatformDependent0.putByte(byArray, n2, by2);
    }

    public static void putByte(Object object, long l2, byte by2) {
        PlatformDependent0.putByte(object, l2, by2);
    }

    public static void putShort(byte[] byArray, int n2, short s2) {
        PlatformDependent0.putShort(byArray, n2, s2);
    }

    public static void putInt(byte[] byArray, int n2, int n3) {
        PlatformDependent0.putInt(byArray, n2, n3);
    }

    public static void putLong(byte[] byArray, int n2, long l2) {
        PlatformDependent0.putLong(byArray, n2, l2);
    }

    public static void putObject(Object object, long l2, Object object2) {
        PlatformDependent0.putObject(object, l2, object2);
    }

    public static long objectFieldOffset(Field field) {
        return PlatformDependent0.objectFieldOffset(field);
    }

    public static void copyMemory(long l2, long l3, long l4) {
        PlatformDependent0.copyMemory(l2, l3, l4);
    }

    public static void copyMemory(byte[] byArray, int n2, long l2, long l3) {
        PlatformDependent0.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, null, l2, l3);
    }

    public static void copyMemory(byte[] byArray, int n2, byte[] byArray2, int n3, long l2) {
        PlatformDependent0.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, byArray2, BYTE_ARRAY_BASE_OFFSET + (long)n3, l2);
    }

    public static void copyMemory(long l2, byte[] byArray, int n2, long l3) {
        PlatformDependent0.copyMemory(null, l2, byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, l3);
    }

    public static void setMemory(byte[] byArray, int n2, long l2, byte by2) {
        PlatformDependent0.setMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, l2, by2);
    }

    public static void setMemory(long l2, long l3, byte by2) {
        PlatformDependent0.setMemory(l2, l3, by2);
    }

    public static ByteBuffer allocateDirectNoCleaner(int n2) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        PlatformDependent.incrementMemoryCounter(n2);
        try {
            return PlatformDependent0.allocateDirectNoCleaner(n2);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n2);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static CleanableDirectBuffer allocateDirectBufferNoCleaner(int n2) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        return DIRECT_CLEANER.allocate(n2);
    }

    public static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n2) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n3 = n2 - byteBuffer.capacity();
        PlatformDependent.incrementMemoryCounter(n3);
        try {
            return PlatformDependent0.reallocateDirectNoCleaner(byteBuffer, n2);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n3);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static CleanableDirectBuffer reallocateDirectBufferNoCleaner(CleanableDirectBuffer cleanableDirectBuffer, int n2) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        return ((DirectCleaner)DIRECT_CLEANER).reallocate(cleanableDirectBuffer, n2);
    }

    public static void freeDirectNoCleaner(ByteBuffer byteBuffer) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n2 = byteBuffer.capacity();
        PlatformDependent0.freeMemory(PlatformDependent0.directBufferAddress(byteBuffer));
        PlatformDependent.decrementMemoryCounter(n2);
    }

    public static boolean hasAlignDirectByteBuffer() {
        return PlatformDependent.hasUnsafe() || PlatformDependent0.hasAlignSliceMethod();
    }

    public static ByteBuffer alignDirectBuffer(ByteBuffer byteBuffer, int n2) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Cannot get aligned slice of non-direct byte buffer.");
        }
        if (PlatformDependent0.hasAlignSliceMethod()) {
            return PlatformDependent0.alignSlice(byteBuffer, n2);
        }
        if (PlatformDependent.hasUnsafe()) {
            long l2 = PlatformDependent.directBufferAddress(byteBuffer);
            long l3 = PlatformDependent.align(l2, n2);
            byteBuffer.position((int)(l3 - l2));
            return byteBuffer.slice();
        }
        throw new UnsupportedOperationException("Cannot align direct buffer. Needs either Unsafe or ByteBuffer.alignSlice method available.");
    }

    public static long align(long l2, int n2) {
        return Pow2.align(l2, n2);
    }

    private static void incrementMemoryCounter(int n2) {
        long l2;
        if (DIRECT_MEMORY_COUNTER != null && (l2 = DIRECT_MEMORY_COUNTER.addAndGet(n2)) > DIRECT_MEMORY_LIMIT) {
            DIRECT_MEMORY_COUNTER.addAndGet(-n2);
            throw new OutOfDirectMemoryError("failed to allocate " + n2 + " byte(s) of direct memory (used: " + (l2 - (long)n2) + ", max: " + DIRECT_MEMORY_LIMIT + ')');
        }
    }

    private static void decrementMemoryCounter(int n2) {
        if (DIRECT_MEMORY_COUNTER != null) {
            long l2 = DIRECT_MEMORY_COUNTER.addAndGet(-n2);
            assert (l2 >= 0L);
        }
    }

    public static boolean useDirectBufferNoCleaner() {
        return USE_DIRECT_BUFFER_NO_CLEANER;
    }

    public static boolean equals(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (PlatformDependent.javaVersion() > 8 && (n3 | n2 | byArray.length - n4 | byArray2.length - n4) == 0) {
            return Arrays.equals(byArray, byArray2);
        }
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.equalsSafe(byArray, n2, byArray2, n3, n4) : PlatformDependent0.equals(byArray, n2, byArray2, n3, n4);
    }

    public static int hashCodeAscii(byte[] byArray, int n2, int n3) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.hashCodeAsciiSafe(byArray, n2, n3) : PlatformDependent0.hashCodeAscii(byArray, n2, n3);
    }

    public static int hashCodeAscii(CharSequence charSequence) {
        int n2;
        int n3 = charSequence.length();
        int n4 = n3 & 7;
        int n5 = -1028477387;
        if (n3 >= 32) {
            for (n2 = n3 - 8; n2 >= n4; n2 -= 8) {
                n5 = PlatformDependent.hashCodeAsciiCompute(charSequence, n2, n5);
            }
        } else if (n3 >= 8) {
            n5 = PlatformDependent.hashCodeAsciiCompute(charSequence, n3 - 8, n5);
            if (n3 >= 16) {
                n5 = PlatformDependent.hashCodeAsciiCompute(charSequence, n3 - 16, n5);
                if (n3 >= 24) {
                    n5 = PlatformDependent.hashCodeAsciiCompute(charSequence, n3 - 24, n5);
                }
            }
        }
        if (n4 == 0) {
            return n5;
        }
        n2 = 0;
        if (n4 != 2 & n4 != 4 & n4 != 6) {
            n5 = n5 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeByte(charSequence.charAt(0));
            n2 = 1;
        }
        if (n4 != 1 & n4 != 4 & n4 != 5) {
            n5 = n5 * (n2 == 0 ? -862048943 : 461845907) + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.hashCodeAsciiSanitizeShort(charSequence, n2));
            n2 += 2;
        }
        if (n4 >= 4) {
            return n5 * (n2 == 0 | n2 == 3 ? -862048943 : 461845907) + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n2);
        }
        return n5;
    }

    public static <T> Queue<T> newMpscQueue() {
        return Mpsc.newMpscQueue();
    }

    public static <T> Queue<T> newMpscQueue(int n2) {
        return Mpsc.newMpscQueue(n2);
    }

    public static <T> Queue<T> newMpscQueue(int n2, int n3) {
        return Mpsc.newChunkedMpscQueue(n2, n3);
    }

    public static <T> Queue<T> newFixedMpscUnpaddedQueue(int n2) {
        return PlatformDependent.hasUnsafe() ? new MpscUnpaddedArrayQueue(n2) : new MpscAtomicUnpaddedArrayQueue(n2);
    }

    public static <T> Queue<T> newFixedMpmcQueue(int n2) {
        return PlatformDependent.hasUnsafe() ? new MpmcArrayQueue(n2) : new MpmcAtomicArrayQueue(n2);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return PlatformDependent0.getClassLoader(clazz);
    }

    public static ClassLoader getSystemClassLoader() {
        return PlatformDependent0.getSystemClassLoader();
    }

    private static boolean isWindows0() {
        boolean bl2 = "windows".equals(NORMALIZED_OS);
        if (bl2) {
            logger.debug("Platform: Windows");
        }
        return bl2;
    }

    private static boolean isOsx0() {
        boolean bl2 = "osx".equals(NORMALIZED_OS);
        if (bl2) {
            logger.debug("Platform: MacOS");
        }
        return bl2;
    }

    private static boolean maybeSuperUser0() {
        String string = SystemPropertyUtil.get("user.name");
        if (PlatformDependent.isWindows()) {
            return "Administrator".equals(string);
        }
        return "root".equals(string) || "toor".equals(string);
    }

    private static Throwable unsafeUnavailabilityCause0() {
        if (PlatformDependent.isAndroid()) {
            logger.debug("sun.misc.Unsafe: unavailable (Android)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (Android)");
        }
        if (PlatformDependent.isIkvmDotNet()) {
            logger.debug("sun.misc.Unsafe: unavailable (IKVM.NET)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (IKVM.NET)");
        }
        Throwable throwable = PlatformDependent0.getUnsafeUnavailabilityCause();
        if (throwable != null) {
            return throwable;
        }
        try {
            boolean bl2 = PlatformDependent0.hasUnsafe();
            logger.debug("sun.misc.Unsafe: {}", (Object)(bl2 ? "available" : "unavailable"));
            return null;
        }
        catch (Throwable throwable2) {
            logger.trace("Could not determine if Unsafe is available", throwable2);
            return new UnsupportedOperationException("Could not determine if Unsafe is available", throwable2);
        }
    }

    public static boolean isJ9Jvm() {
        return IS_J9_JVM;
    }

    private static boolean isJ9Jvm0() {
        String string = SystemPropertyUtil.get("java.vm.name", "").toLowerCase();
        return string.startsWith("ibm j9") || string.startsWith("eclipse openj9");
    }

    public static boolean isIkvmDotNet() {
        return IS_IVKVM_DOT_NET;
    }

    private static boolean isIkvmDotNet0() {
        String string = SystemPropertyUtil.get("java.vm.name", "").toUpperCase(Locale.US);
        return string.equals("IKVM.NET");
    }

    private static Pattern getMaxDirectMemorySizeArgPattern() {
        Pattern pattern = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN;
        if (pattern == null) {
            MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = pattern = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
        }
        return pattern;
    }

    public static long estimateMaxDirectMemory() {
        long l2 = PlatformDependent0.bitsMaxDirectMemory();
        if (l2 > 0L) {
            return l2;
        }
        try {
            ClassLoader classLoader = PlatformDependent.getSystemClassLoader();
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            Class<?> clazz2 = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle methodHandle = lookup.findStatic(clazz, "getRuntimeMXBean", MethodType.methodType(clazz2));
            MethodHandle methodHandle2 = lookup.findVirtual(clazz2, "getInputArguments", MethodType.methodType(List.class));
            List list = methodHandle2.invoke(methodHandle.invoke());
            Pattern pattern = PlatformDependent.getMaxDirectMemorySizeArgPattern();
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                Matcher matcher = pattern.matcher((CharSequence)list.get(i2));
                if (!matcher.matches()) continue;
                l2 = Long.parseLong(matcher.group(1));
                switch (matcher.group(2).charAt(0)) {
                    case 'K': 
                    case 'k': {
                        l2 *= 1024L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        l2 *= 0x100000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        l2 *= 0x40000000L;
                        break;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l2 <= 0L) {
            l2 = Runtime.getRuntime().maxMemory();
            logger.debug("maxDirectMemory: {} bytes (maybe)", (Object)l2);
        } else {
            logger.debug("maxDirectMemory: {} bytes", (Object)l2);
        }
        return l2;
    }

    private static File tmpdir0() {
        File file;
        try {
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("com.gradle.maven.extension.internal.dep.io.netty.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {}", (Object)file);
                return file;
            }
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {} (java.io.tmpdir)", (Object)file);
                return file;
            }
            if (PlatformDependent.isWindows()) {
                file = PlatformDependent.toDirectory(System.getenv("TEMP"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} (%TEMP%)", (Object)file);
                    return file;
                }
                String string = System.getenv("USERPROFILE");
                if (string != null) {
                    file = PlatformDependent.toDirectory(string + "\\AppData\\Local\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\AppData\\Local\\Temp)", (Object)file);
                        return file;
                    }
                    file = PlatformDependent.toDirectory(string + "\\Local Settings\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\Local Settings\\Temp)", (Object)file);
                        return file;
                    }
                }
            } else {
                file = PlatformDependent.toDirectory(System.getenv("TMPDIR"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} ($TMPDIR)", (Object)file);
                    return file;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        file = PlatformDependent.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: {}", (Object)file);
        return file;
    }

    private static File toDirectory(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        file.mkdirs();
        if (!file.isDirectory()) {
            return null;
        }
        try {
            return file.getAbsoluteFile();
        }
        catch (Exception exception) {
            return file;
        }
    }

    private static int bitMode0() {
        int n2 = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.bitMode", 0);
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {}", (Object)n2);
            return n2;
        }
        n2 = SystemPropertyUtil.getInt("sun.arch.data.model", 0);
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (sun.arch.data.model)", (Object)n2);
            return n2;
        }
        n2 = SystemPropertyUtil.getInt("com.ibm.vm.bitmode", 0);
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (com.ibm.vm.bitmode)", (Object)n2);
            return n2;
        }
        String string = SystemPropertyUtil.get("os.arch", "").toLowerCase(Locale.US).trim();
        if ("amd64".equals(string) || "x86_64".equals(string)) {
            n2 = 64;
        } else if ("i386".equals(string) || "i486".equals(string) || "i586".equals(string) || "i686".equals(string)) {
            n2 = 32;
        }
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (os.arch: {})", (Object)n2, (Object)string);
        }
        String string2 = SystemPropertyUtil.get("java.vm.name", "").toLowerCase(Locale.US);
        Pattern pattern = Pattern.compile("([1-9][0-9]+)-?bit");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 64;
    }

    private static int addressSize0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1;
        }
        return PlatformDependent0.addressSize();
    }

    private static long byteArrayBaseOffset0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1L;
        }
        return PlatformDependent0.byteArrayBaseOffset();
    }

    private static boolean equalsSafe(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            if (byArray[n2] != byArray2[n3]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    static int hashCodeAsciiSafe(byte[] byArray, int n2, int n3) {
        int n4 = -1028477387;
        int n5 = n3 & 7;
        int n6 = n2 + n5;
        for (int i2 = n2 - 8 + n3; i2 >= n6; i2 -= 8) {
            n4 = PlatformDependent0.hashCodeAsciiCompute(PlatformDependent.getLongSafe(byArray, i2), n4);
        }
        switch (n5) {
            case 7: {
                return ((n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n2])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n2 + 1))) * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n2 + 3));
            }
            case 6: {
                return (n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n2))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n2 + 2));
            }
            case 5: {
                return (n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n2])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n2 + 1));
            }
            case 4: {
                return n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n2));
            }
            case 3: {
                return (n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n2])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n2 + 1));
            }
            case 2: {
                return n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n2));
            }
            case 1: {
                return n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n2]);
            }
        }
        return n4;
    }

    public static String normalizedArch() {
        return NORMALIZED_ARCH;
    }

    public static String normalizedOs() {
        return NORMALIZED_OS;
    }

    public static Set<String> normalizedLinuxClassifiers() {
        return LINUX_OS_CLASSIFIERS;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        if (file == null) {
            return Files.createTempFile(string, string2, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(file.toPath(), string, string2, new FileAttribute[0]).toFile();
    }

    private static void addClassifier(Set<String> set, String ... stringArray) {
        for (String string : stringArray) {
            if (!PlatformDependent.isAllowedClassifier(string)) continue;
            set.add(string);
        }
    }

    private static boolean isAllowedClassifier(String string) {
        switch (string) {
            case "fedora": 
            case "suse": 
            case "arch": {
                return true;
            }
        }
        return false;
    }

    private static String normalizeOsReleaseVariableValue(String string) {
        String string2 = string.trim();
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 == '\"' || c2 == '\'') continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static String normalize(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = Character.toLowerCase(string.charAt(i2));
            if ((c2 < 'a' || c2 > 'z') && (c2 < '0' || c2 > '9')) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static String normalizeArch(String string) {
        switch (string = PlatformDependent.normalize(string)) {
            case "x8664": 
            case "amd64": 
            case "ia32e": 
            case "em64t": 
            case "x64": {
                return "x86_64";
            }
            case "x8632": 
            case "x86": 
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": 
            case "ia32": 
            case "x32": {
                return "x86_32";
            }
            case "ia64": 
            case "itanium64": {
                return "itanium_64";
            }
            case "sparc": 
            case "sparc32": {
                return "sparc_32";
            }
            case "sparcv9": 
            case "sparc64": {
                return "sparc_64";
            }
            case "arm": 
            case "arm32": {
                return "arm_32";
            }
            case "aarch64": {
                return "aarch_64";
            }
            case "riscv64": {
                return "riscv64";
            }
            case "ppc": 
            case "ppc32": {
                return "ppc_32";
            }
            case "ppc64": {
                return "ppc_64";
            }
            case "ppc64le": {
                return "ppcle_64";
            }
            case "s390": {
                return "s390_32";
            }
            case "s390x": {
                return "s390_64";
            }
            case "loongarch64": {
                return "loongarch_64";
            }
        }
        return "unknown";
    }

    private static String normalizeOs(String string) {
        if ((string = PlatformDependent.normalize(string)).startsWith("aix")) {
            return "aix";
        }
        if (string.startsWith("hpux")) {
            return "hpux";
        }
        if (string.startsWith("os400") && (string.length() <= 5 || !Character.isDigit(string.charAt(5)))) {
            return "os400";
        }
        if (string.startsWith("linux")) {
            return "linux";
        }
        if (string.startsWith("macosx") || string.startsWith("osx") || string.startsWith("darwin")) {
            return "osx";
        }
        if (string.startsWith("freebsd")) {
            return "freebsd";
        }
        if (string.startsWith("openbsd")) {
            return "openbsd";
        }
        if (string.startsWith("netbsd")) {
            return "netbsd";
        }
        if (string.startsWith("solaris") || string.startsWith("sunos")) {
            return "sunos";
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        return "unknown";
    }

    public static boolean isJfrEnabled() {
        return JFR;
    }

    private PlatformDependent() {
    }

    static {
        boolean bl2;
        LinkedHashSet<String> linkedHashSet;
        logger = InternalLoggerFactory.getInstance(PlatformDependent.class);
        CAN_ENABLE_TCP_NODELAY_BY_DEFAULT = !PlatformDependent.isAndroid();
        UNSAFE_UNAVAILABILITY_CAUSE = PlatformDependent.unsafeUnavailabilityCause0();
        MAX_DIRECT_MEMORY = PlatformDependent.estimateMaxDirectMemory();
        BYTE_ARRAY_BASE_OFFSET = PlatformDependent.byteArrayBaseOffset0();
        TMPDIR = PlatformDependent.tmpdir0();
        BIT_MODE = PlatformDependent.bitMode0();
        NORMALIZED_ARCH = PlatformDependent.normalizeArch(SystemPropertyUtil.get("os.arch", ""));
        NORMALIZED_OS = PlatformDependent.normalizeOs(SystemPropertyUtil.get("os.name", ""));
        IS_WINDOWS = PlatformDependent.isWindows0();
        IS_OSX = PlatformDependent.isOsx0();
        IS_J9_JVM = PlatformDependent.isJ9Jvm0();
        IS_IVKVM_DOT_NET = PlatformDependent.isIkvmDotNet0();
        ADDRESS_SIZE = PlatformDependent.addressSize0();
        BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        NOOP = new Cleaner(){

            @Override
            public CleanableDirectBuffer allocate(final int n2) {
                return new CleanableDirectBuffer(){
                    private final ByteBuffer byteBuffer;
                    {
                        this.byteBuffer = ByteBuffer.allocateDirect(n2);
                    }

                    @Override
                    public ByteBuffer buffer() {
                        return this.byteBuffer;
                    }

                    @Override
                    public void clean() {
                    }
                };
            }

            @Override
            public void freeDirectBuffer(ByteBuffer byteBuffer) {
            }
        };
        long l2 = SystemPropertyUtil.getLong("com.gradle.maven.extension.internal.dep.io.netty.maxDirectMemory", -1L);
        if (l2 == 0L || !PlatformDependent.hasUnsafe() || !PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            USE_DIRECT_BUFFER_NO_CLEANER = false;
            DIRECT_CLEANER = NOOP;
            DIRECT_MEMORY_COUNTER = null;
        } else {
            USE_DIRECT_BUFFER_NO_CLEANER = true;
            DIRECT_CLEANER = new DirectCleaner();
            DIRECT_MEMORY_COUNTER = l2 < 0L ? ((l2 = MAX_DIRECT_MEMORY) <= 0L ? null : new AtomicLong()) : new AtomicLong();
        }
        logger.debug("-Dio.netty.maxDirectMemory: {} bytes", (Object)l2);
        DIRECT_MEMORY_LIMIT = l2 >= 1L ? l2 : MAX_DIRECT_MEMORY;
        HAS_ALLOCATE_UNINIT_ARRAY = PlatformDependent.javaVersion() >= 9 && PlatformDependent0.hasAllocateArrayMethod();
        MAYBE_SUPER_USER = PlatformDependent.maybeSuperUser0();
        LEGACY_CLEANER = !PlatformDependent.isAndroid() ? (PlatformDependent.javaVersion() >= 9 ? (CleanerJava9.isSupported() ? new CleanerJava9() : (CleanerJava24Linker.isSupported() ? new CleanerJava24Linker() : (CleanerJava25.isSupported() ? new CleanerJava25() : NOOP))) : (CleanerJava6.isSupported() ? new CleanerJava6() : NOOP)) : NOOP;
        CLEANER = USE_DIRECT_BUFFER_NO_CLEANER ? DIRECT_CLEANER : LEGACY_CLEANER;
        EXPLICIT_NO_PREFER_DIRECT = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.noPreferDirect", false);
        boolean bl3 = DIRECT_BUFFER_PREFERRED = CLEANER != NOOP && !EXPLICIT_NO_PREFER_DIRECT;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noPreferDirect: {}", (Object)EXPLICIT_NO_PREFER_DIRECT);
        }
        if (CLEANER == NOOP && !PlatformDependent0.isExplicitNoUnsafe()) {
            logger.info("Your platform does not provide complete low-level API for accessing direct buffers reliably. Unless explicitly requested, heap buffer will always be preferred to avoid potential system instability.");
        }
        if (!PlatformDependent.addPropertyOsClassifiers(linkedHashSet = new LinkedHashSet<String>())) {
            PlatformDependent.addFilesystemOsClassifiers(linkedHashSet);
        }
        LINUX_OS_CLASSIFIERS = Collections.unmodifiableSet(linkedHashSet);
        Throwable throwable = null;
        try {
            bl2 = FlightRecorder.isAvailable();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            bl2 = false;
        }
        JFR = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.jfr.enabled", bl2);
        if (logger.isTraceEnabled() && throwable != null) {
            logger.debug("-Dio.netty.jfr.enabled: {}", (Object)JFR, (Object)throwable);
        } else if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.jfr.enabled: {}", (Object)JFR);
        }
        VAR_HANDLE = PlatformDependent.initializeVarHandle();
    }

    private static final class Mpsc {
        private static final boolean USE_MPSC_CHUNKED_ARRAY_QUEUE;

        static <T> Queue<T> newMpscQueue(int n2) {
            int n3 = Math.max(Math.min(n2, 0x40000000), 2048);
            return Mpsc.newChunkedMpscQueue(1024, n3);
        }

        static <T> Queue<T> newChunkedMpscQueue(int n2, int n3) {
            return USE_MPSC_CHUNKED_ARRAY_QUEUE ? new MpscChunkedArrayQueue(n2, n3) : new MpscChunkedAtomicArrayQueue(n2, n3);
        }

        static <T> Queue<T> newMpscQueue() {
            return USE_MPSC_CHUNKED_ARRAY_QUEUE ? new MpscUnboundedArrayQueue(1024) : new MpscUnboundedAtomicArrayQueue(1024);
        }

        static {
            Object object = null;
            if (PlatformDependent.hasUnsafe()) {
                object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return UnsafeAccess.UNSAFE;
                    }
                });
            }
            if (object == null) {
                logger.debug("org.jctools-core.MpscChunkedArrayQueue: unavailable");
                USE_MPSC_CHUNKED_ARRAY_QUEUE = false;
            } else {
                logger.debug("org.jctools-core.MpscChunkedArrayQueue: available");
                USE_MPSC_CHUNKED_ARRAY_QUEUE = true;
            }
        }
    }
}

