/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.internal;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.CleanableDirectBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.Cleaner;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent0;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class CleanerJava24Linker
implements Cleaner {
    private static final InternalLogger logger;
    private static final MethodHandle INVOKE_MALLOC;
    private static final MethodHandle INVOKE_CREATE_BYTEBUFFER;
    private static final MethodHandle INVOKE_FREE;

    static boolean isSupported() {
        return INVOKE_MALLOC != null;
    }

    @Override
    public CleanableDirectBuffer allocate(int n2) {
        return new CleanableDirectBufferImpl(n2);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("Cannot clean arbitrary ByteBuffer instances");
    }

    static long malloc(int n2) {
        long l2;
        try {
            l2 = INVOKE_MALLOC.invokeExact(n2);
        }
        catch (Throwable throwable) {
            throw new Error(throwable);
        }
        if (l2 == 0L) {
            throw new OutOfMemoryError("malloc(2) failed to allocate " + n2 + " bytes");
        }
        return l2;
    }

    static void free(long l2) {
        try {
            INVOKE_FREE.invokeExact(l2);
        }
        catch (Throwable throwable) {
            throw new Error(throwable);
        }
    }

    static {
        Throwable throwable;
        MethodHandle methodHandle;
        MethodHandle methodHandle2;
        boolean bl2;
        Object object;
        if (System.getProperty("org.graalvm.nativeimage.imagecode") != null) {
            object = System.getProperty("java.specification.version");
            try {
                bl2 = Integer.parseInt((String)object) >= 25;
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
            }
            logger = null;
        } else {
            bl2 = PlatformDependent0.javaVersion() >= 24;
            logger = InternalLoggerFactory.getInstance(CleanerJava24Linker.class);
        }
        if (bl2) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> clazz = Class.forName("java.lang.Module");
                MethodHandle methodHandle3 = lookup.findVirtual(Class.class, "getModule", MethodType.methodType(clazz));
                MethodHandle methodHandle4 = lookup.findVirtual(clazz, "isNativeAccessEnabled", MethodType.methodType(Boolean.TYPE));
                MethodHandle methodHandle5 = MethodHandles.filterArguments(methodHandle4, 0, methodHandle3);
                boolean bl3 = methodHandle5.invokeExact(CleanerJava24Linker.class);
                if (!bl3) {
                    throw new UnsupportedOperationException("Native access (restricted methods) is not enabled for the io.netty.common module.");
                }
                Class<?> clazz2 = Class.forName("java.lang.foreign.MemoryLayout");
                Class<?> clazz3 = Class.forName("[Ljava.lang.foreign.MemoryLayout;");
                Class<?> clazz4 = Class.forName("java.lang.foreign.ValueLayout");
                Class<?> clazz5 = Class.forName("java.lang.foreign.AddressLayout");
                MethodHandle methodHandle6 = lookup.findStaticGetter(clazz4, "ADDRESS", clazz5);
                MethodHandle methodHandle7 = lookup.findVirtual(clazz5, "byteSize", MethodType.methodType(Long.TYPE));
                MethodHandle methodHandle8 = MethodHandles.foldArguments(methodHandle7, methodHandle6);
                long l2 = methodHandle8.invokeExact();
                if (l2 != 8L) {
                    throw new UnsupportedOperationException("Linking to malloc and free is only supported on 64-bit platforms.");
                }
                Class<?> clazz6 = Class.forName("java.lang.foreign.ValueLayout$OfLong");
                Class<?> clazz7 = Class.forName("java.lang.foreign.Linker");
                Class<?> clazz8 = Class.forName("java.lang.foreign.Linker$Option");
                Class<?> clazz9 = Class.forName("[Ljava.lang.foreign.Linker$Option;");
                Class<?> clazz10 = Class.forName("java.lang.foreign.SymbolLookup");
                Class<?> clazz11 = Class.forName("java.lang.foreign.MemorySegment");
                Class<?> clazz12 = Class.forName("java.lang.foreign.FunctionDescriptor");
                MethodHandle methodHandle9 = lookup.findStatic(clazz7, "nativeLinker", MethodType.methodType(clazz7));
                MethodHandle methodHandle10 = MethodHandles.foldArguments(lookup.findVirtual(clazz7, "defaultLookup", MethodType.methodType(clazz10)), methodHandle9);
                MethodHandle methodHandle11 = MethodHandles.foldArguments(lookup.findVirtual(clazz7, "downcallHandle", MethodType.methodType(MethodHandle.class, clazz11, clazz12, clazz9)), methodHandle9);
                MethodHandle methodHandle12 = MethodHandles.foldArguments(lookup.findVirtual(clazz10, "findOrThrow", MethodType.methodType(clazz11, String.class)), methodHandle10);
                Object object2 = lookup.findStaticGetter(clazz4, "JAVA_LONG", clazz6).invoke();
                Object object3 = Array.newInstance(clazz2, 1);
                Array.set(object3, 0, object2);
                MethodHandle methodHandle13 = MethodHandles.insertArguments(lookup.findStatic(clazz12, "of", MethodType.methodType(clazz12, clazz2, clazz3)), 0, object2, object3);
                MethodHandle methodHandle14 = MethodHandles.foldArguments(MethodHandles.foldArguments(methodHandle11, MethodHandles.foldArguments(methodHandle12, MethodHandles.constant(String.class, "malloc"))), methodHandle13);
                object = methodHandle14.invoke(Array.newInstance(clazz8, 0));
                MethodHandle methodHandle15 = MethodHandles.insertArguments(lookup.findStatic(clazz12, "ofVoid", MethodType.methodType(clazz12, clazz3)), 0, object3);
                MethodHandle methodHandle16 = MethodHandles.foldArguments(MethodHandles.foldArguments(methodHandle11, MethodHandles.foldArguments(methodHandle12, MethodHandles.constant(String.class, "free"))), methodHandle15);
                methodHandle2 = methodHandle16.invoke(Array.newInstance(clazz8, 0));
                MethodHandle methodHandle17 = lookup.findStatic(clazz11, "ofAddress", MethodType.methodType(clazz11, Long.TYPE));
                MethodHandle methodHandle18 = lookup.findVirtual(clazz11, "reinterpret", MethodType.methodType(clazz11, Long.TYPE));
                MethodHandle methodHandle19 = lookup.findVirtual(clazz11, "asByteBuffer", MethodType.methodType(ByteBuffer.class));
                methodHandle = MethodHandles.filterReturnValue(MethodHandles.filterArguments(methodHandle18, 0, methodHandle17), methodHandle19);
                throwable = null;
            }
            catch (Throwable throwable2) {
                object = null;
                methodHandle = null;
                methodHandle2 = null;
                throwable = throwable2;
            }
        } else {
            object = null;
            methodHandle = null;
            methodHandle2 = null;
            throwable = new UnsupportedOperationException("java.lang.foreign.MemorySegment unavailable");
        }
        if (logger != null) {
            if (throwable == null) {
                logger.debug("java.nio.ByteBuffer.cleaner(): available");
            } else {
                logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
            }
        }
        INVOKE_MALLOC = object;
        INVOKE_CREATE_BYTEBUFFER = methodHandle;
        INVOKE_FREE = methodHandle2;
    }

    private static final class CleanableDirectBufferImpl
    implements CleanableDirectBuffer {
        private final ByteBuffer buffer;
        private final long memoryAddress;

        private CleanableDirectBufferImpl(int n2) {
            long l2 = CleanerJava24Linker.malloc(n2);
            try {
                this.memoryAddress = l2;
                this.buffer = INVOKE_CREATE_BYTEBUFFER.invokeExact(l2, n2);
            }
            catch (Throwable throwable) {
                Error error = new Error(throwable);
                try {
                    CleanerJava24Linker.free(l2);
                }
                catch (Throwable throwable2) {
                    error.addSuppressed(throwable2);
                }
                throw error;
            }
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void clean() {
            CleanerJava24Linker.free(this.memoryAddress);
        }

        @Override
        public boolean hasMemoryAddress() {
            return true;
        }

        @Override
        public long memoryAddress() {
            return this.memoryAddress;
        }
    }
}

